/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class PSSPartitionScanner
extends BufferedRuleBasedScanner
implements IPartitionTokenScanner {
    public static final int ML_COMMENT = 0;
    public static final int SL_COMMENT = 1;
    public static final int LITERAL = 2;
    public static final int EXPANSION_LITERAL_START = 3;
    public static final int EXPANSION_LITERAL = 4;
    public static final int CODE = 5;
    public static final int ESCAPED_ID = 6;
    private int fState = 5;
    private int fTokenLength;
    private boolean fBackslash;
    private boolean fIgnoreNextNL;
    private int fChar = 97;
    private boolean fLimitPartitionLength;

    public PSSPartitionScanner() {
        this.fLimitPartitionLength = true;
    }

    public PSSPartitionScanner(boolean limitPartitionLength) {
        this.fLimitPartitionLength = limitPartitionLength;
    }

    public IToken nextToken() {
        this.fBackslash = false;
        IToken result = this.internalNextToken();
        return result;
    }

    public int read() {
        ++this.fTokenLength;
        return super.read();
    }

    public void unread() {
        --this.fTokenLength;
        super.unread();
    }

    private final IToken internalNextToken() {
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fOffset - this.fTokenOffset;
        while ((this.fChar = this.read()) != -1) {
            boolean forceBackslash = false;
            switch (this.fState) {
                case 5: {
                    int ch;
                    if (this.fLimitPartitionLength && this.fTokenLength > 2000 && (this.fChar == 13 || this.fChar == 10)) {
                        this.fBackslash = false;
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    if (this.fChar == 47) {
                        ch = this.read();
                        this.unread();
                        if (ch == 42) {
                            this.fState = 0;
                            if (this.fTokenLength > 1) {
                                this.unread();
                                return new Token((Object)"__dftl_partition_content_type");
                            }
                        }
                        if (ch != 47) break;
                        this.fState = 1;
                        if (this.fTokenLength <= 1) break;
                        this.unread();
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    if (this.fBackslash && !Character.isWhitespace(this.fChar)) {
                        this.unread();
                        this.unread();
                        this.fBackslash = false;
                        this.fState = 6;
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    if (this.fChar != 34) break;
                    int ch1 = this.read();
                    int ch2 = this.read();
                    this.unread();
                    this.unread();
                    int n = this.fState = ch1 == 34 && ch2 == 34 ? 3 : 2;
                    if (this.fTokenLength <= 1) break;
                    this.unread();
                    return new Token((Object)"__dftl_partition_content_type");
                }
                case 3: {
                    if (this.fTokenLength <= 2) break;
                    this.fState = 4;
                    break;
                }
                case 4: {
                    if (this.fChar != 34) break;
                    int ch1 = this.read();
                    int ch2 = this.read();
                    if (ch1 == 34 && ch2 == 34) {
                        this.fState = 5;
                        return new Token((Object)"__pss_expansion");
                    }
                    this.unread();
                    this.unread();
                    break;
                }
                case 6: {
                    if (!Character.isWhitespace(this.fChar)) break;
                    this.fState = 5;
                    return new Token((Object)"__pss_escaped_id");
                }
                case 2: {
                    if (this.fLimitPartitionLength && this.fTokenLength > 2000 && (this.fChar == 13 || this.fChar == 10)) {
                        return new Token((Object)"__pss_literal");
                    }
                    if (this.fBackslash) {
                        if (!Character.isWhitespace(this.fChar) || this.fChar == 13 || this.fChar == 10) break;
                        forceBackslash = true;
                        break;
                    }
                    if (this.fChar == 13 || !this.fIgnoreNextNL && this.fChar == 10) {
                        this.fState = 5;
                        return new Token((Object)"__pss_literal");
                    }
                    if (this.fChar != 34 || this.fTokenLength <= 1) break;
                    this.fState = 5;
                    return new Token((Object)"__pss_literal");
                }
                case 0: {
                    if (this.fLimitPartitionLength && this.fTokenLength > 2000 && (this.fChar == 13 || this.fChar == 10)) {
                        return new Token((Object)"__pss_ml_comment");
                    }
                    if (this.fChar != 42) break;
                    int ch = this.read();
                    if (ch == 47) {
                        this.fState = 5;
                        return new Token((Object)"__pss_ml_comment");
                    }
                    this.unread();
                    break;
                }
                case 1: {
                    if (this.fChar != 13 && this.fChar != 10) break;
                    if (this.fChar == 13 && this.read() != 10) {
                        this.unread();
                    }
                    this.fState = 5;
                    return new Token((Object)"__pss_sl_comment");
                }
            }
            this.fBackslash = !this.fBackslash && this.fChar == 92 ? true : forceBackslash;
            boolean bl = this.fIgnoreNextNL = this.fChar == 13;
        }
        if (this.fTokenLength > 2) {
            --this.fTokenLength;
            switch (this.fState) {
                case 5: 
                case 6: {
                    return new Token((Object)"__dftl_partition_content_type");
                }
                case 2: {
                    return new Token((Object)"__pss_literal");
                }
                case 4: {
                    return new Token((Object)"__pss_expansion");
                }
                case 0: {
                    return new Token((Object)"__pss_ml_comment");
                }
            }
            return new Token((Object)"__pss_sl_comment");
        }
        return Token.EOF;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        super.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset < 0 ? 0 : partitionOffset;
        this.fTokenLength = 0;
        this.fState = contentType == null ? 5 : (contentType.equals("__dftl_partition_content_type") ? 5 : (contentType.equals("__pss_literal") ? 2 : (contentType.equals("__pss_expansion") ? 3 : (contentType.equals("__pss_escaped_id") ? 6 : (contentType.equals("__pss_sl_comment") ? 1 : 0)))));
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fState = 5;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }
}

