/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingService;
import ro.amiq.dvt.ui.editor.spelling.DVTSpellingProblemCollector;

public class PSSReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private static final IContentType TEXT_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    private ISourceViewer fViewer;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private SpellingService fSpellingService;
    private ISpellingProblemCollector fSpellingProblemCollector;
    private SpellingContext fSpellingContext;

    public PSSReconcilingStrategy(ISourceViewer viewer, SpellingService spellingService) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)spellingService);
        this.fViewer = viewer;
        this.fSpellingService = spellingService;
        this.fSpellingContext = new SpellingContext();
        this.fSpellingContext.setContentType(this.getContentType());
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion region) {
        if (this.getAnnotationModel() == null || this.fSpellingProblemCollector == null) {
            return;
        }
        this.fSpellingService.check(this.fDocument, this.fSpellingContext, this.fSpellingProblemCollector, this.fProgressMonitor);
    }

    protected IContentType getContentType() {
        return TEXT_CONTENT_TYPE;
    }

    protected final IDocument getDocument() {
        return this.fDocument;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        this.fSpellingProblemCollector = this.createSpellingProblemCollector();
    }

    protected ISpellingProblemCollector createSpellingProblemCollector() {
        IAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return null;
        }
        return new DVTSpellingProblemCollector(model);
    }

    public final void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    protected IAnnotationModel getAnnotationModel() {
        return this.fViewer.getAnnotationModel();
    }
}

