/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.MacroTraceHoverSingleClickListener;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.DVTMultipleHyperlinkPresenter;
import ro.amiq.dvt.ui.editor.DVTPresentationReconciler;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.ExternalToolsAnnotationClickListener;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.IDVTFormattingStrategy;
import ro.amiq.dvt.ui.editor.hover.AnnotationExpandHover;
import ro.amiq.dvt.ui.editor.hover.ISingleClickListener;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixConstants;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.editor.spelling.WordQuickFixProcessor;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.model.debug.ui.editor.hover.PSSDebugTextHoverParticipant;
import ro.amiq.pssdt.ui.editor.PSSCodeScanner;
import ro.amiq.pssdt.ui.editor.PSSCommentScanner;
import ro.amiq.pssdt.ui.editor.PSSDoubleClickStrategy;
import ro.amiq.pssdt.ui.editor.PSSEditor;
import ro.amiq.pssdt.ui.editor.PSSExpansionScanner;
import ro.amiq.pssdt.ui.editor.PSSNonRuleBasedDamagerRepairer;
import ro.amiq.pssdt.ui.editor.PSSPartitionScanner;
import ro.amiq.pssdt.ui.editor.PSSReconciler;
import ro.amiq.pssdt.ui.editor.PSSReconcilingStrategy;
import ro.amiq.pssdt.ui.editor.PSSStyle;
import ro.amiq.pssdt.ui.editor.contentassist.PSSContentAssistProcessorManager;
import ro.amiq.pssdt.ui.editor.contentassist.PSSKeywordContentAssistProcessor;
import ro.amiq.pssdt.ui.editor.contentassist.PSSTemplateContentAssistProcessor;
import ro.amiq.pssdt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.pssdt.ui.editor.edit.strategy.PSSCodeAutoEditStrategy;
import ro.amiq.pssdt.ui.editor.edit.strategy.PSSCommentAutoEditStrategy;
import ro.amiq.pssdt.ui.editor.formatter.PSSCodeFormattingStrategy;
import ro.amiq.pssdt.ui.editor.formatter.PSSContentFormatter;
import ro.amiq.pssdt.ui.editor.formatter.PSSEscapedIDFormattingStrategy;
import ro.amiq.pssdt.ui.editor.formatter.PSSExpansionFormattingStrategy;
import ro.amiq.pssdt.ui.editor.formatter.PSSFormattingPreferences;
import ro.amiq.pssdt.ui.editor.formatter.PSSLiteralFormattingStrategy;
import ro.amiq.pssdt.ui.editor.formatter.PSSMLCommentFormattingStrategy;
import ro.amiq.pssdt.ui.editor.formatter.PSSSLCommentFormattingStrategy;
import ro.amiq.pssdt.ui.editor.hover.PSSDefaultAnnotationHover;
import ro.amiq.pssdt.ui.editor.hover.PSSTextHover;
import ro.amiq.pssdt.ui.editor.hover.PSSTextHoverParticipant;
import ro.amiq.pssdt.ui.editor.hyperlink.CommentHyperlinkDetector;
import ro.amiq.pssdt.ui.editor.hyperlink.RfHyperlinkDetector;
import ro.amiq.pssdt.ui.editor.quickfix.PSSEditorQuickFixProcessor;
import ro.amiq.pssdt.ui.preferences.PrefConst;

public class PSSSourceViewerConfiguration
extends DVTSourceViewerConfiguration {
    private PSSCodeScanner fCodeScanner;
    private PSSCommentScanner fCommentScanner;
    private PSSExpansionScanner fExpansionScanner;
    private PSSEditor fEditor;
    private ITextDoubleClickStrategy fDoubleClickStrategy;
    private IPropertyChangeListener fPrefListener;
    private ITextHover fTextHover;
    protected String[] fConfiguredContentType = new String[]{"__dftl_partition_content_type", "__pss_literal", "__pss_expansion", "__pss_escaped_id", "__pss_sl_comment", "__pss_ml_comment"};
    private DVTPresentationReconciler fPresentationReconciler;
    private AnnotationExpandHover fAnnotationHover;
    private PSSReconcilingStrategy fReconcilingStrategy;
    private PSSCodeFormattingStrategy fCodeStrategy;
    private PSSSLCommentFormattingStrategy fSLCommentStrategy;
    private PSSMLCommentFormattingStrategy fMLCommentStrategy;
    private PSSEscapedIDFormattingStrategy fEscapedIDStrategy;
    private PSSLiteralFormattingStrategy fLiteralStrategy;
    private PSSExpansionFormattingStrategy fExpansionStrategy;
    private PSSContentAssistProcessorManager fSourceProcessorManager;
    private ContentAssistant fContentAssistant;
    private PSSCodeAutoEditStrategy fCodeAutoEditStrategy;
    private IDialogSettings fDialogSettings;
    private DVTContentFormatter fFormatter;

    public PSSSourceViewerConfiguration(PSSEditor editor) {
        super(PSSPlugin.getDefault().getCombinedPreferenceStore());
        this.fEditor = editor;
        this.fCodeAutoEditStrategy = null;
    }

    public void refreshLineDelimiter() {
        this.fLineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)this.fEditor);
    }

    protected void setProjectionAnnotationModel(ProjectionAnnotationModel model) {
        this.fPresentationReconciler.setProjectionAnnotationModel(model);
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return new DVTMultipleHyperlinkPresenter(new RGB(0, 0, 255));
        }
        return new DVTMultipleHyperlinkPresenter(this.fPreferenceStore);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.fConfiguredContentType;
    }

    public void setConfiguredContentTypes(String[] configuredContentType) {
        this.fConfiguredContentType = configuredContentType;
    }

    protected PSSCodeScanner getPSSCodeScanner(int nofLinesFolding) {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new PSSCodeScanner(PSSStyle.getInstance(), nofLinesFolding);
            this.fCodeScanner.setDefaultReturnToken(PSSStyle.getInstance().getToken("highlight.default"));
        }
        return this.fCodeScanner;
    }

    protected PSSCommentScanner getPSSCommentScanner(int nofLinesFolding) {
        if (this.fCommentScanner == null) {
            this.fCommentScanner = new PSSCommentScanner(PSSStyle.getInstance(), true, nofLinesFolding, this.isInspectView(), this.fEditor != null ? this.fEditor.getProject() : null);
            this.fCommentScanner.setDefaultReturnToken(PSSStyle.getInstance().getToken("highlight.comment"));
        }
        return this.fCommentScanner;
    }

    protected PSSExpansionScanner getPSSExpansionScanner(int nofLinesFolding) {
        if (this.fExpansionScanner == null) {
            this.fExpansionScanner = new PSSExpansionScanner(PSSStyle.getInstance(), nofLinesFolding);
            this.fExpansionScanner.setDefaultReturnToken(PSSStyle.getInstance().getToken("highlight.default"));
        }
        return this.fExpansionScanner;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__pss_partitioning";
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fEditor == null) {
            return null;
        }
        this.fReconcilingStrategy = new PSSReconcilingStrategy(sourceViewer, EditorsUI.getSpellingService());
        IDocument document = sourceViewer.getDocument();
        this.fReconcilingStrategy.setDocument(document);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)this.fReconcilingStrategy, false);
        reconciler.setDelay(500);
        this.setReconciler(reconciler);
        return reconciler;
    }

    public static void updatePresentationReconciler(IPresentationReconciler reconciler) {
        IToken token1 = PSSStyle.getInstance().getToken("highlight.string");
        ((PSSNonRuleBasedDamagerRepairer)reconciler.getDamager("__pss_literal")).setToken(token1);
        ((PSSNonRuleBasedDamagerRepairer)reconciler.getRepairer("__pss_literal")).setToken(token1);
        IToken token2 = PSSStyle.getInstance().getToken("highlight.escaped_id");
        ((PSSNonRuleBasedDamagerRepairer)reconciler.getDamager("__pss_escaped_id")).setToken(token2);
        ((PSSNonRuleBasedDamagerRepairer)reconciler.getRepairer("__pss_escaped_id")).setToken(token2);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.fPresentationReconciler == null) {
            int foldingEnabled;
            this.fPresentationReconciler = new DVTPresentationReconciler();
            this.fPresentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            int nofLines = PrefConst.getCodeFoldingNofLines();
            boolean enable = PrefConst.isCodeFoldingEnabled();
            boolean manualEnable = PrefConst.isManualCodeFoldingEnabled();
            int n = foldingEnabled = !enable ? 0 : nofLines;
            int manualFoldingEnabled = !manualEnable ? 0 : (!enable ? 0 : nofLines);
            this.fPresentationReconciler.setNofLinesFolding(foldingEnabled);
            PSSReconciler dr1 = new PSSReconciler((ITokenScanner)this.getPSSCodeScanner(foldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr1, "__dftl_partition_content_type");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr1, "__dftl_partition_content_type");
            PSSReconciler dr2 = new PSSReconciler((ITokenScanner)this.getPSSCommentScanner(manualFoldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr2, "__pss_sl_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr2, "__pss_sl_comment");
            PSSReconciler dr3 = new PSSReconciler((ITokenScanner)this.getPSSCommentScanner(manualFoldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr3, "__pss_ml_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr3, "__pss_ml_comment");
            PSSReconciler dr4 = new PSSReconciler((ITokenScanner)this.getPSSExpansionScanner(manualFoldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr4, "__pss_expansion");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr4, "__pss_expansion");
            IToken token1 = PSSStyle.getInstance().getToken("highlight.string");
            PSSNonRuleBasedDamagerRepairer ndr1 = new PSSNonRuleBasedDamagerRepairer(token1);
            this.fPresentationReconciler.setDamager((IPresentationDamager)ndr1, "__pss_literal");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)ndr1, "__pss_literal");
            IToken token3 = PSSStyle.getInstance().getToken("highlight.escaped_id");
            PSSNonRuleBasedDamagerRepairer ndr2 = new PSSNonRuleBasedDamagerRepairer(token3);
            this.fPresentationReconciler.setDamager((IPresentationDamager)ndr2, "__pss_escaped_id");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)ndr2, "__pss_escaped_id");
            this.fPrefListener = Utils.setUpFoldingPreferencesListener((IPreferenceStore)PSSPlugin.getDefault().getPreferenceStore(), (String)"editor.codeFolding", (String)"editor.manualCodeFolding", (String)"editor.numberOfLines", (DVTPresentationReconciler)this.fPresentationReconciler, (DVTBaseScanner)this.fCodeScanner, (DVTBaseScanner)this.fCommentScanner, (DVTBaseScanner)this.fExpansionScanner);
        }
        return this.fPresentationReconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fAnnotationHover == null) {
            this.fAnnotationHover = new AnnotationExpandHover(new CompositeRuler(), (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), null, (ISingleClickListener)new MacroTraceHoverSingleClickListener());
            ExternalToolsAnnotationClickListener externalToolsListener = new ExternalToolsAnnotationClickListener();
            this.fAnnotationHover.addCustomClickListener(DVTProblemCategories.EXTERNALTOOLS.getMarkerId(), (ISingleClickListener)externalToolsListener);
        }
        return this.fAnnotationHover;
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new PSSDefaultAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fEditor == null) {
            return null;
        }
        if (this.fTextHover == null) {
            this.fTextHover = new PSSTextHover((ITextEditor)this.fEditor);
            ((PSSTextHover)this.fTextHover).addTextHoverParticipant(new PSSTextHoverParticipant());
            ((PSSTextHover)this.fTextHover).addTextHoverParticipant(new PSSDebugTextHoverParticipant());
        }
        return this.fTextHover;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        IInformationPresenter presenter = super.getInformationPresenter(sourceViewer);
        ITextHover textHover = this.getTextHover(sourceViewer, null);
        InformationProvider provider = new InformationProvider(textHover);
        ((InformationPresenter)presenter).setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        ((InformationPresenter)presenter).setInformationProvider((IInformationProvider)provider, "__pss_expansion");
        Point location = sourceViewer.getTextWidget().getSelectionRange();
        ((InformationPresenter)presenter).setMargins(location.x, location.y);
        return presenter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new PSSDoubleClickStrategy(this.fBracketMatcher);
        }
        return this.fDoubleClickStrategy;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.fEditor == null) {
            return null;
        }
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        final WordQuickFixProcessor spellingQuickFix = new WordQuickFixProcessor((ITextEditor)this.fEditor);
        IQuickAssistProcessor processor = new IQuickAssistProcessor(){

            public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
                return false;
            }

            public boolean canFix(Annotation annotation) {
                if (annotation == null) {
                    return false;
                }
                String annotationType = annotation.getType();
                boolean spellingAssist = "org.eclipse.ui.workbench.texteditor.spelling".equals(annotationType);
                if (spellingAssist) {
                    return true;
                }
                if (annotation instanceof MarkerAnnotation) {
                    int quickFixKind;
                    block9: {
                        IMarker marker;
                        block8: {
                            marker = ((MarkerAnnotation)annotation).getMarker();
                            try {
                                if ("ro.amiq.pssdt.SemanticProblemMarker".equals(marker.getType())) break block8;
                                return false;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        String elementName = marker.getAttribute("QUICKFIX_ELEMENT_NAME", "");
                        int scopeOffset = marker.getAttribute("charStart", -1);
                        quickFixKind = marker.getAttribute("QUICKFIX_KIND", -1);
                        if (elementName != null && scopeOffset != -1 && quickFixKind != -1) break block9;
                        return false;
                    }
                    if (QuickFixConstants.IMPLEMENTED_QUICK_FIXES.contains(quickFixKind)) {
                        return true;
                    }
                }
                return false;
            }

            public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
                ICompletionProposal[] result = new PSSEditorQuickFixProcessor((ITextEditor)PSSSourceViewerConfiguration.this.fEditor).computeCompletionProposals((ITextViewer)invocationContext.getSourceViewer(), invocationContext.getOffset());
                if (result != null && result.length > 0) {
                    return result;
                }
                result = spellingQuickFix.computeCompletionProposals((ITextViewer)invocationContext.getSourceViewer(), invocationContext.getOffset());
                if (result != null && result.length > 0) {
                    return result;
                }
                return new ICompletionProposal[]{DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE};
            }

            public String getErrorMessage() {
                return null;
            }
        };
        assistant.setQuickAssistProcessor(processor);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fEditor == null) {
            return null;
        }
        this.fContentAssistant = new ContentAssistant();
        this.fContentAssistant.enableColoredLabels(true);
        this.fContentAssistant.setRepeatedInvocationMode(true);
        this.fContentAssistant.setStatusLineVisible(true);
        this.fContentAssistant.setStatusMessage("Press 'Ctrl+Space' to show Template proposals");
        this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.fSourceProcessorManager = new PSSContentAssistProcessorManager(this.fEditor, this.fContentAssistant);
        this.fContentAssistant.addCompletionListener((ICompletionListener)this.fSourceProcessorManager);
        this.fSourceProcessorManager.addContentAssistProcessor(new RfContentAssistProcessor(this.fSourceProcessorManager));
        this.fSourceProcessorManager.addContentAssistProcessor(new PSSKeywordContentAssistProcessor(this.fSourceProcessorManager));
        this.fSourceProcessorManager.addContentAssistProcessor((IContentAssistProcessor)new PSSTemplateContentAssistProcessor(this.fEditor, this.fSourceProcessorManager));
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fSourceProcessorManager, "__dftl_partition_content_type");
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fSourceProcessorManager, "__pss_expansion");
        this.fContentAssistant.setContextInformationPopupOrientation(20);
        this.fContentAssistant.enableAutoActivation(true);
        this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        this.fDialogSettings = new DialogSettings("dvt.contentAssist");
        this.fContentAssistant.setRestoreCompletionProposalSize(this.fDialogSettings);
        return this.fContentAssistant;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.fEditor == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 2];
        detectors[0] = new RfHyperlinkDetector((ITextEditor)this.fEditor);
        detectors[1] = new CommentHyperlinkDetector(this.fEditor);
        if (inheritedDetectors != null) {
            int i = 0;
            while (i < inheritedDetectorsLength) {
                detectors[i + 2] = inheritedDetectors[i];
                ++i;
            }
        }
        return detectors;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        PSSStyle.getInstance().adaptToPreferenceChange(event);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        if (this.fFormatter != null) {
            this.fFormatter.dispose();
        }
        this.fFormatter = new PSSContentFormatter(this);
        this.fFormatter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        PSSFormattingPreferences formatPreferences = PSSFormattingPreferences.getInstance();
        this.fCodeStrategy = new PSSCodeFormattingStrategy(this, formatPreferences);
        this.fSLCommentStrategy = new PSSSLCommentFormattingStrategy(this, formatPreferences);
        this.fMLCommentStrategy = new PSSMLCommentFormattingStrategy(this, formatPreferences);
        this.fLiteralStrategy = new PSSLiteralFormattingStrategy(this, formatPreferences);
        this.fExpansionStrategy = new PSSExpansionFormattingStrategy(this, formatPreferences);
        this.fEscapedIDStrategy = new PSSEscapedIDFormattingStrategy(this, formatPreferences);
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fCodeStrategy, "__dftl_partition_content_type");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fSLCommentStrategy, "__pss_sl_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fMLCommentStrategy, "__pss_ml_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fLiteralStrategy, "__pss_literal");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fExpansionStrategy, "__pss_expansion");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fEscapedIDStrategy, "__pss_escaped_id");
        return this.fFormatter;
    }

    public DVTBaseCodeFormattingStrategy getCodeFormattingStrategy() {
        return this.fCodeStrategy;
    }

    public DVTBaseFormattingStrategy getSLCommentFormattingStrategy() {
        return this.fSLCommentStrategy;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] result = new IAutoEditStrategy[1];
        if (this.fCodeAutoEditStrategy == null) {
            this.fCodeAutoEditStrategy = new PSSCodeAutoEditStrategy(sourceViewer, this);
        }
        result[0] = "__dftl_partition_content_type".equals(contentType) ? this.fCodeAutoEditStrategy : ("__pss_literal".equals(contentType) ? this.fCodeAutoEditStrategy : ("__pss_expansion".equals(contentType) ? this.fCodeAutoEditStrategy : ("__pss_escaped_id".equals(contentType) ? this.fCodeAutoEditStrategy : ("__pss_ml_comment".equals(contentType) ? new PSSCommentAutoEditStrategy(this.fEditor) : new DefaultIndentLineAutoEditStrategy()))));
        return result;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", ""};
    }

    public PSSEditor getEditor() {
        return this.fEditor;
    }

    public IInformationPresenter getQuickViewerPresenter(ISourceViewer sourceViewer, IInformationControlCreator controlCreator) {
        QuickViewInfoProvider provider = new QuickViewInfoProvider();
        InformationPresenter presenter = new InformationPresenter(controlCreator);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__pss_escaped_id");
        presenter.setInformationProvider((IInformationProvider)provider, "__pss_literal");
        presenter.setInformationProvider((IInformationProvider)provider, "__pss_expansion");
        presenter.setInformationProvider((IInformationProvider)provider, "__pss_ml_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__pss_sl_comment");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    public void dispose() {
        super.dispose();
        if (this.fReconcilingStrategy != null) {
            this.fReconcilingStrategy.setDocument(null);
            this.fReconcilingStrategy = null;
        }
        if (this.fPrefListener != null) {
            PSSPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPrefListener);
        }
        this.fPrefListener = null;
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.setDamager(null, "__dftl_partition_content_type");
            this.fPresentationReconciler.setRepairer(null, "__dftl_partition_content_type");
            this.fPresentationReconciler.setDamager(null, "__pss_sl_comment");
            this.fPresentationReconciler.setRepairer(null, "__pss_sl_comment");
            this.fPresentationReconciler.setDamager(null, "__pss_ml_comment");
            this.fPresentationReconciler.setRepairer(null, "__pss_ml_comment");
            this.fPresentationReconciler.setDamager(null, "__pss_literal");
            this.fPresentationReconciler.setRepairer(null, "__pss_literal");
            this.fPresentationReconciler.setDamager(null, "__pss_expansion");
            this.fPresentationReconciler.setRepairer(null, "__pss_expansion");
            this.fPresentationReconciler.setDamager(null, "__pss_escaped_id");
            this.fPresentationReconciler.setRepairer(null, "__pss_escaped_id");
            this.fPresentationReconciler = null;
        }
        if (this.fCodeScanner != null) {
            this.fCodeScanner.dispose();
            this.fCodeScanner = null;
        }
        if (this.fCommentScanner != null) {
            this.fCommentScanner.dispose();
            this.fCommentScanner = null;
        }
        this.fTextHover = null;
        if (this.fLiteralStrategy != null) {
            this.fLiteralStrategy.dispose();
            this.fLiteralStrategy = null;
        }
        if (this.fExpansionStrategy != null) {
            this.fExpansionStrategy.dispose();
            this.fExpansionStrategy = null;
        }
        if (this.fCodeStrategy != null) {
            this.fCodeStrategy.dispose();
            this.fCodeStrategy = null;
        }
        if (this.fSLCommentStrategy != null) {
            this.fSLCommentStrategy.dispose();
            this.fSLCommentStrategy = null;
        }
        this.fCodeAutoEditStrategy = null;
        this.fEditor = null;
        if (this.fContentAssistant != null) {
            if (this.fSourceProcessorManager != null) {
                this.fContentAssistant.removeCompletionListener((ICompletionListener)this.fSourceProcessorManager);
                this.fSourceProcessorManager = null;
            }
            this.fContentAssistant = null;
        }
        if (this.fFormatter != null) {
            this.fFormatter.dispose();
            this.fFormatter = null;
        }
    }

    public void setupDocumentPartitioner(IDocument document) {
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new PSSPartitionScanner(), new String[]{"__pss_sl_comment", "__pss_ml_comment", "__pss_escaped_id", "__pss_literal", "__pss_expansion", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__pss_partitioning", (IDocumentPartitioner)partitioner);
            partitioner.connect(document);
        }
    }

    public void connectCFDocumentPartitioner(IDocument document) {
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new PSSPartitionScanner(false), new String[]{"__pss_sl_comment", "__pss_ml_comment", "__pss_escaped_id", "__pss_literal", "__pss_expansion", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__cf_partitioning", (IDocumentPartitioner)partitioner);
            partitioner.connect(document);
        }
    }

    public void disconnectCFDocumentPartitioner(IDocument document) {
        IDocumentExtension3 extension;
        IDocumentPartitioner partitioner;
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3 && (partitioner = (extension = (IDocumentExtension3)document).getDocumentPartitioner("__cf_partitioning")) != null) {
            partitioner.disconnect();
        }
    }

    public PSSContentAssistProcessorManager getSourceProcessorManager() {
        return this.fSourceProcessorManager;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    private static final class InformationProvider
    implements IInformationProviderExtension,
    IInformationProviderExtension2,
    IInformationProvider {
        private final ITextHover textHover;

        private InformationProvider(ITextHover textHover) {
            this.textHover = textHover;
        }

        public IRegion getSubject(ITextViewer textViewer, final int offset) {
            return new IRegion(){

                public int getOffset() {
                    return offset;
                }

                public int getLength() {
                    return 1;
                }
            };
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.textHover.getHoverInfo(textViewer, subject);
        }

        public Object getInformation2(ITextViewer textViewer, IRegion hoverRegion) {
            return this.textHover instanceof PSSTextHover ? ((PSSTextHover)this.textHover).getHoverInfo2(textViewer, hoverRegion) : this.textHover.getHoverInfo(textViewer, hoverRegion);
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.textHover instanceof PSSTextHover ? ((PSSTextHover)this.textHover).getHoverControlCreator() : null;
        }
    }

    static class QuickViewInfoProvider
    implements IInformationProvider,
    IInformationProviderExtension {
        private Object fData;

        QuickViewInfoProvider() {
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return null;
        }

        public IRegion getSubject(ITextViewer textViewer, int offset) {
            return new Region(0, 1);
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fData;
        }

        public void setDataToShow(Object data) {
            this.fData = data;
        }
    }
}

