/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import ro.amiq.pssdt.core.PSSPlugin;

public class PSSStyle {
    protected Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);
    private static HashMap<String, Token> fTokenMap = new HashMap();
    private static Boolean fSemanticHighlight;
    private static volatile PSSStyle fInstance;
    private HighlightPreferenceListener fPreferenceListener = new HighlightPreferenceListener();
    private IPreferenceStore fStore = PSSPlugin.getDefault().getPreferenceStore();
    private static Boolean fXTemplateIdentifierHighlight;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PSSStyle getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new PSSStyle();
            }
        }
        return fInstance;
    }

    public PSSStyle() {
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    public void dispose() {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fPreferenceListener = null;
    }

    public boolean isSemanticHighlightEnabled() {
        if (fSemanticHighlight != null) {
            return fSemanticHighlight;
        }
        IPreferenceStore store = PSSPlugin.getDefault().getPreferenceStore();
        fSemanticHighlight = store.getBoolean("highlight.semantic.value");
        return fSemanticHighlight;
    }

    public boolean isXTemplateIdentifierHighlightEnabled() {
        if (fXTemplateIdentifierHighlight != null) {
            return fXTemplateIdentifierHighlight;
        }
        fXTemplateIdentifierHighlight = this.fStore.getBoolean("highlight.x_template_id.value");
        return fXTemplateIdentifierHighlight;
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public void updateTokens() {
        Iterator<Map.Entry<String, Token>> it = fTokenMap.entrySet().iterator();
        while (it.hasNext()) {
            IPreferenceStore store = PSSPlugin.getDefault().getPreferenceStore();
            Map.Entry<String, Token> pair = it.next();
            String key = pair.getKey();
            pair.getValue().setData((Object)new TextAttribute(this.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)(String.valueOf(key) + ".color"))), null, (store.getBoolean(String.valueOf(key) + ".bold") ? 1 : 0) | (store.getBoolean(String.valueOf(key) + ".italic") ? 2 : 0) | (key.contains("highlight.comment_hyperlink") ? 0x40000000 : 0)));
        }
    }

    public IToken getToken(String key) {
        Token res = fTokenMap.get(key);
        if (res != null) {
            return res;
        }
        IPreferenceStore store = PSSPlugin.getDefault().getPreferenceStore();
        res = new Token((Object)new TextAttribute(this.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)(String.valueOf(key) + ".color"))), null, (store.getBoolean(String.valueOf(key) + ".bold") ? 1 : 0) | (store.getBoolean(String.valueOf(key) + ".italic") ? 2 : 0) | (key.contains("highlight.comment_hyperlink") ? 0x40000000 : 0)));
        fTokenMap.put(key, res);
        return res;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        if (p.endsWith(".color")) {
            this.adaptColorChange(fTokenMap.get(p.substring(0, p.length() - ".color".length())), event);
        } else if (p.endsWith(".bold")) {
            this.adaptToStyleChange(fTokenMap.get(p.substring(0, p.length() - ".bold".length())), event, 1);
        } else if (p.endsWith(".italic")) {
            this.adaptToStyleChange(fTokenMap.get(p.substring(0, p.length() - ".italic".length())), event, 2);
        } else if (p.endsWith(".semantic.value")) {
            boolean eventValue = false;
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                eventValue = (Boolean)value;
            } else if ("true".equals(value)) {
                eventValue = true;
            }
            fSemanticHighlight = eventValue;
        } else if (p.endsWith(".x_template_id.value")) {
            boolean eventValue = false;
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                eventValue = (Boolean)value;
            } else if ("true".equals(value)) {
                eventValue = true;
            }
            fXTemplateIdentifierHighlight = eventValue;
        }
    }

    private void adaptColorChange(Token token, PropertyChangeEvent event) {
        Object data;
        if (token == null) {
            return;
        }
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null && (data = token.getData()) instanceof TextAttribute) {
            TextAttribute oldAttr = (TextAttribute)data;
            token.setData((Object)new TextAttribute(this.getColor(rgb), oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        if (token == null) {
            return;
        }
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }

    private class HighlightPreferenceListener
    implements IPropertyChangeListener {
        private HighlightPreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!event.getProperty().startsWith("highlight")) {
                return;
            }
            PSSStyle.this.adaptToPreferenceChange(event);
        }
    }
}

