/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTProposalContextInformation;
import ro.amiq.dvt.ui.editor.DvtContextInformationType;
import ro.amiq.dvt.ui.editor.contentasisst.DVTContentAssistProcessorManager;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTContentAssistConstants;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.r2lparser.R2LBusy;
import ro.amiq.pssdt.r2lparser.R2LNoProposalElement;
import ro.amiq.pssdt.r2lparser.R2LUtils;
import ro.amiq.pssdt.ui.editor.PSSEditor;
import ro.amiq.pssdt.ui.editor.PSSWordFinder;
import ro.amiq.pssdt.ui.editor.contentassist.PSSKeywordContentAssistProcessor;
import ro.amiq.pssdt.ui.editor.contentassist.PSSParameterHintsUtils;
import ro.amiq.pssdt.ui.editor.contentassist.PSSParameterListValidator;
import ro.amiq.pssdt.ui.editor.contentassist.PSSTemplateContentAssistProcessor;
import ro.amiq.pssdt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.pssdt.ui.editor.contentassist.RfLazyCompletionProposal;

public class PSSContentAssistProcessorManager
extends DVTContentAssistProcessorManager {
    private ArrayList<IContentAssistProcessor> fProcessors = new ArrayList();
    private PSSEditor fEditor;
    private ContentAssistant fContentAssistant;
    protected IRfScope fRfScope;
    public String fCurrentWord;
    protected boolean fIsPartial;
    private RfProject fRfProject;
    private IDocument fDocument;
    private RfDefElement fInitialScope;
    private boolean fAlreadyComputed;
    public static final Comparator<ICompletionProposal> fLexicalSorter = new Comparator<ICompletionProposal>(){

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            return o1.getDisplayString().compareTo(o2.getDisplayString());
        }
    };

    public PSSContentAssistProcessorManager(PSSEditor vEditor, ContentAssistant assistant) {
        this.fEditor = vEditor;
        this.fContentAssistant = assistant;
        this.fIsPartial = false;
    }

    public void addContentAssistProcessor(IContentAssistProcessor processor) {
        this.fProcessors.add(processor);
    }

    public IFile getFile() {
        if (this.fEditor == null) {
            return null;
        }
        if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        return file;
    }

    public RfFileDef getFileDef() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return rfProject.getFile((IResource)file);
    }

    public RfDefElement getInitialScope() {
        return this.fInitialScope;
    }

    public int getNofProcessors() {
        return 2;
    }

    public ICompletionProposal[] nonUiComputeCompletionProposals(ITextViewer viewer, int offset) {
        block21: {
            block23: {
                block22: {
                    block20: {
                        block19: {
                            if (this.fEditor != null) break block19;
                            return null;
                        }
                        if (this.init(viewer, offset)) break block20;
                        return null;
                    }
                    if (offset != this.getPrevOffset()) break block22;
                    int crtContentAssistPage = this.getCrtContentAssistPage();
                    switch (IDVTContentAssistConstants.ContentAssistProposalsPage.from((int)crtContentAssistPage)) {
                        case DEFAULT: {
                            this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Template proposals");
                            break;
                        }
                        case TEMPLATES: {
                            this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Default proposals");
                            for (IContentAssistProcessor processor : this.fProcessors) {
                                if (!(processor instanceof TemplateCompletionProcessor)) continue;
                                ICompletionProposal[] proposals = processor.computeCompletionProposals(viewer, offset);
                                if (proposals == null || proposals.length == 0) {
                                    proposals = this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
                                }
                                return proposals;
                            }
                        }
                    }
                    break block23;
                }
                this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Template proposals");
            }
            RfFileDef file = this.getFileDef();
            RfProject project = this.getProject();
            if (file == null || project == null) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                for (IContentAssistProcessor processor : this.fProcessors) {
                    if (!(processor instanceof PSSTemplateContentAssistProcessor) && !(processor instanceof PSSKeywordContentAssistProcessor)) continue;
                    this.addProposalsToList(processor.computeCompletionProposals(viewer, offset), proposals);
                }
                if (proposals.isEmpty()) {
                    proposals.add(this.getNoProposal(viewer, offset));
                }
                return this.getProposalArray(proposals);
            }
            this.fRfScope = file.getScope(offset);
            if (this.fRfScope != null) break block21;
            return null;
        }
        try {
            IRegion region = PSSWordFinder.getDefault().getWordAtOffset(this.fDocument, offset);
            if (region.getLength() != 0) {
                this.fCurrentWord = this.fDocument.get(region.getOffset(), offset - region.getOffset());
                this.fIsPartial = true;
            } else {
                this.fCurrentWord = this.fDocument.get(region.getOffset(), region.getLength());
                this.fIsPartial = false;
            }
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            boolean isNoProposal = false;
            for (IContentAssistProcessor processor : this.fProcessors) {
                this.addProposalsToList(processor.computeCompletionProposals(viewer, offset), proposals);
                if (!(processor instanceof RfContentAssistProcessor) || proposals.isEmpty() || !(proposals.get(0) instanceof RfLazyCompletionProposal) || !((RfLazyCompletionProposal)proposals.get(0)).isNoProposal()) continue;
                isNoProposal = true;
            }
            if (isNoProposal && proposals.size() > 1) {
                proposals.remove(0);
            }
            if (proposals.isEmpty()) {
                proposals.add(this.getNoProposal(viewer, offset));
            }
            return this.getProposalArray(proposals);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
        }
    }

    private boolean init(ITextViewer viewer, int offset) {
        if (this.fAlreadyComputed) {
            return true;
        }
        this.fDocument = viewer.getDocument();
        if (this.fDocument == null) {
            return false;
        }
        if (this.fEditor.getEditorInput() instanceof FileEditorInput) {
            IFile fFile = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
            if (fFile == null) {
                return false;
            }
            IProject project = fFile.getProject();
            if (project != null) {
                RfFileDef fileDef;
                if (!DVTPlugin.getDefault().collect().c(project, "F707373")) {
                    return false;
                }
                this.fRfProject = RfManager.getInstance().getRfProject(project);
                if (this.fRfProject != null && (fileDef = this.fRfProject.getFile((IResource)fFile)) != null) {
                    this.fInitialScope = fileDef.getScope(offset);
                }
            }
        }
        return true;
    }

    public static Comparator<? super IRfNamedElement> getContextSorter(String prefix) {
        return R2LUtils.getContextSorter(prefix);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        if (!this.init(viewer, offset)) {
            return null;
        }
        RfNamedElement element = PSSParameterHintsUtils.getElementNamedElementAtOffset(this.fRfProject, this.getFile(), this.fEditor, offset, this.fInitialScope.getStartOffset());
        if (element == null) {
            return null;
        }
        String elementName = "";
        String elementArguments = "";
        int contextInformationStartOffset = PSSParameterHintsUtils.getContextInformationOffset(this.fDocument, offset, this.fInitialScope, elementName, this.fEditor, false, false);
        if (contextInformationStartOffset < 0) {
            return null;
        }
        int contextInformationEndOffset = PSSParameterHintsUtils.getContextInformationOffset(this.fDocument, offset, this.fInitialScope, elementName, this.fEditor, true, false) - 1;
        if (contextInformationEndOffset < 0) {
            return null;
        }
        DVTProposalContextInformation contextInformation = new DVTProposalContextInformation(DvtContextInformationType.ARGUMENTS_OR_ORDERED_PORT_CONNECTIONS, elementArguments, elementArguments, contextInformationStartOffset, contextInformationEndOffset - contextInformationStartOffset, "__pss_partitioning");
        IContextInformation[] contextInformations = new IContextInformation[]{contextInformation};
        return contextInformations;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new PSSParameterListValidator();
    }

    private void addProposalsToList(ICompletionProposal[] props, List<ICompletionProposal> results) {
        if (props == null) {
            return;
        }
        int i = 0;
        while (i < props.length) {
            results.add(props[i]);
            ++i;
        }
    }

    private ICompletionProposal[] getProposalArray(List<ICompletionProposal> proposals) {
        ICompletionProposal[] result = new ICompletionProposal[proposals.size()];
        int i = 0;
        while (i < proposals.size()) {
            result[i] = proposals.get(i);
            ++i;
        }
        return result;
    }

    protected RfProject getProject() {
        if (this.fEditor == null) {
            return null;
        }
        if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        return RfManager.getInstance().getRfProject(project);
    }

    public String getContextType() {
        if (this.fRfScope != null) {
            RfNamedElement namedElement = this.fRfScope.getNamedElement();
            if (namedElement == null) {
                return this.fRfScope.getContextType();
            }
            return namedElement.getContextType();
        }
        return "ro.amiq.pssdt.templates.contextType.component";
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public ICompletionProposal[] computeTemplatesProposals(ITextViewer viewer, int offset) {
        IDocument document;
        block12: {
            block11: {
                block10: {
                    if (DVTPlugin.getDefault().collect().c(this.getProject().getProject(), "F707373")) break block10;
                    return null;
                }
                document = viewer.getDocument();
                if (document != null) break block11;
                return null;
            }
            RfFileDef file = this.getFileDef();
            RfProject project = this.getProject();
            if (file == null || project == null) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                for (IContentAssistProcessor icap : this.fProcessors) {
                    if (!(icap instanceof PSSTemplateContentAssistProcessor) && !(icap instanceof PSSKeywordContentAssistProcessor)) continue;
                    this.addProposalsToList(icap.computeCompletionProposals(viewer, offset), proposals);
                }
                return this.getProposalArray(proposals);
            }
            this.fRfScope = file.getScope(offset);
            if (this.fRfScope != null) break block12;
            return null;
        }
        try {
            IRegion region = PSSWordFinder.getDefault().getWordAtOffset(document, offset);
            if (region.getLength() != 0) {
                this.fCurrentWord = document.get(region.getOffset(), offset - region.getOffset());
                this.fIsPartial = true;
            } else {
                this.fCurrentWord = document.get(region.getOffset(), region.getLength());
                this.fIsPartial = false;
            }
            for (IContentAssistProcessor icap : this.fProcessors) {
                if (!(icap instanceof TemplateCompletionProcessor)) continue;
                return icap.computeCompletionProposals(viewer, offset);
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ArrayList<IContentAssistProcessor> getProcessors() {
        return this.fProcessors;
    }

    public ContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    protected ICompletionProposal getBusyProposal(ITextViewer viewer, int fOffset) {
        return new RfLazyCompletionProposal(viewer, new R2LBusy(), "", fOffset, false, null, null);
    }

    public ICompletionProposal getNoProposal(ITextViewer viewer, int fOffset) {
        return new RfLazyCompletionProposal(viewer, new R2LNoProposalElement(), "", fOffset, false, null, null);
    }

    public IPreferenceStore getPreferenceStore() {
        return PSSPlugin.getDefault().getPreferenceStore();
    }
}

