/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.pssdt.ui.editor.contentassist.PSSContentAssistProcessorManager;
import ro.amiq.pssdt.ui.preferences.PrefConst;

public class PSSKeywordContentAssistProcessor
implements IContentAssistProcessor {
    private PSSContentAssistProcessorManager fProcessor;
    private static final Comparator ORDER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            String icp1 = ((ICompletionProposal)o1).getDisplayString();
            String icp2 = ((ICompletionProposal)o2).getDisplayString();
            return icp1.compareTo(icp2);
        }
    };

    public PSSKeywordContentAssistProcessor(PSSContentAssistProcessorManager assistant) {
        this.fProcessor = assistant;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String currentWord;
        ArrayList<ICompletionProposal> proposals;
        block5: {
            block4: {
                try {
                    if (this.fProcessor.getCrtContentAssistPage() != 0 || this.fProcessor.fIsPartial) break block4;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            proposals = new ArrayList<ICompletionProposal>();
            IDocument document = viewer.getDocument();
            currentWord = this.lastWord(document, offset);
            if (currentWord != null && !currentWord.isEmpty()) break block5;
            return null;
        }
        this.fillProposals(offset, currentWord, proposals);
        ICompletionProposal[] complProposals = new ICompletionProposal[proposals.size()];
        proposals.toArray(complProposals);
        Arrays.sort(complProposals, ORDER_COMPARATOR);
        return complProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return "No completions available.";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String lastWord(IDocument doc, int offset) {
        try {
            int n = offset - 1;
            while (true) {
                if (n < -1) {
                    return "";
                }
                if (n == -1) {
                    return doc.get(n + 1, offset - n - 1);
                }
                char ch = doc.getChar(n);
                if (ch == '.') {
                    return null;
                }
                if (!Character.isJavaIdentifierPart(ch)) {
                    return doc.get(n + 1, offset - n - 1);
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return "";
    }

    private void fillProposals(int offset, String currentWord, ArrayList<ICompletionProposal> list) {
        String[] keywords = PrefConst.getKeywordsPreference();
        int i = 0;
        while (i < keywords.length) {
            String keyword = keywords[i];
            if (currentWord.length() == 0 || keyword.startsWith(currentWord) && !keyword.equals(currentWord)) {
                list.add((ICompletionProposal)new CompletionProposal(keyword, offset - currentWord.length(), currentWord.length(), keyword.length(), DVTImages.imageCache.getImage(DVTImages.KEYWORD_OBJ), keyword, null, "Keyword"));
            }
            ++i;
        }
    }
}

