/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.contentassist;

import java.util.ArrayDeque;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.pssdt.ui.editor.PSSWordFinder;
import ro.amiq.pssdt.ui.editor.quickfix.util.PSSQuickFixUtil;

public class PSSParameterHintsUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getContextInformationOffset(IDocument document, int triggerOffset, IRfScope initialScope, String elementName, DVTEditor editor, boolean endOffset, boolean isApplyProposal) {
        int rightBracketOffset;
        block12: {
            int leftBracketOffset;
            int scopeEndOffset;
            block11: {
                int elementNameOffset;
                int scopeStartOffset;
                block10: {
                    char nextChar;
                    block9: {
                        String wordAtOffset;
                        if (elementName.isEmpty()) {
                            return triggerOffset;
                        }
                        scopeStartOffset = ((RfDefElement)initialScope).getStartOffset();
                        scopeEndOffset = ((RfDefElement)initialScope).getEndOffset();
                        elementNameOffset = -1;
                        PSSWordFinder pssWordFinder = new PSSWordFinder();
                        IRegion wordAtOffsetRegion = pssWordFinder.getWordAtOffset(document, triggerOffset);
                        if (wordAtOffsetRegion != null && (wordAtOffset = document.get(wordAtOffsetRegion.getOffset(), wordAtOffsetRegion.getLength())).equals(elementName)) {
                            elementNameOffset = wordAtOffsetRegion.getOffset() + wordAtOffsetRegion.getLength();
                        }
                        if (elementNameOffset < 0) {
                            elementNameOffset = PSSQuickFixUtil.getBackwardOffsetFor(document, elementName, scopeStartOffset, triggerOffset, false) + elementName.length();
                        }
                        if (elementNameOffset > scopeStartOffset) break block9;
                        return -1;
                    }
                    if (isApplyProposal || (nextChar = DVTDocumentUtils.nextCodeChar((IDocument)document, (int)elementNameOffset, (String)"__pss_partitioning", (boolean)true)) == '(') break block10;
                    return -1;
                }
                leftBracketOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)elementNameOffset, (boolean)true, (int)100, (IDocument)document, (String)"__pss_partitioning") + 1;
                if (leftBracketOffset <= scopeEndOffset && leftBracketOffset >= scopeStartOffset) break block11;
                return -1;
            }
            if (!endOffset) return leftBracketOffset;
            rightBracketOffset = DVTDocumentUtils.getMatchingRightBracketOffset((int)leftBracketOffset, (DVTEditor)editor, (IDocument)document);
            if (rightBracketOffset >= 0 && rightBracketOffset <= scopeEndOffset) break block12;
            return -1;
        }
        try {
            return rightBracketOffset;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RfNamedElement getElementNamedElementAtOffset(RfProject rfProject, IFile file, DVTEditor editor, int offset, int minLimit) {
        try {
            IDocument document = editor.getDocument();
            if (document == null) return null;
            if (offset < 0) return null;
            if (offset >= document.getLength()) {
                return null;
            }
            if (document.getChar(offset) == ')') {
                if ((offset = DVTDocumentUtils.getMatchingLeftBracketOffset((int)offset, (DVTEditor)editor, (IDocument)document) - 1) < 0) {
                    return null;
                }
            } else {
                ArrayDeque<Character> closedBracketsStack = new ArrayDeque<Character>();
                while (offset >= minLimit && offset >= 0) {
                    char chr = document.getChar(offset);
                    if (chr == ')') {
                        closedBracketsStack.push(Character.valueOf(chr));
                    } else if (chr == '(') {
                        if (closedBracketsStack.isEmpty()) {
                            Object[] nextCodeOffsetPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)(offset - 1), (boolean)false, (String)"__pss_partitioning");
                            if (nextCodeOffsetPair != null) {
                                char nextCode = ((Character)nextCodeOffsetPair[0]).charValue();
                                int nextCodeOffset = (Integer)nextCodeOffsetPair[1];
                                if (Character.isJavaIdentifierPart(nextCode)) {
                                    offset = nextCodeOffset;
                                    break;
                                }
                            }
                        } else {
                            closedBracketsStack.pop();
                        }
                    }
                    --offset;
                }
            }
            if (offset <= minLimit) {
                return null;
            }
            int elementNameEndOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)offset, (boolean)false, (String)"__pss_partitioning");
            if (elementNameEndOffset < 0) {
                return null;
            }
            RfWNamedElementAndScope rfElementAndScope = RfUtils.getRfElement(file, document, offset);
            RfNamedElement element = null;
            if (rfElementAndScope != null) {
                element = rfElementAndScope.getNamedElement();
                if (element != null) return element;
                return null;
            }
            IRfScope scope = RfUtils.getRfScope((ITextEditor)editor, document, elementNameEndOffset);
            if (scope == null) {
                return null;
            }
            if (!(scope instanceof RfDefElement)) return (RfNamedElement)((Object)scope);
            return scope.getNamedElement();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

