/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.contentassist;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.pssdt.ui.editor.contentassist.PositionBasedCompletionProposal;

public class PSSTemplateProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3 {
    private final LinkedHashMap<Template, IRegion> fTemplates;
    private TreeMap<Integer, TemplateBuffer> fTemplateBuffers = new TreeMap();
    private final TemplateContext fContext;
    private final Image fImage;
    private int fRelevance;
    private IRegion fSelectedRegion;
    private String fDisplayString;
    private InclusivePositionUpdater fUpdater;
    private IInformationControlCreator fInformationControlCreator;
    private final IRegion fMainRegion;
    private final Template fMainTemplate;
    private String fLineDelimiter;

    public PSSTemplateProposal(LinkedHashMap<Template, IRegion> templates, TemplateContext context, Image image, int relevance, String lineDelimiter) {
        this.fTemplates = templates;
        Assert.isNotNull(this.fTemplates);
        Assert.isTrue((!this.fTemplates.isEmpty() ? 1 : 0) != 0);
        this.fContext = context;
        Assert.isNotNull((Object)this.fContext);
        this.fMainTemplate = (Template)this.fTemplates.keySet().toArray()[0];
        Assert.isNotNull((Object)this.fMainTemplate);
        this.fMainRegion = (IRegion)this.fTemplates.values().toArray()[0];
        Assert.isNotNull((Object)this.fMainRegion);
        this.fImage = image;
        this.fDisplayString = null;
        this.fRelevance = relevance;
        this.fLineDelimiter = lineDelimiter;
    }

    public final void setInformationControlCreator(IInformationControlCreator informationControlCreator) {
        this.fInformationControlCreator = informationControlCreator;
    }

    protected final Template getTemplate() {
        return this.fMainTemplate;
    }

    protected final TemplateContext getContext() {
        return this.fContext;
    }

    @Deprecated
    public final void apply(IDocument document) {
    }

    int getOffset(TemplateBuffer tb) {
        for (Map.Entry<Integer, TemplateBuffer> i : this.fTemplateBuffers.entrySet()) {
            if (i.getValue() != tb) continue;
            return i.getKey();
        }
        return -1;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        try {
            int shiftDueToEvaluate;
            TemplateBuffer mainTB;
            DVTFileModificationValidator.validateEdit((ITextViewer)viewer);
            this.fContext.setReadOnly(false);
            int referenceOffsetBeforeEvaluate = this.getReferenceOffset();
            try {
                mainTB = this.fContext.evaluate(this.fMainTemplate);
                this.fTemplateBuffers.clear();
                int i = 1;
                while (i < this.fTemplates.size()) {
                    int tbOffset = ((IRegion)this.fTemplates.values().toArray()[i]).getOffset();
                    TemplateBuffer tb = this.fContext.evaluate((Template)this.fTemplates.keySet().toArray()[i]);
                    this.fTemplateBuffers.put(tbOffset, tb);
                    ++i;
                }
                this.fTemplateBuffers.put(this.getReplaceOffset(), mainTB);
            }
            catch (TemplateException e1) {
                DVTLogger.INSTANCE.logError((Throwable)e1);
                this.fSelectedRegion = this.fMainRegion;
                return;
            }
            int referenceOffsetAfterEvaluate = this.getReferenceOffset();
            int totalShift = shiftDueToEvaluate = referenceOffsetAfterEvaluate - referenceOffsetBeforeEvaluate;
            TreeMap<Integer, TemplateBuffer> tmpTemplateBuffers = new TreeMap<Integer, TemplateBuffer>();
            for (Map.Entry<Integer, TemplateBuffer> i : this.fTemplateBuffers.entrySet()) {
                tmpTemplateBuffers.put(i.getKey() + totalShift, i.getValue());
                String text = i.getValue().getString();
                if (i.getValue() == mainTB) {
                    int o1 = i.getKey() + totalShift - shiftDueToEvaluate;
                    int o2 = Math.max(this.getReplaceEndOffset() + totalShift - shiftDueToEvaluate, offset + totalShift);
                    document.replace(o1, o2 - o1, text);
                } else {
                    if (text.length() > 0 && this.fLineDelimiter != null && !this.fLineDelimiter.equals("" + text.charAt(text.length() - 1))) {
                        text = String.valueOf(text) + this.fLineDelimiter;
                    }
                    document.replace(i.getKey() + totalShift, 0, text);
                }
                totalShift += text.length();
            }
            this.fTemplateBuffers = tmpTemplateBuffers;
            LinkedModeModel model = new LinkedModeModel();
            boolean hasPositions = false;
            for (TemplateVariable i : this.mergeAndUpdateTemplateVariables(this.fTemplateBuffers)) {
                if (i.isUnambiguous()) continue;
                LinkedPositionGroup group = new LinkedPositionGroup();
                int[] offsets = i.getOffsets();
                int length = i.getLength();
                String[] values = i.getValues();
                ICompletionProposal[] proposals = new ICompletionProposal[values.length];
                int j = 0;
                while (j < values.length) {
                    this.ensurePositionCategoryInstalled(document, model);
                    DVTPosition pos = new DVTPosition(offsets[0], length);
                    document.addPosition(this.getCategory(), (Position)pos);
                    proposals[j] = new PositionBasedCompletionProposal(viewer, values[j], (Position)pos, length);
                    ++j;
                }
                Object first = proposals.length > 1 ? new ProposalPosition(document, offsets[0], length, proposals) : new LinkedPosition(document, offsets[0], length);
                j = 0;
                while (j != offsets.length) {
                    if (j == 0) {
                        group.addPosition(first);
                    } else {
                        group.addPosition(new LinkedPosition(document, offsets[j], length));
                    }
                    ++j;
                }
                model.addGroup(group);
                hasPositions = true;
            }
            if (hasPositions) {
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, this.getOffset(mainTB) + this.getCaretOffset(mainTB), 0, Integer.MAX_VALUE);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.ensurePositionCategoryRemoved(document);
                this.fSelectedRegion = new Region(this.getOffset(mainTB) + this.getCaretOffset(mainTB), 0);
            }
        }
        catch (BadLocationException e) {
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)((Object)e));
            this.ensurePositionCategoryRemoved(document);
            this.fSelectedRegion = this.fMainRegion;
        }
        catch (CoreException | BadPositionCategoryException e) {
            DVTLogger.INSTANCE.logError(e);
            this.openErrorDialog(viewer.getTextWidget().getShell(), (Exception)e);
            this.fSelectedRegion = this.fMainRegion;
        }
    }

    private Collection<TemplateVariable> mergeAndUpdateTemplateVariables(Map<Integer, TemplateBuffer> tb) {
        HashMap<String, TemplateVariable> result = new HashMap<String, TemplateVariable>();
        for (Map.Entry<Integer, TemplateBuffer> i : tb.entrySet()) {
            TemplateVariable[] templateVariableArray = i.getValue().getVariables();
            int n = templateVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateVariable j = templateVariableArray[n2];
                int[] newOffsets = j.getOffsets();
                int k = 0;
                while (k < newOffsets.length) {
                    int n3 = k++;
                    newOffsets[n3] = newOffsets[n3] + i.getKey();
                }
                j.setOffsets(newOffsets);
                if (result.containsKey(j.getName())) {
                    result.put(j.getName(), this.addOffsets((TemplateVariable)result.get(j.getName()), newOffsets));
                } else {
                    result.put(j.getName(), j);
                }
                ++n2;
            }
        }
        return result.values();
    }

    private TemplateVariable addOffsets(TemplateVariable templateVariable, int[] newOffsets) {
        int i;
        TreeSet<Integer> ts = new TreeSet<Integer>();
        Object object = templateVariable.getOffsets();
        int n = ((int[])object).length;
        int n2 = 0;
        while (n2 < n) {
            i = object[n2];
            ts.add(i);
            ++n2;
        }
        object = newOffsets;
        n = newOffsets.length;
        n2 = 0;
        while (n2 < n) {
            i = object[n2];
            ts.add(i);
            ++n2;
        }
        int[] array = new int[ts.size()];
        int i2 = 0;
        object = ts.iterator();
        while (object.hasNext()) {
            int e;
            array[i2] = e = ((Integer)object.next()).intValue();
            ++i2;
        }
        templateVariable.setOffsets(array);
        return templateVariable;
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater((IPositionUpdater)this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    PSSTemplateProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater((IPositionUpdater)this.fUpdater);
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private int getCaretOffset(TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (variable.getType().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    protected final int getReferenceOffset() {
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            return docContext.getStart();
        }
        return 0;
    }

    protected final int getReplaceOffset() {
        int start;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            start = docContext.getStart();
        } else {
            start = this.fMainRegion.getOffset();
        }
        return start;
    }

    protected final int getReplaceEndOffset() {
        int end;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext docContext = (DocumentTemplateContext)this.fContext;
            end = docContext.getEnd();
        } else {
            end = this.fMainRegion.getOffset() + this.fMainRegion.getLength();
        }
        return end;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        TemplateBuffer templateBuffer;
        try {
            this.fContext.setReadOnly(true);
            try {
                templateBuffer = this.fContext.evaluate(this.fMainTemplate);
            }
            catch (TemplateException templateException) {
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return templateBuffer.getString();
    }

    public String getDisplayString() {
        if (this.fDisplayString == null) {
            this.fDisplayString = String.valueOf(this.fMainTemplate.getName()) + " - " + this.fMainTemplate.getDescription();
        }
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)"Template Evaluation Error", (String)e.getMessage());
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return this.fInformationControlCreator;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.getReplaceOffset();
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                return this.fMainTemplate.getName().toLowerCase().startsWith(content.toLowerCase());
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fMainTemplate.getName();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplaceOffset();
    }

    @Deprecated
    public void apply(IDocument document, char trigger, int offset) {
    }

    public boolean isValidFor(IDocument document, int offset) {
        return false;
    }

    public char[] getTriggerCharacters() {
        return new char[0];
    }

    public int getContextInformationPosition() {
        return this.fMainRegion.getOffset();
    }
}

