/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.contentassist;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.r2lparser.R2LManager;
import ro.amiq.pssdt.r2lparser.R2LProposalManager;
import ro.amiq.pssdt.r2lparser.R2LResultContainer;
import ro.amiq.pssdt.ui.editor.contentassist.PSSContentAssistProcessorManager;
import ro.amiq.pssdt.ui.editor.contentassist.RfLazyCompletionProposal;

public class RfContentAssistProcessor
implements IContentAssistProcessor {
    protected PSSContentAssistProcessorManager fProcessor;
    protected boolean fAllowProposals;

    public RfContentAssistProcessor(PSSContentAssistProcessorManager processor) {
        this.fProcessor = processor;
    }

    public PSSContentAssistProcessorManager getProcessor() {
        return this.fProcessor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals;
        block7: {
            block6: {
                RfProject rfProject;
                block5: {
                    try {
                        rfProject = this.fProcessor.getProject();
                        if (rfProject != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                if (DVTPlugin.getDefault().collect().c(rfProject.getProject(), "F707373")) break block6;
                return null;
            }
            proposals = this.getProposals(viewer, offset);
            if (proposals != null) break block7;
            return null;
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private ICompletionProposal[] getProposals(ITextViewer viewer, int offset) {
        IRfScope initialScope;
        IRfNamedElement[] candidates;
        R2LResultContainer container;
        block11: {
            block10: {
                block9: {
                    IDocument document;
                    block8: {
                        block7: {
                            try {
                                if (!this.fProcessor.isCanceled()) break block7;
                                return null;
                            }
                            catch (Exception e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                return null;
                            }
                        }
                        document = viewer.getDocument();
                        if (document != null) break block8;
                        return null;
                    }
                    R2LProposalManager manager = new R2LProposalManager(this.fProcessor.getProject(), this.fProcessor.getInitialScope(), (IResource)this.fProcessor.getFile(), document, offset);
                    container = ((R2LManager)manager).getProposals();
                    if (container != null) break block9;
                    return null;
                }
                if (!this.fProcessor.isCanceled()) break block10;
                return null;
            }
            candidates = container.candidates;
            initialScope = container.initialScope;
            this.fAllowProposals = container.allowProposals();
            if (!this.fProcessor.isCanceled()) break block11;
            return null;
        }
        return this.getCompletionProposals(viewer, candidates, container.prefix, offset, container.isInstantiation, initialScope);
    }

    private ICompletionProposal[] getCompletionProposals(ITextViewer viewer, IRfNamedElement[] candidates, String prefix, int offset, boolean isInstantiation, IRfScope initialScope) {
        if (candidates == null) {
            return null;
        }
        ArrayList<RfLazyCompletionProposal> result = new ArrayList<RfLazyCompletionProposal>();
        int i = 0;
        while (i < candidates.length) {
            IRfNamedElement element = candidates[i];
            if (!element.getName().startsWith("\"")) {
                boolean hasLetter = false;
                int j = 0;
                while (j < element.getName().length()) {
                    char ch = element.getName().charAt(j);
                    if (Character.isLetter(ch)) {
                        hasLetter = true;
                        break;
                    }
                    ++j;
                }
                if (hasLetter) {
                    result.add(new RfLazyCompletionProposal(viewer, element, prefix, offset, isInstantiation, initialScope, null));
                }
            }
            ++i;
        }
        return (ICompletionProposal[])result.toArray(new RfLazyCompletionProposal[result.size()]);
    }
}

