/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTProposalContextInformation;
import ro.amiq.dvt.ui.editor.DvtContextInformationType;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTCompletionProposal;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.IRfScope;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.r2lparser.R2LCoverpointArg;
import ro.amiq.pssdt.r2lparser.R2LDummyElement;
import ro.amiq.pssdt.ui.editor.contentassist.PSSParameterHintsUtils;
import ro.amiq.pssdt.ui.editor.contentassist.RfLazyAutoInstanceProposal;

public class RfLazyCompletionProposal
implements IDVTCompletionProposal,
ICompletionProposalExtension4,
ICompletionProposalExtension5 {
    private Object fCandidate;
    private String fPrefix;
    private int fOffset;
    private String fReplacementString;
    private String fDisplayString;
    private Image fImage;
    private DVTTooltipContent fAdditionalProposalInfo;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private boolean fAlreadyComputed;
    private IContextInformation fContextInformation;
    private ITextViewer fTextViewer;
    private TemplateProposal fTemplateProposal;
    private boolean fUseTemplate;
    private boolean fIsInstantiation;
    private DVTLinkedPositionProvider fLinkedPositionProvider;
    private static final String CATEGORY = "CONTENT_ASSIST_PROPOSAL";
    private int firstParameterOffset;
    private int firstParameterLength;
    private String fFunctionArguments;
    private DVTEditor fEditor;
    private IRfScope fInitialScope;
    private boolean fCandidateHasSemiColon;

    public RfLazyCompletionProposal(ITextViewer viewer, Object candidate, String currentWord, int offset, boolean isInstantiation, IRfScope scope, IContextInformation contextInformation) {
        this.fTextViewer = viewer;
        this.fCandidate = candidate;
        this.fPrefix = currentWord;
        this.fOffset = offset;
        this.fIsInstantiation = isInstantiation;
        this.fContextInformation = contextInformation;
        this.fInitialScope = scope;
        this.fEditor = this.fTextViewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)this.fTextViewer).getEditor() : (DVTEditor)DVTUiUtils.getActivePage().getActiveEditor();
        this.fLinkedPositionProvider = new DVTLinkedPositionProvider(this.fEditor, new LinkedModeModel(), CATEGORY + this.toString(), true);
    }

    public void apply(IDocument document) {
        try {
            int charOffset;
            Object[] charOffsetPair;
            DVTFileModificationValidator.validateEdit((ITextViewer)this.fTextViewer);
            if (!this.fPrefix.isEmpty() && (charOffsetPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)this.fOffset, (boolean)false, (String)"__pss_partitioning")) != null && (charOffset = ((Integer)charOffsetPair[1]).intValue()) < this.fReplacementOffset + this.fPrefix.length()) {
                this.fReplacementOffset = charOffset - this.fPrefix.length();
            }
            this.fTemplateProposal = null;
            this.internalComputeProposal();
            if (this.fCandidate instanceof R2LDummyElement) {
                return;
            }
            if (this.fUseTemplate) {
                Region region = new Region(this.fReplacementOffset, this.fReplacementLength);
                TemplateContext context = this.createContext(document, (IRegion)region);
                Template template = new Template("", this.fDisplayString, "ro.amiq.pssdt.templates.contextType.unknown", this.fReplacementString, true);
                TemplateBuffer templateBuffer = context.evaluate(template);
                this.fReplacementString = templateBuffer.getString();
                List<IRegion> linkedPositionRegions = this.computeLinkedPositionRegionsFromTemplate(templateBuffer);
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
                this.fTemplateProposal = new TemplateProposal(template, context, (IRegion)region, this.fImage, 1);
                if (linkedPositionRegions == null || linkedPositionRegions.isEmpty() || this.fLinkedPositionProvider == null) {
                    return;
                }
                IRegion firstRegion = null;
                for (IRegion linkedPosRegion : linkedPositionRegions) {
                    if (firstRegion == null) {
                        firstRegion = linkedPosRegion;
                    }
                    this.fLinkedPositionProvider.addSingleLinkedPosition(linkedPosRegion.getOffset(), linkedPosRegion.getLength(), document);
                }
                if (firstRegion != null) {
                    this.firstParameterOffset = firstRegion.getOffset();
                    this.firstParameterLength = firstRegion.getLength();
                }
                String functionName = "";
                if (this.fCandidate instanceof RfNamedElement) {
                    functionName = ((RfNamedElement)this.fCandidate).getName();
                }
                int contextInformationStartOffset = PSSParameterHintsUtils.getContextInformationOffset(document, this.fReplacementOffset, this.fInitialScope, functionName, this.fEditor, false, true);
                int contextInformationEndOffset = PSSParameterHintsUtils.getContextInformationOffset(document, this.fReplacementOffset, this.fInitialScope, functionName, this.fEditor, true, true) - 1;
                if (contextInformationStartOffset >= 0 && contextInformationEndOffset >= 0 && this.fFunctionArguments != null) {
                    this.fContextInformation = new DVTProposalContextInformation(DvtContextInformationType.ARGUMENTS_OR_ORDERED_PORT_CONNECTIONS, this.fDisplayString, this.fFunctionArguments, contextInformationStartOffset, contextInformationEndOffset - contextInformationStartOffset, "__pss_partitioning");
                }
                DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, this.fCandidateHasSemiColon ? (char)';' : ')', this.fReplacementOffset, "__pss_partitioning");
                this.fLinkedPositionProvider.enterLinkedMode(document, config);
                return;
            }
            if (this.fCandidate instanceof RfNamedElement && this.fPrefix.isEmpty() && Character.isJavaIdentifierPart(document.getChar(this.fOffset - 1))) {
                this.fReplacementString = " " + this.fReplacementString;
                ++this.fCursorPosition;
            }
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (Exception exception) {}
    }

    private List<IRegion> computeLinkedPositionRegionsFromTemplate(TemplateBuffer templateBuffer) {
        ArrayList<IRegion> linkedPositionRegions = new ArrayList<IRegion>();
        TemplateVariable[] templateVariables = templateBuffer.getVariables();
        if (templateVariables == null) {
            return linkedPositionRegions;
        }
        TemplateVariable[] templateVariableArray = templateVariables;
        int n = templateVariables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable templateVariable = templateVariableArray[n2];
            int[] templateOffsets = templateVariable.getOffsets();
            if (templateOffsets != null) {
                String templateVarName = templateVariable.getName();
                int[] nArray = templateOffsets;
                int n3 = templateOffsets.length;
                int n4 = 0;
                while (n4 < n3) {
                    int offset = nArray[n4];
                    linkedPositionRegions.add((IRegion)new Region(this.fReplacementOffset + offset, templateVarName.length()));
                    ++n4;
                }
            }
            ++n2;
        }
        return linkedPositionRegions;
    }

    protected TemplateContext createContext(IDocument document, IRegion region) {
        TemplateContextType contextType = new TemplateContextType("ro.amiq.pssdt.templates.contextType.unknown", "dummy");
        return new DocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
    }

    public Point getSelection(IDocument document) {
        this.internalComputeProposal();
        if (this.fTemplateProposal == null || this.fFunctionArguments == null || this.fFunctionArguments.isEmpty()) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }
        return new Point(this.firstParameterOffset, this.firstParameterLength);
    }

    public IContextInformation getContextInformation() {
        this.internalComputeProposal();
        return this.fContextInformation;
    }

    public Image getImage() {
        this.internalComputeProposal();
        return this.fImage;
    }

    public String getAdditionalProposalInfo() {
        if (this.fAdditionalProposalInfo == null) {
            this.computeAdditionalProposalInfo();
        }
        String delimiter = this.fAdditionalProposalInfo.getSignature().isEmpty() ? "" : "<br><br>";
        String result = String.valueOf(this.fAdditionalProposalInfo.getSignature()) + delimiter + this.fAdditionalProposalInfo.getShallow() + this.fAdditionalProposalInfo.getComment() + this.fAdditionalProposalInfo.getUPFSignature() + this.fAdditionalProposalInfo.getDebugInfo();
        if (result.length() > 300) {
            return String.valueOf(result.substring(0, 300)) + "...";
        }
        return result;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.fAdditionalProposalInfo == null) {
            this.computeAdditionalProposalInfo();
        }
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            return this.getAdditionalProposalInfo();
        }
        return this.fAdditionalProposalInfo;
    }

    private void computeAdditionalProposalInfo() {
        this.fAdditionalProposalInfo = new DVTTooltipContent();
        DVTTooltipContent tooltipContent = new DVTTooltipContent();
        String comment = null;
        if (this.fCandidate instanceof R2LDummyElement) {
            comment = ((R2LDummyElement)this.fCandidate).getSignature();
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, DVTStringUtil.partiallyEscapeHTML((String)this.textWrap(40, this.fDisplayString).toString()));
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, this.textWrap(40, comment).toString());
            return;
        }
        if (this.fCandidate instanceof IRfNamedElement) {
            RfUtils.getTooltipFormattedText((IRfNamedElement)this.fCandidate, (ITextEditor)this.fEditor, tooltipContent);
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, tooltipContent.getSignature());
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, tooltipContent.getComment());
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.PREFERENCE, tooltipContent.getPreference());
        } else {
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, "");
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, comment);
        }
    }

    public String getDisplayString() {
        this.internalComputeProposal();
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    private void internalComputeProposal() {
        if (this.fAlreadyComputed) {
            return;
        }
        this.fUseTemplate = false;
        this.fAlreadyComputed = true;
        String candidateName = null;
        int cursorOffset = 0;
        if (this.fCandidate == null) {
            return;
        }
        this.fReplacementString = this.fPrefix;
        this.fDisplayString = "";
        DVTEditor editor = ((DVTProjectionViewer)this.fTextViewer).getEditor();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)editor);
        if (this.fCandidate instanceof IRfNamedElement) {
            candidateName = ((IRfNamedElement)this.fCandidate).getName();
            this.fImage = ((IRfNamedElement)this.fCandidate).getImage();
        }
        if (this.fCandidate instanceof R2LDummyElement) {
            this.fReplacementString = "";
            this.fDisplayString = candidateName;
            this.fReplacementOffset = this.fOffset;
            this.fReplacementLength = 0;
            this.fCursorPosition = 0;
            return;
        }
        this.fReplacementOffset = this.fOffset - this.fPrefix.length();
        this.fReplacementLength = this.fPrefix.length();
        Point selectedRange = this.fTextViewer.getSelectedRange();
        if (this.fReplacementLength == 0 && selectedRange.x == this.fReplacementOffset) {
            this.fReplacementLength = selectedRange.y;
        }
        if (this.fCandidate instanceof RfMethod) {
            this.fDisplayString = candidateName;
            this.fReplacementString = candidateName;
            String arguments = ((RfMethod)this.fCandidate).getArgs(true, true, false);
            this.fDisplayString = arguments != null && arguments.length() > 0 ? String.valueOf(this.fDisplayString) + "(" + arguments + ")" : String.valueOf(this.fDisplayString) + "()";
            this.fFunctionArguments = arguments;
            this.fUseTemplate = arguments != null && arguments.length() > 0;
            this.fReplacementString = String.valueOf(this.fReplacementString) + this.getFunctionArgumentsReplacement(lineDelimiter);
        } else if (this.fCandidate instanceof R2LCoverpointArg) {
            this.fReplacementString = String.valueOf(candidateName) + "(${})";
            this.fUseTemplate = true;
            cursorOffset = 1;
            this.fDisplayString = candidateName;
        } else {
            this.fReplacementString = candidateName;
            this.fDisplayString = candidateName;
        }
        this.fCursorPosition = this.fUseTemplate ? (this.fDisplayString == null ? 0 : this.fDisplayString.length() + cursorOffset) : (this.fReplacementString == null ? 0 : this.fReplacementString.length());
    }

    private String getFunctionArgumentsReplacement(String lineDelimiter) {
        StringBuilder replacementString = new StringBuilder();
        if (!(this.fCandidate instanceof RfMethod)) {
            return replacementString.toString();
        }
        List<RfField> arguments = ((RfMethod)this.fCandidate).getArguments();
        if (arguments == null || arguments.isEmpty()) {
            return replacementString.append("()").toString();
        }
        if (DVTPlugin.getDefault().getPreferenceStore().getBoolean("ca.insert_named_arguments")) {
            replacementString.append("(");
            if (arguments.size() == 1) {
                replacementString.append(arguments.get(0)).append(" => ${").append(arguments.get(0)).append("})");
            } else {
                Iterator<RfField> it = arguments.iterator();
                while (it.hasNext()) {
                    String elementName = it.next().getName();
                    replacementString.append(lineDelimiter).append(elementName).append(" => ${").append(elementName).append("}");
                    if (!it.hasNext()) continue;
                    replacementString.append(", ");
                }
                replacementString.append(lineDelimiter).append(")");
            }
            Region region = new Region(this.fReplacementOffset, this.fReplacementLength);
            return RfLazyAutoInstanceProposal.formatReplacementString(replacementString.toString(), (IRegion)region, this.fTextViewer, true, null, this.fPrefix);
        }
        replacementString.append("(").append(((RfMethod)this.fCandidate).getArgs(true, false, true)).append(")");
        return replacementString.toString();
    }

    public boolean isNoProposal() {
        return this.fCandidate instanceof R2LDummyElement;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    private StringBuilder textWrap(int lineLength, String text) {
        return DVTStringUtil.textWrap((int)lineLength, (String)text);
    }
}

