/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.formatter;

import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.model.CFPartition;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.CFIndentScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.ICFIndentScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.pssdt.ui.editor.formatter.PSSCFScopeScanner;

public class PSSCFIndentScanner
extends PSSCFScopeScanner
implements ICFIndentScannerImpl {
    private CFIndentScanner fCFIndentScanner;
    private CFToken fPrevToken;

    public PSSCFIndentScanner(CFModel model) {
        super(model);
    }

    @Override
    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        super.setCFTokenScanner(cfTokenScanner);
        this.fCFIndentScanner = (CFIndentScanner)cfTokenScanner;
    }

    @Override
    public void startPartition(DVTBaseFormattingStrategy strategy) {
        super.startPartition(strategy);
        this.fPrevToken = null;
    }

    @Override
    public void startChunk(CFChunk chunk) {
        super.startChunk(chunk);
        if (chunk == null) {
            return;
        }
        String chunkValue = chunk.getValue();
        CFPartition partition = chunk.getEnclosingPartition();
        if (partition == null) {
            return;
        }
        if (partition.isFirstChunk(chunk) && chunk.isFirstOnLine() && chunkValue.startsWith("<'")) {
            this.fCFIndentScanner.setStrictIndent(0);
        }
        if (partition.isLastChunk(chunk) && chunk.isFirstOnLine() && chunkValue.startsWith("'>")) {
            this.fCFIndentScanner.setStrictIndent(0);
        }
    }

    @Override
    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        if (this.isBeginIndentation()) {
            return;
        }
        if (!this.isInPreproc()) {
            this.fCFIndentScanner.indent(token);
        }
    }

    @Override
    public void endToken(CFToken token) {
        super.endToken(token);
        if (!this.isInPreproc()) {
            this.fPrevToken = token;
        }
    }

    public CFToken getTokenForLineBreakBeforeParenOpen(CFToken token) {
        return token;
    }

    public boolean allowLineBreak(CFToken token) {
        char c;
        if (token == null) {
            return false;
        }
        if (token.isOnSensibleLine()) {
            return false;
        }
        if (token.getTokenType() == 4 && (';' == (c = token.getValue().charAt(0)) || ',' == c)) {
            return false;
        }
        if (this.fPrevToken == null) {
            return true;
        }
        if (this.fPrevToken.getTokenType() == 3) {
            return true;
        }
        if (this.allowLineBreakAfterSingleCharToken(this.fPrevToken)) {
            return true;
        }
        return this.allowLineBreakBeforeSingleCharToken(token);
    }

    public boolean forceLineBreak(CFToken token) {
        if (token == null) {
            return false;
        }
        if (this.allowLineBreakAfterSingleCharToken(token)) {
            return false;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return false;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return false;
        }
        int nextWSOffsetInLineAfterWS = this.getNextPotentialLineBreakOffsetInLineAfterWS(chunk, token.getStartOffsetInChunk() + 1);
        return this.fCFIndentScanner.exceedsLineWrap(nextWSOffsetInLineAfterWS, lineInfo);
    }

    private boolean allowLineBreakBeforeSingleCharToken(CFToken token) {
        if (token == null) {
            return false;
        }
        if (token.getTokenType() == 4) {
            char c = token.getValue().charAt(0);
            return this.allowLineBreakBeforeChar(c);
        }
        return false;
    }

    private boolean allowLineBreakBeforeChar(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        return '{' == c || '}' == c || ')' == c;
    }

    private boolean allowLineBreakAfterSingleCharToken(CFToken token) {
        if (token == null) {
            return false;
        }
        if (token.getTokenType() == 4) {
            char c = token.getValue().charAt(0);
            return this.allowLineBreakAfterChar(c);
        }
        return false;
    }

    private boolean allowLineBreakAfterChar(char c) {
        return '{' == c || '}' == c || ';' == c || ',' == c || '(' == c;
    }

    private int getNextPotentialLineBreakOffsetInLineAfterWS(CFChunk chunk, int startOffsetInChunk) {
        String chunkValue = chunk.getValue();
        int i = startOffsetInChunk;
        while (i < chunkValue.length()) {
            char c = chunkValue.charAt(i);
            if (this.allowLineBreakBeforeChar(c)) {
                return chunk.getStartOffsetInLineAfterWS() + i;
            }
            if (this.allowLineBreakAfterChar(c)) {
                return chunk.getStartOffsetInLineAfterWS() + i + 1;
            }
            ++i;
        }
        return chunk.getStartOffsetInLineAfterWS() + chunkValue.length();
    }

    public boolean tryElsePrefs(CFToken token) {
        return false;
    }

    public boolean allowElseOnSameLine(CFToken token) {
        return false;
    }

    public boolean allowParamPrefs() {
        return false;
    }

    public void updateOnLineBreakBeforeOperator(CFToken token) {
    }
}

