/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.formatter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScopeScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.pssdt.ui.editor.formatter.PSSCFPreprocScanner;

public class PSSCFScopeScanner
extends PSSCFPreprocScanner {
    private static Set<String> EXCEPTION_SCOPES = new HashSet<String>(Arrays.asList("constraint"));
    protected CFPreferences fFormatPreferences;
    protected int fWrapThreshold;
    private CFScopeScanner fCFScopeScanner;
    private Set<String> fShortScopeExceptions = new HashSet<String>();
    private boolean fPotentialAction;
    private boolean fPotentialElse;

    public PSSCFScopeScanner(CFModel model) {
        super(model);
        this.fShortScopeExceptions.add("do");
    }

    @Override
    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        super.setCFTokenScanner(cfTokenScanner);
        this.fCFScopeScanner = (CFScopeScanner)cfTokenScanner;
    }

    @Override
    public void startPartition(DVTBaseFormattingStrategy strategy) {
        super.startPartition(strategy);
        this.fFormatPreferences = strategy.getFormatPreferences();
        DVTSourceViewerConfiguration sourceViewerConfiguration = this.fStrategy.getSourceViewerConfiguration();
        this.fWrapThreshold = this.fFormatPreferences.getLineWrapThreshold(sourceViewerConfiguration.isPreview());
    }

    @Override
    public void startToken(CFToken token) {
        super.startToken(token);
        if (this.isInPreproc()) {
            return;
        }
        if (token == null) {
            return;
        }
        if (token.getTokenType() == 3 || token.getTokenType() == 30 || token.getTokenType() == 40) {
            return;
        }
        if (token.getTokenType() == 2 && this.fPotentialElse && "else".equals(token.getValue())) {
            return;
        }
        this.fCFScopeScanner.popShouldClose(token.isFirstNWSTokenOnLine());
    }

    @Override
    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        if (this.isInPreproc()) {
            return;
        }
        if (token == null) {
            return;
        }
        block0 : switch (token.getTokenType()) {
            case 2: {
                if ("if".equals(token.getValue())) {
                    this.updateOnIfKeyword(token);
                    break;
                }
                if ("else".equals(token.getValue())) {
                    this.updateOnElseKeyword(token);
                    break;
                }
                if (!"case".equals(token.getValue())) break;
                this.updateOnCase(token);
                break;
            }
            case 4: {
                String tokenValue = token.getValue();
                if (tokenValue.length() != 1) break;
                char tokenChar = tokenValue.charAt(0);
                switch (tokenChar) {
                    case '[': {
                        this.fCFScopeScanner.updateOnBracketOpen(token);
                        break block0;
                    }
                    case ']': {
                        this.fCFScopeScanner.updateOnBracketClose(token);
                        break block0;
                    }
                    case '(': {
                        this.fCFScopeScanner.updateOnParenOpen(token);
                        break block0;
                    }
                    case ')': {
                        this.fCFScopeScanner.updateOnParenClose(token);
                        break block0;
                    }
                    case '{': {
                        this.updateOnCurlyOpen(token);
                        break block0;
                    }
                    case '}': {
                        this.updateOnCurlyClose(token);
                        break block0;
                    }
                    case ':': {
                        this.updateOnColon(token);
                        break block0;
                    }
                    case ';': {
                        this.updateOnSemi(token);
                    }
                }
            }
        }
    }

    @Override
    public void endToken(CFToken token) {
        super.endToken(token);
        if (this.isInPreproc()) {
            return;
        }
        if (token.getTokenType() != 3 && token.getTokenType() != 30 && token.getTokenType() != 40) {
            this.fPotentialAction = false;
            this.fPotentialElse = false;
        }
        if (token.getTokenType() == 4) {
            String tokenValue = token.getValue();
            if (tokenValue == null || tokenValue.isEmpty()) {
                return;
            }
            char tokenChar = tokenValue.charAt(0);
            switch (tokenChar) {
                case '{': {
                    this.fPotentialAction = true;
                    break;
                }
                case ';': {
                    this.fPotentialAction = true;
                    break;
                }
                case '}': {
                    CFScope peekScope = this.fCFScopeScanner.getPeekScope();
                    if (peekScope == null || !"if".equals(peekScope.getScopeName())) break;
                    this.fPotentialElse = true;
                }
            }
        }
    }

    public void updateOnCurlyOpen(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && peekScope.isShortScope()) {
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
        } else {
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.INDENT);
        }
    }

    public void updateOnCurlyClose(CFToken token) {
        this.fCFScopeScanner.updateOnEndOfBlock(token, null);
    }

    private void updateOnIfKeyword(CFToken token) {
        if (token == null) {
            return;
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && "else".equals(peekScope.getScopeName()) && this.fCFScopeScanner.isOnTheSameLineWithCurrentScope(token)) {
            peekScope.setScopeName("if");
            return;
        }
        this.fCFScopeScanner.pushScope(token, "if", CFScope.SHORT_SCOPE, CFScope.INDENT);
    }

    private void updateOnElseKeyword(CFToken token) {
        CFScope peekScope;
        if (token == null) {
            return;
        }
        boolean isFirstOnLine = token.isFirstNWSTokenOnLine();
        while (this.fCFScopeScanner.hasScopes() && this.fCFScopeScanner.getPeekScope().shouldClose()) {
            peekScope = this.fCFScopeScanner.getPeekScope();
            if ("if".equals(peekScope.getScopeName()) || "assert".equals(peekScope.getScopeName())) break;
            this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
        }
        if ((peekScope = this.fCFScopeScanner.getPeekScope()) == null) {
            return;
        }
        if ("if".equals(peekScope.getScopeName()) || "assert".equals(peekScope.getScopeName())) {
            if (peekScope.shouldClose()) {
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
                this.fCFScopeScanner.pushScope(token, "else", CFScope.SHORT_SCOPE, CFScope.INDENT);
            } else if ("assert".equals(peekScope.getScopeName())) {
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
                this.fCFScopeScanner.pushScope(token, "else", CFScope.SHORT_SCOPE, CFScope.INDENT);
            } else {
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
                this.fCFScopeScanner.pushScope(token, "else", CFScope.SHORT_SCOPE, CFScope.INDENT);
            }
        } else {
            this.fCFScopeScanner.pushScope(token, "else", CFScope.SHORT_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnSemi(CFToken token) {
        if (this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") != 0 || this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "[") != 0) {
            return;
        }
        if (token == null) {
            return;
        }
        if (!this.fCFScopeScanner.hasScopes()) {
            return;
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (!this.fCFScopeScanner.hasScopes()) {
            return;
        }
        if ("constraint".equals(this.fCFScopeScanner.getPeekScope().getScopeName())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            return;
        }
        if (this.fCFScopeScanner.getPeekScope().isMultiConstructScope()) {
            return;
        }
        if ("do".equals(peekScope.getScopeName())) {
            return;
        }
        this.fCFScopeScanner.setShouldCloseShortScopeAndRecurseUntilMultiConstructOrExceptions(this.fShortScopeExceptions);
    }

    private void updateOnCase(CFToken token) {
        if (this.fPotentialAction) {
            this.fCFScopeScanner.pushScope(token, "case", CFScope.SHORT_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnColon(CFToken token) {
        CFScope prePeekScope = this.fCFScopeScanner.getPrePeekScope();
        if (prePeekScope == null) {
            return;
        }
        if ("case".equals(prePeekScope.getScopeName())) {
            this.fCFScopeScanner.pushScope(token, ":", CFScope.SHORT_SCOPE, CFScope.INDENT);
        }
    }
}

