/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.formatter;

import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.ICFVTokenScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.util.CFSyso;
import ro.amiq.pssdt.ui.editor.formatter.PSSCFScopeScanner;

public class PSSCFVScanner
extends PSSCFScopeScanner
implements ICFVTokenScannerImpl {
    private CFVScanner fCFVScanner;

    public PSSCFVScanner(CFModel model) {
        super(model);
    }

    @Override
    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        super.setCFTokenScanner(cfTokenScanner);
        this.fCFVScanner = (CFVScanner)cfTokenScanner;
    }

    @Override
    public void startChunk(CFChunk chunk) {
        super.startChunk(chunk);
        this.fCFVScanner.verticalAlignStartChunk(chunk);
    }

    @Override
    public void endChunk(CFChunk chunk) {
        super.endChunk(chunk);
        this.fCFVScanner.verticalAlignEndChunk(chunk);
    }

    @Override
    public void startToken(CFToken token) {
        super.startToken(token);
        this.fCFVScanner.verticalAlignStartToken(token);
    }

    @Override
    public void endToken(CFToken token) {
        super.endToken(token);
        this.fCFVScanner.verticalAlignEndToken(token);
    }

    public void verticalAlign() {
        this.fCFVScanner.verticalAlign();
    }

    public CFVScope createVScope(CFToken token, String scopeName, boolean isShortScope, int indentKind) {
        CFVScope currentVScope = this.fCFVScanner.getCurrentVScope();
        if (currentVScope == null) {
            return null;
        }
        int vScopeId = currentVScope.getVScopeId();
        int vScopeLevel = currentVScope.getVScopeLevel();
        String vScopeName = currentVScope.getScopeName();
        CFScope prePeekScope = this.fCFVScanner.getPrePeekScope();
        if ("if".equals(scopeName) || "else".equals(scopeName) || ":".equals(scopeName)) {
            this.fCFVScanner.setVScopeLevel(++vScopeLevel);
        } else if ("{".equals(scopeName) && ("if".equals(vScopeName) || "else".equals(vScopeName) || ":".equals(vScopeName))) {
            this.fCFVScanner.setVScopeLevel(++vScopeLevel);
        } else if ("{".equals(scopeName) && prePeekScope != null && "case".equals(prePeekScope.getScopeName())) {
            this.fCFVScanner.setVScopeLevel(++vScopeLevel);
        } else {
            vScopeId = this.fCFVScanner.getVScopeId() + 1;
            vScopeLevel = 0;
            this.fCFVScanner.setVScopeId(vScopeId);
            this.fCFVScanner.setVScopeLevel(vScopeLevel);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("create scope: ").append(scopeName).append(" id:").append(vScopeId).append(" level:").append(vScopeLevel).append(" line:").append(token.getLineNo());
        CFSyso.println((String)"VALIGN", (StringBuilder)sb);
        return new CFVScope(token, scopeName, isShortScope, indentKind, vScopeId, vScopeLevel, token.getStartOffsetInLine());
    }

    public void compactWSForVerticalAlignPatterns() {
    }
}

