/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.formatter;

import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.pssdt.ui.editor.PSSSourceViewerConfiguration;

public class PSSCodeFormattingStrategy
extends DVTBaseCodeFormattingStrategy {
    public PSSCodeFormattingStrategy(PSSSourceViewerConfiguration configuration, CFPreferences formatPreferences) {
        super((DVTSourceViewerConfiguration)configuration, formatPreferences);
    }

    public boolean isWordChar(char c, char prevChar, char nextChar, StringBuilder currWord) {
        return Character.isJavaIdentifierPart(c) || c == '\'' || c == '.';
    }

    public boolean allowWhitespaceBeforeToken(CFToken token) {
        return true;
    }

    public boolean allowWhitespaceAfterToken(CFToken token) {
        return true;
    }

    public void fixWhitespaceAfterCodeMarkerInExpansion(CFToken token) {
        CFChunk prevChunk;
        if (token == null) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        String tokenValue = token.getValue();
        if (!tokenValue.trim().isEmpty() && (prevChunk = lineInfo.getChunkBefore(chunk)) != null && prevChunk.hasInfo("codeMarkerInExpansion") && chunk.getValue().substring(0, token.getStartOffsetInChunk()).trim().isEmpty() && token.getStartOffsetInChunk() != 1) {
            chunk.addAction(new CFAction(0, token.getStartOffsetInChunk(), " ", "add whitespace after"));
        }
    }

    protected boolean isClosingToken(String tokenValue) {
        return false;
    }
}

