/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.highlight;

import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.MethodKind;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.StructKind;

public class PSSHlUtils
extends DVTHlUtils {
    public static HighlightKind getHighlightKind(Object element) {
        if (element instanceof RfEnumItem) {
            return HighlightKind.PSS_ENUM_ITEMS;
        }
        if (element instanceof RfStruct) {
            StructKind structKind = ((RfStruct)element).getStructKind();
            if (structKind == StructKind.ACTION || structKind == StructKind.ACTION_ABSTRACT) {
                return HighlightKind.ACTION;
            }
            if (structKind == StructKind.COMPONENT) {
                return HighlightKind.COMPONENT;
            }
            return HighlightKind.TYPE;
        }
        if (element instanceof RfEnumType || element instanceof RfTypeAlias || element instanceof RfStruct || element instanceof RfPackage || element instanceof RfCovergroup) {
            return HighlightKind.TYPE;
        }
        if (element instanceof RfMethod) {
            MethodKind methodKind = ((RfMethod)element).getMethodKind();
            if (methodKind == MethodKind.SYMBOL) {
                return HighlightKind.SYMBOL;
            }
            return HighlightKind.METHOD;
        }
        if (element instanceof RfField) {
            StructKind structKind;
            RfField field = (RfField)element;
            FieldModifier fieldModifier = field.getFieldModifier();
            RfNamedElement enclosingScope = field.getEnclosingScope();
            if (enclosingScope instanceof RfStruct && field.isPredefined()) {
                RfStruct struct = (RfStruct)enclosingScope;
                structKind = struct.getStructKind();
                if ((structKind == StructKind.ACTION_ABSTRACT || structKind == StructKind.ACTION || structKind == StructKind.COMPONENT) && field.getName().equals("comp")) {
                    return HighlightKind.KEYWORD;
                }
                if ((structKind == StructKind.ACTION_ABSTRACT || structKind == StructKind.ACTION || structKind == StructKind.COMPONENT || structKind == StructKind.STRUCT) && field.getName().equals("this")) {
                    return HighlightKind.KEYWORD;
                }
            }
            if (field.isInstance()) {
                return HighlightKind.PSS_COMPONENT_INSTANCE;
            }
            if (fieldModifier == FieldModifier.CONST || fieldModifier == FieldModifier.STATIC_CONST) {
                return HighlightKind.STATIC_CONST;
            }
            if (fieldModifier == FieldModifier.INPUT) {
                return HighlightKind.PORT;
            }
            if (fieldModifier == FieldModifier.OUTPUT) {
                return HighlightKind.OUT_PORT;
            }
            if (!field.isSymbolParam() && field.isActionHandle()) {
                return HighlightKind.ACTION_HANDLE;
            }
            if (fieldModifier == FieldModifier.SYMBOL_PARAM || fieldModifier == FieldModifier.METHOD_PARAM) {
                return HighlightKind.ARGUMENT;
            }
            if (fieldModifier == FieldModifier.POOL) {
                RfNamedElement associatedBaseType = field.getAssociatedBaseType();
                while (associatedBaseType instanceof RfTypeAlias) {
                    associatedBaseType = ((RfTypeAlias)associatedBaseType).getAssociatedBaseType();
                }
                if (associatedBaseType instanceof RfStruct && (structKind = ((RfStruct)associatedBaseType).getStructKind()) == StructKind.RESOURCE) {
                    return HighlightKind.POOL_OF_RESOURCE;
                }
                return HighlightKind.POOL_OF_FLOW;
            }
            if (fieldModifier == FieldModifier.LOCK) {
                return HighlightKind.LOCK;
            }
            if (fieldModifier == FieldModifier.SHARE) {
                return HighlightKind.SHARE;
            }
            if (fieldModifier == FieldModifier.INDEX) {
                return HighlightKind.VARIABLE;
            }
            return HighlightKind.FIELD;
        }
        if (element instanceof RfBlock) {
            return HighlightKind.LABEL;
        }
        return HighlightKind.DEFAULT;
    }
}

