/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.highlight;

import antlr.collections.AST;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightJob;
import ro.amiq.pssdt.model.PSSFileInfo;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.parser.HighlightWalker;

public class PSSSemanticHighlighter
extends DVTSemanticHighlighter<RfFileDef> {
    public PSSSemanticHighlighter(IDocument document) {
        super(document);
    }

    public void process(IRfFileDef file, SemanticHighlightJob job, int startOffset, int endOffset) {
        if (!(file instanceof RfFileDef)) {
            return;
        }
        RfFileDef fileDef = (RfFileDef)file;
        RfProject project = fileDef.getRfProject();
        if (project == null) {
            return;
        }
        PSSFileInfo fileInfoByParserPath = project.getFileInfo(fileDef.getFileReference());
        if (fileInfoByParserPath == null) {
            return;
        }
        AST moduleAST = fileInfoByParserPath.getAST();
        if (moduleAST == null) {
            return;
        }
        super.process(file, job, startOffset, endOffset);
        HighlightWalker semanticHighlightWalker = new HighlightWalker(fileDef.getDocument(), fileDef.getParserPath(), startOffset, endOffset);
        semanticHighlightWalker.walkFile(moduleAST, this.getPositions());
    }

    protected Collection<RfFileDef> getChildren(RfFileDef root) {
        return null;
    }

    protected void doHighlight(RfFileDef root) throws BadLocationException {
    }

    protected IStatus doHighlightRecursive(RfFileDef root, Set<RfFileDef> visited, SemanticHighlightJob job) throws BadLocationException, BadPositionCategoryException, Exception {
        return Status.OK_STATUS;
    }
}

