/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.hover;

import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import ro.amiq.pssdt.ui.editor.PSSCodeScanner;
import ro.amiq.pssdt.ui.editor.PSSCommentScanner;
import ro.amiq.pssdt.ui.editor.PSSStyle;
import ro.amiq.pssdt.ui.editor.hover.PSSHoverNonRuleBasedReconciler;
import ro.amiq.pssdt.ui.editor.hover.PSSHoverSourceViewerReconciler;

public class PSSHoverSourceViewerConfiguration
extends SourceViewerConfiguration {
    private PSSCodeScanner fCodeScanner;
    private PSSCommentScanner fCommentScanner;
    private PSSStyle fColorManager;

    public PSSHoverSourceViewerConfiguration(PSSStyle colorManager) {
        this.fColorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__pss_literal", "__pss_expansion", "__pss_escaped_id", "__pss_sl_comment", "__pss_ml_comment"};
    }

    protected PSSCodeScanner getCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new PSSCodeScanner(this.fColorManager, 0);
            this.fCodeScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.default"));
        }
        return this.fCodeScanner;
    }

    protected PSSCommentScanner getCommentScanner() {
        if (this.fCommentScanner == null) {
            this.fCommentScanner = new PSSCommentScanner(this.fColorManager, false, 0, false, null);
            this.fCommentScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.default"));
        }
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        PSSHoverSourceViewerReconciler dr1 = new PSSHoverSourceViewerReconciler((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr1, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr1, "__dftl_partition_content_type");
        PSSHoverSourceViewerReconciler dr2 = new PSSHoverSourceViewerReconciler((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr2, "__pss_sl_comment");
        reconciler.setRepairer((IPresentationRepairer)dr2, "__pss_sl_comment");
        PSSHoverSourceViewerReconciler dr3 = new PSSHoverSourceViewerReconciler((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr3, "__pss_ml_comment");
        reconciler.setRepairer((IPresentationRepairer)dr3, "__pss_ml_comment");
        PSSHoverNonRuleBasedReconciler ndr1 = new PSSHoverNonRuleBasedReconciler(this.fColorManager, "highlight.string");
        reconciler.setDamager((IPresentationDamager)ndr1, "__pss_literal");
        reconciler.setRepairer((IPresentationRepairer)ndr1, "__pss_literal");
        return reconciler;
    }
}

