/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.hover;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.custom.StyleRange;

public class PSSHoverSourceViewerReconciler
implements IPresentationDamager,
IPresentationRepairer {
    protected IDocument fDocument;
    protected ITokenScanner fScanner;
    protected TextAttribute fDefaultTextAttribute;

    public PSSHoverSourceViewerReconciler(ITokenScanner scanner) {
        this.fScanner = scanner;
        this.fDefaultTextAttribute = new TextAttribute(null);
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        return partition;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        IToken token;
        if (this.fScanner == null) {
            this.addRange(presentation, region.getOffset(), region.getLength(), this.fDefaultTextAttribute);
            return;
        }
        int lastStart = region.getOffset();
        int length = 0;
        boolean firstToken = true;
        IToken lastToken = Token.UNDEFINED;
        TextAttribute lastAttribute = this.getTokenTextAttribute(lastToken);
        this.fScanner.setRange(this.fDocument, lastStart, region.getLength());
        while (!(token = this.fScanner.nextToken()).isEOF()) {
            TextAttribute attribute = this.getTokenTextAttribute(token);
            if (lastAttribute != null && lastAttribute.equals((Object)attribute)) {
                length += this.fScanner.getTokenLength();
                firstToken = false;
                continue;
            }
            if (!firstToken) {
                this.addRange(presentation, lastStart, length, lastAttribute);
            }
            firstToken = false;
            lastToken = token;
            lastAttribute = attribute;
            lastStart = this.fScanner.getTokenOffset();
            length = this.fScanner.getTokenLength();
        }
        this.addRange(presentation, lastStart, length, lastAttribute);
    }

    protected TextAttribute getTokenTextAttribute(IToken token) {
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            return (TextAttribute)data;
        }
        return this.fDefaultTextAttribute;
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            int style = attr.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            presentation.addStyleRange(styleRange);
        }
    }
}

