/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.hover;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.debug.ui.editor.hover.ITextHoverParticipant;
import ro.amiq.dvt.model.problems.PSSProblemCategories;
import ro.amiq.dvt.test.CopyTooltipToClipboardHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hover.DVTInformationControl;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipControlCreator;
import ro.amiq.dvt.ui.editor.hover.IDVTHover;
import ro.amiq.dvt.ui.editor.problem.hover.DVTProblemHoverAnnotationInfo;
import ro.amiq.dvt.ui.editor.problem.hover.DVTProblemHoverUtils;
import ro.amiq.dvt.ui.editor.problem.hover.DvtProblemHoverInput;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.ui.editor.hover.PSSProblemHover;

public class PSSTextHover
implements IDVTHover,
ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private ITextEditor fTextEditor;
    private ArrayList<ITextHoverParticipant> fTextHoverParticipants = new ArrayList();
    private PSSProblemHover problemHover;
    private IRegion currentHoverRegion;

    public PSSTextHover(ITextEditor editor) {
        this.fTextEditor = editor;
        this.problemHover = new PSSProblemHover((DVTEditor)this.fTextEditor);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion region) {
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion region) {
        this.currentHoverRegion = region;
        DVTComment.CommentFormat format = DVTComment.CommentFormat.OLD_VERBATIM;
        boolean shouldShowQuickFixLinks = DVTProblemHoverUtils.shouldShowQuickFixLinks((ITextEditor)this.fTextEditor, (IRegion)region, (Set)PSSProblemCategories.ALL_PROBLEMS);
        if (shouldShowQuickFixLinks) {
            format = CommentUtils.getInstance().getTooltipFormatterPreference();
            CommentUtils.getInstance().setTooltipFormatterPreference(DVTComment.CommentFormat.OLD_VERBATIM);
        }
        DVTTooltipContent tooltipContent = this.makeInfo(textViewer, region, this.fTextHoverParticipants);
        boolean useOldTooltip = CommentUtils.getInstance().shouldUseOldTooltip();
        String comment = "";
        if (shouldShowQuickFixLinks || useOldTooltip) {
            comment = tooltipContent.getAllStrings();
            comment = DVTStringUtil.breakLongNonWhitespaceSequences((String)comment, (int)400, (char)'\n');
            tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, comment);
        }
        if (shouldShowQuickFixLinks) {
            Object hoverInfo2;
            CommentUtils.getInstance().setTooltipFormatterPreference(format);
            this.problemHover.setExtraTooltipInfo(comment);
            CopyTooltipToClipboardHelper.setLineAndColumn((int)tooltipContent.getLine(), (int)tooltipContent.getColumn());
            CopyTooltipToClipboardHelper.setFile((String)tooltipContent.getFile());
            StringBuilder quickFixesBuilder = new StringBuilder();
            if (comment != null && !comment.isEmpty()) {
                quickFixesBuilder.append(comment).append("<br>");
            }
            if ((hoverInfo2 = this.problemHover.getHoverInfo2(textViewer, region)) instanceof DvtProblemHoverInput) {
                Map allAnnotationInfos = ((DvtProblemHoverInput)hoverInfo2).getAnnotationInfos();
                for (Map.Entry annotationEntry : allAnnotationInfos.entrySet()) {
                    for (ICompletionProposal proposal : ((DVTProblemHoverAnnotationInfo)annotationEntry.getValue()).proposals) {
                        quickFixesBuilder.append(proposal.getDisplayString()).append("<br>");
                    }
                }
            }
            CopyTooltipToClipboardHelper.setOldTooltipContent((String)quickFixesBuilder.toString());
            return hoverInfo2;
        }
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            CopyTooltipToClipboardHelper.setLineAndColumn((int)tooltipContent.getLine(), (int)tooltipContent.getColumn());
            CopyTooltipToClipboardHelper.setFile((String)tooltipContent.getFile());
            return comment;
        }
        CopyTooltipToClipboardHelper.setLineAndColumn((int)tooltipContent.getLine(), (int)tooltipContent.getColumn());
        CopyTooltipToClipboardHelper.setFile((String)tooltipContent.getFile());
        CopyTooltipToClipboardHelper.setTooltipComment((String)tooltipContent.getSignature(), (String)(String.valueOf(tooltipContent.getShallow()) + tooltipContent.getComment() + tooltipContent.getDebugInfo()), (String)tooltipContent.getUPFSignature());
        CopyTooltipToClipboardHelper.setPreference((String)tooltipContent.getPreference());
        CopyTooltipToClipboardHelper.setWaveDromDiagram((String)tooltipContent.getWaveDromDiagram());
        CopyTooltipToClipboardHelper.setBitFieldDiagram((String)tooltipContent.getBitFieldDiagram());
        return tooltipContent.isEmpty() ? null : tooltipContent;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (DVTProblemHoverUtils.shouldShowQuickFixLinks((ITextEditor)this.fTextEditor, (IRegion)this.currentHoverRegion, (Set)PSSProblemCategories.ALL_PROBLEMS)) {
            return this.problemHover.getHoverControlCreator();
        }
        return parent -> {
            if (CommentUtils.getInstance().shouldUseOldTooltip()) {
                return new DVTInformationControl(parent, "Press 'F2' to focus");
            }
            return new DVTTooltipControlCreator(true).createInformationControl(parent);
        };
    }

    public void addTextHoverParticipant(ITextHoverParticipant textHoverParticipant) {
        textHoverParticipant.setTextEditor(this.fTextEditor);
        this.fTextHoverParticipants.add(textHoverParticipant);
    }

    public void removeTextHoverParticipant(ITextHoverParticipant textHoverParticipant) {
        this.fTextHoverParticipants.remove(textHoverParticipant);
    }
}

