/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.hover;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.debug.ui.editor.hover.ITextHoverParticipant;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.pssdt.utils.PSSFileUtils;

public class PSSTextHoverParticipant
implements ITextHoverParticipant {
    private ITextEditor fTextEditor;

    public void makeInfo(ITextViewer textViewer, IRegion region, DVTTooltipContent tooltipContent) {
        block14: {
            try {
                if (region == null || this.fTextEditor == null) {
                    return;
                }
                IDocument document = textViewer.getDocument();
                if (document == null) {
                    return;
                }
                int offset = region.getOffset();
                IProject project = this.getProject(this.fTextEditor);
                if (project == null) {
                    return;
                }
                if (!DVTPlugin.getDefault().collect().c(project, "F707373")) {
                    return;
                }
                int line = document.getLineOfOffset(offset);
                int col = offset - DVTDocumentUtils.documentLineOffset((Object)document, (int)line);
                tooltipContent.set(DVTTooltipContent.TooltipContent.LINE, Integer.valueOf(line + 1));
                tooltipContent.set(DVTTooltipContent.TooltipContent.COLUMN, Integer.valueOf(col + 1));
                PSSFileUtils fileUtilsInstance = PSSFileUtils.getInstance();
                IFile fileFromViewer = fileUtilsInstance != null ? fileUtilsInstance.getFileFromViewer(textViewer) : null;
                IPath relativePath = fileFromViewer != null ? fileFromViewer.getProjectRelativePath() : null;
                String filePath = relativePath == null ? "" : relativePath.lastSegment();
                tooltipContent.set(DVTTooltipContent.TooltipContent.FILE, filePath);
                String contextType = ((IDocumentExtension3)document).getContentType("__pss_partitioning", offset, false);
                if (contextType.equals("__dftl_partition_content_type") || contextType.equals("__pss_expansion")) {
                    List<RfWNamedElementAndScope> elementScopes = RfUtils.getRfElements(this.fTextEditor, document, offset = Math.min(offset + 1, document.getLength() - 1));
                    if (elementScopes == null) {
                        return;
                    }
                    elementScopes.forEach(element -> RfUtils.getTooltipFormattedText(element.getIRfNamedElement(), this.fTextEditor, tooltipContent));
                    break block14;
                }
                if (contextType.equals("__pss_sl_comment") || contextType.equals("__pss_ml_comment")) {
                    try {
                        String waveform = WaveDromManager.getInstance().getWaveform(textViewer.getDocument(), this.getFile(), offset, "__pss_partitioning", contextType);
                        if ("WaveDrom description file not found!".equals(waveform) || "WaveDrom description file does not have a valid extension!".equals(waveform)) {
                            tooltipContent.set(DVTTooltipContent.TooltipContent.WAVEDROM_DIAGRAM, waveform);
                            break block14;
                        }
                        tooltipContent.set(DVTTooltipContent.TooltipContent.WAVEDROM_DIAGRAM, Wavedrom.getInstance().generateSVG(waveform));
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    break block14;
                }
                IAnnotationModel annotationModel = this.getAnnotationModel(this.fTextEditor);
                if (annotationModel != null) {
                    Iterator iter = annotationModel.getAnnotationIterator();
                    while (iter.hasNext()) {
                        Annotation annotation = (Annotation)iter.next();
                        Position position = annotationModel.getPosition(annotation);
                        if (!annotation.getType().equals("org.eclipse.ui.workbench.texteditor.spelling") || region.getOffset() < position.getOffset() || region.getOffset() > position.getOffset() + position.getLength()) continue;
                        tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, annotation.getText());
                        return;
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    protected IAnnotationModel getAnnotationModel(ITextEditor editor) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider != null) {
            return documentProvider.getAnnotationModel((Object)editor.getEditorInput());
        }
        return null;
    }

    public void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    private IProject getProject(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    private IFile getFile() {
        if (this.fTextEditor == null) {
            return null;
        }
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }
}

