/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.lazy.outline;

import antlr.collections.AST;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.lazy.outline.AbstractLazyOutlineProvider;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.model.PSSFileInfo;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfKind;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.views.OutlineTreeViewProvider;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.ui.editor.lazy.outline.PSSOutlineUtil;

public class PSSLazyOutlineProvider
extends AbstractLazyOutlineProvider {
    public static final Map<String, String> PSS_OUTLINE_FIELDS = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Show actions", "outline.show_actions");
            this.put("Show activities", "outline.show_activities");
            this.put("Show components", "outline.show_components");
            this.put("Show constraints", "outline.show_constraints");
            this.put("Show covergroups", "outline.show_covergroups");
            this.put("Show exec blocks", "outline.show_exec_blocks");
            this.put("Show fields", "outline.show_fields");
            this.put("Show functions", "outline.show_functions");
            this.put("Show labeled blocks", "outline.show_blocks");
            this.put("Show packages", "outline.show_packages");
            this.put("Show structs", "outline.show_structs");
            this.put("Show types", "outline.show_types");
        }
    };

    public PSSLazyOutlineProvider(DVTEditor editor) {
        super(editor);
        this.labelProvider = new OutlineTreeViewProvider();
    }

    public IRfFileDef getFileDef() {
        if (this.editor == null) {
            return null;
        }
        IFile currentFile = this.editor.getCurrentFile();
        if (currentFile == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(this.editor.getProject());
        if (rfProject == null) {
            return null;
        }
        return rfProject.getFile((IResource)currentFile);
    }

    public boolean isOutlineElement(IRfDefElement def) {
        return PSSOutlineUtil.INSTANCE.isOutlineElement(def);
    }

    public DVTGUIFilterMatcher.GUIFilterResult getFilterResult(IRfDefElement element) {
        return PSSOutlineUtil.INSTANCE.getFilterResult(element);
    }

    public boolean isPossibleOutlineParent(IRfDefElement def) {
        return PSSOutlineUtil.INSTANCE.isPossibleOutlineParent(def);
    }

    public boolean isUnnamedBlock(IRfDefElement def) {
        return PSSOutlineUtil.INSTANCE.isUnnamedBlock(def);
    }

    public int getCategory(IRfDefElement def) {
        IRfNamedElement namedElem = def.getNamedElement();
        RfKind kind = RfKind.of(namedElem);
        return kind.ordinal();
    }

    public Collection<?> getChildren(IRfDefElement root) {
        RfDefElement declaration;
        RfNamedElement assocType;
        FieldModifier fieldModifier;
        IRfNamedElement rootNamedElement = root.getNamedElement();
        if (rootNamedElement == null) {
            return null;
        }
        Collection<RfDefElement> children = root.getChildren();
        if (rootNamedElement instanceof RfField && (fieldModifier = ((RfField)rootNamedElement).getFieldModifier()) == FieldModifier.COVERGROUP_INLINE && (assocType = ((RfField)rootNamedElement).getAssociatedType()) instanceof RfCovergroup && (declaration = assocType.getDeclaration()) != null) {
            children = declaration.getChildren();
        }
        return children;
    }

    public boolean isLexicallySorted() {
        return PSSPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
    }

    public boolean isCategoricallySorted() {
        return PSSPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
    }

    public IDVTElementWrapper createElementTreeWrapper(Object rfElement) {
        return new RfTreeElementWrapper(rfElement);
    }

    public AST getRootAST() {
        RfProject rfProject = RfManager.getInstance().getRfProject(this.editor.getProject());
        if (rfProject == null) {
            return null;
        }
        IFile iFile = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (iFile == null) {
            return null;
        }
        RfFileDef fileDef = rfProject.getFile((IResource)iFile);
        if (fileDef == null) {
            return null;
        }
        PSSFileInfo fileInfo = rfProject.getFileInfo(fileDef.getFileReference());
        if (fileInfo == null) {
            return null;
        }
        return fileInfo.getAST();
    }
}

