/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.outline;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;

public class AccessLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "ro.amiq.pssdt.AccessLabelDecorator";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof RfTreeElementWrapper || element instanceof TreePath) {
            this.decorateRfDefElement(element, decoration);
        }
    }

    private void decorateRfDefElement(Object wrapper, IDecoration decoration) {
        Object element = null;
        if (wrapper instanceof RfTreeElementWrapper) {
            element = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        } else if (wrapper instanceof TreePath) {
            element = ((TreePath)wrapper).getElement();
        }
        if (element == null) {
            return;
        }
        if (element instanceof RfDefElement) {
            element = ((RfDefElement)element).getNamedElement();
        }
        if (element instanceof RfField) {
            if (wrapper instanceof RfTreeElementWrapper && !((RfTreeElementWrapper)((Object)wrapper)).getAccessDecoratorEnable()) {
                return;
            }
            RfNamedElement namedElement = (RfNamedElement)element;
            if (!(namedElement instanceof RfField)) {
                return;
            }
            RfField field = (RfField)namedElement;
            FieldModifier fieldModifier = field.getFieldModifier();
            if (fieldModifier == FieldModifier.COVERCROSS || fieldModifier == FieldModifier.COVERPOINT || fieldModifier == FieldModifier.COVERGROUP_PORT || fieldModifier == FieldModifier.SYMBOL_PARAM || fieldModifier == FieldModifier.METHOD_PARAM || fieldModifier == FieldModifier.INDEX) {
                return;
            }
            if (namedElement.isPrivate()) {
                decoration.addOverlay(DVTImages.OVR_PRIVATE, 0);
            } else if (namedElement.isProtected()) {
                decoration.addOverlay(DVTImages.OVR_PROTECTED, 0);
            } else {
                decoration.addOverlay(DVTImages.OVR_PUBLIC, 0);
            }
        }
    }

    public void refresh(final Object[] elements) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AccessLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)AccessLabelDecorator.this, elements));
            }
        });
    }
}

