/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;

public class DeclareEnumQuickFix
extends BaseAbstractQuickFix {
    private int insertOffset;
    private String insertText;

    public DeclareEnumQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Declare enum type value '" + this.elementName + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENUM_ITEM);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.insertOffset = this.marker.getAttribute("QUICKFIX_ENUM_INSERT_OFFSET", -1);
        this.insertText = ", " + this.elementName;
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        String parserPath = this.marker.getAttribute("QUICKFIX_INSERT_FILE", null);
        if (parserPath != null && this.marker.getResource() != null) {
            IProject project = this.marker.getResource().getProject();
            this.targetResource = this.getResource(project, parserPath);
            this.triggerEditor = (DVTEditor)DVTUiUtils.getActivePage().getActiveEditor();
        }
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        this.targetDocument.replace(this.insertOffset, 0, this.insertText);
        this.targetEditor.selectAndReveal(this.insertOffset, this.insertText.length());
    }

    public IFile[] getAffectedFiles() throws Exception {
        if (this.targetResource == null || !(this.targetResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)this.targetResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

