/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;

public class DeprecatedPkgReplaceQuickFix
extends BaseAbstractQuickFix {
    public DeprecatedPkgReplaceQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Replace deprecated package '" + this.elementName + "' with '" + this.getReplacementPackageName() + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
    }

    public String getReplacementPackageName() {
        if (this.elementName == null || this.elementName.length() == 0) {
            return null;
        }
        if (Character.isUpperCase(this.elementName.charAt(0))) {
            return "NUMERIC_STD";
        }
        return "numeric_std";
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        String replacementPackageName = this.getReplacementPackageName();
        document.replace(this.position.getOffset(), this.position.getLength(), replacementPackageName);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

