/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.QuickFixException;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.util.PSSQuickFixUtil;

public class SensitivityAddQuickFix
extends BaseAbstractQuickFix {
    private IRfDefElement fDeclaration;

    public SensitivityAddQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Add signal '" + this.elementName + "' to sensitivity list";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCESS);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        RfBlock process = (RfBlock)this.enclosingScope.getNamedElement().getEnclosingScope(RfBlock.class);
        this.fDeclaration = null;
        for (IRfDefElement defElement : process.getDeclarations()) {
            if (defElement.getDefFile() != this.enclosingScope.getDefFile() || this.offset <= defElement.getStartOffset() || this.offset >= defElement.getEndOffset()) continue;
            this.fDeclaration = defElement;
            break;
        }
        if (this.fDeclaration == null) {
            throw new QuickFixException();
        }
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        int startOffset = PSSQuickFixUtil.getForwardOffsetFor(document, ")", this.fDeclaration.getStartOffset(), this.fDeclaration.getEndOffset(), false);
        if (startOffset < 0) {
            return;
        }
        document.replace(startOffset - 1, 0, ", " + this.elementName);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.fDeclaration.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

