/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.quickfix.util;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.pssdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.pssdt.model.reflection.RfLibrary;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfProject;

public class GetTypesInProjectVisitor
implements IRfNamedElementVisitor {
    private IProgressMonitor fProgressMonitor;
    private boolean monitorCancelled;

    public GetTypesInProjectVisitor(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
    }

    @Override
    public boolean visit(RfNamedElement namedElement) {
        if (this.fProgressMonitor.isCanceled()) {
            this.monitorCancelled = true;
            return false;
        }
        if (namedElement instanceof RfProject) {
            Collection<RfLibrary> libraries = ((RfProject)namedElement).getLibraries();
            if (libraries == null || libraries.isEmpty()) {
                return true;
            }
            for (RfLibrary library : libraries) {
                if (this.fProgressMonitor.isCanceled()) {
                    this.monitorCancelled = true;
                    return false;
                }
                if (this.visit(library)) continue;
                return false;
            }
        }
        boolean cfr_ignored_0 = namedElement instanceof RfLibrary;
        if (namedElement instanceof RfPackage) {
            Collection<RfNamedElement> members = namedElement.getLocalMembers();
            if (members == null || members.isEmpty()) {
                return true;
            }
            for (RfNamedElement member : members) {
                if (this.fProgressMonitor.isCanceled()) {
                    this.monitorCancelled = true;
                    return false;
                }
                if (!(member instanceof RfPackage) || this.visit(member)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isMonitorCancelled() {
        return this.monitorCancelled;
    }
}

