/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.quickfix.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.DesignElementQuickFixProxy;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.editor.quickfix.util.MinWordDistanceComparator;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfLibrary;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.r2lparser.R2LManager;
import ro.amiq.pssdt.r2lparser.R2LNoProposalElement;
import ro.amiq.pssdt.r2lparser.R2LProposalManager;
import ro.amiq.pssdt.r2lparser.R2LResultContainer;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.CaseChoiseAddQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.CaseChoiseRemoveQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.DeclareEnumQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.DeprecatedPkgRemoveQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.DeprecatedPkgReplaceQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.DidYouMeanQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.LibraryClauseRemoveQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.RemoveUnusedSignalQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.SensitivityAddQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.quickfixes.SensitivityRemoveQuickFix;
import ro.amiq.pssdt.ui.editor.quickfix.util.GetTypesInProjectVisitor;
import ro.amiq.pssdt.ui.editor.quickfix.util.TypeOperatorVisitor;

public class PSSQuickFixUtil
extends DVTQuickFixUtil {
    public static List<ICompletionProposal> getProposalsByKind(final int quickFixKind, final boolean isHierarchical, final IMarker marker, final ITextViewer viewer, final Object scope, final int offset, final Position position, final String elementName, final List<ICompletionProposal> existingProposals, boolean startMonitorJob) {
        final ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        if (startMonitorJob) {
            final AtomicBoolean done = new AtomicBoolean(false);
            Job computingQuickFixProposalJob = new Job("Compute Quick Fix Proposals Job"){

                protected IStatus run(IProgressMonitor monitor) {
                    List<ICompletionProposal> proposalsByKindInternal = PSSQuickFixUtil.getProposalsByKindInternal(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, monitor, false);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    result.addAll(proposalsByKindInternal);
                    done.set(true);
                    return Status.OK_STATUS;
                }
            };
            computingQuickFixProposalJob.schedule();
            long busyIndicatorTimeout = System.currentTimeMillis() + 1500L;
            DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computingQuickFixProposalJob, (AtomicBoolean)done, (String)"Computing quick fix proposals...", (long)busyIndicatorTimeout);
        } else {
            NullProgressMonitor monitor = new NullProgressMonitor();
            PSSQuickFixUtil.scheduleTimeoutWatchDog((IProgressMonitor)monitor, (int)200);
            List<ICompletionProposal> proposalsByKindInternal = PSSQuickFixUtil.getProposalsByKindInternal(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, (IProgressMonitor)monitor, true);
            result.addAll(proposalsByKindInternal);
        }
        return result;
    }

    public static List<ICompletionProposal> getProposalsByKindInternal(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, Object scope, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, IProgressMonitor progressMonitor, boolean isTooltipTriggered) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        boolean addDidYouMeanProposal = true;
        try {
            switch (quickFixKind) {
                case 1: {
                    if (!(scope instanceof RfDefElement)) break;
                    RfDefElement enclosingScope = (RfDefElement)scope;
                    enclosingScope.getNamedElement();
                    break;
                }
                case 2: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new SensitivityAddQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 3: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new SensitivityRemoveQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 48: {
                    if (!(scope instanceof RfDefElement)) break;
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new RemoveUnusedSignalQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 4: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new CaseChoiseAddQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 5: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new CaseChoiseRemoveQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 6: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new DeprecatedPkgReplaceQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 7: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new DeprecatedPkgRemoveQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 8: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new LibraryClauseRemoveQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 9: {
                    BaseAbstractQuickFix proposal = new DeclareEnumQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 10: {
                    RfDefElement elementToImportAbove;
                    RfProject enclosingProject = ((RfDefElement)scope).getRfProject();
                    if (enclosingProject == null) break;
                    GetTypesInProjectVisitor visitor = new GetTypesInProjectVisitor(progressMonitor);
                    visitor.visit(enclosingProject);
                    if (isTooltipTriggered && visitor.isMonitorCancelled()) {
                        return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
                    }
                    RfNamedElement enclosingScope = ((RfDefElement)scope).getNamedElement();
                    while (enclosingScope != null && !(enclosingScope.getEnclosingScope() instanceof RfLibrary)) {
                        enclosingScope = enclosingScope.getEnclosingScope();
                    }
                    if (enclosingScope == null || (elementToImportAbove = enclosingScope.getDeclaration()) != null) break;
                    break;
                }
                case 38: 
                case 44: {
                    List entityPorts;
                    DesignElementQuickFixProxy designElementProxy;
                    IRfInstanceElement instance;
                    RfDefElement instanceDeclaration;
                    RfDefElement enclosingDef;
                    RfNamedElement namedElement;
                    BaseAbstractQuickFix proposal;
                    addDidYouMeanProposal = false;
                    if (!(scope instanceof RfDefElement) || (namedElement = (enclosingDef = (RfDefElement)scope).getNamedElement()) == null || !(namedElement instanceof IRfInstanceElement) || (instanceDeclaration = (RfDefElement)(instance = (IRfInstanceElement)namedElement).getDeclaration()) == null) break;
                    IRfNamedElement instanceDesignElement = instance.getGenericDesign(null);
                    List instancePortConnections = instance.getHidOperators(ELConstants.PORT_AND_GENERIC_VALUES_QUALIFIERS_ARRAY, true);
                    if (instanceDesignElement == null || !(instanceDesignElement instanceof IRfDesignElement)) break;
                    HashSet<Class<RfStruct>> classes = new HashSet<Class<RfStruct>>();
                    classes.add(RfStruct.class);
                    IRfScopeElement triggerEntityScope = instanceDeclaration.getEnclosingScope(classes);
                    if (!(triggerEntityScope instanceof IRfDesignElement) || (proposal = (designElementProxy = new DesignElementQuickFixProxy(marker, viewer, instance, (IRfDesignElement)instanceDesignElement, (IRfDesignElement)triggerEntityScope)).getUpdateInstanceQuickFix(instancePortConnections, (Collection)(entityPorts = ((IRfDesignElement)instanceDesignElement).getLocalPorts()))) == null) break;
                    ArrayList quickFixClass = new ArrayList();
                    quickFixClass.add(((Object)((Object)proposal)).getClass());
                    if (PSSQuickFixUtil.containsProposal(quickFixClass, existingProposals)) break;
                    proposal.setParameters(offset, position, enclosingDef, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
            }
            int wordLength = position.getLength();
            if (addDidYouMeanProposal && wordLength > 2) {
                ArrayList quickFixClass = new ArrayList();
                quickFixClass.add(DidYouMeanQuickFix.class);
                if (!PSSQuickFixUtil.containsProposal(quickFixClass, existingProposals)) {
                    PSSQuickFixUtil.addDidYouMeanProposal(marker, viewer, scope, offset, position, elementName, proposals, progressMonitor, isTooltipTriggered);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return proposals;
    }

    private static void addDidYouMeanProposal(IMarker marker, ITextViewer viewer, Object scope, int offset, Position position, String elementName, List<ICompletionProposal> proposals, IProgressMonitor progressMonitor, boolean isTooltipTriggered) throws BadLocationException {
        RfFileDef file;
        RfDefElement containingScope = (RfDefElement)scope;
        if (containingScope == null) {
            return;
        }
        RfFileDef rfFileDef = file = containingScope instanceof RfFileDef ? (RfFileDef)containingScope : containingScope.getDefFile();
        if (file == null) {
            return;
        }
        IResource fileAdapter = file.getFileAdapter();
        IDocument document = file.getDocument();
        RfProject rfProject = containingScope.getRfProject();
        if (fileAdapter == null || document == null || rfProject == null) {
            return;
        }
        if (position == null) {
            return;
        }
        int startOffset = position.getOffset();
        int length = position.getLength();
        if (startOffset < 0 || length == 0) {
            return;
        }
        String distanceTo = document.get(startOffset, length);
        IRfNamedElement[] candidates = PSSQuickFixUtil.getSortedCandidates(rfProject, containingScope, fileAdapter, document, startOffset + length, distanceTo);
        if (candidates == null) {
            return;
        }
        int maxCandidates = Math.min(candidates.length, 3);
        int i = 0;
        while (i < maxCandidates) {
            if (progressMonitor.isCanceled() && isTooltipTriggered) {
                proposals.clear();
                proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
                return;
            }
            IRfNamedElement candidate = candidates[i];
            String name = candidate.getName();
            if (name != null && !name.isEmpty()) {
                Image image = candidate.getImage();
                if (image == null || image.isDisposed()) {
                    image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
                }
                DidYouMeanQuickFix proposal = new DidYouMeanQuickFix(marker, viewer, name, image, file);
                proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                proposals.add((ICompletionProposal)proposal);
            }
            ++i;
        }
    }

    private static IRfNamedElement[] getSortedCandidates(RfProject rfProject, RfDefElement containingScope, IResource fileAdapter, IDocument document, int proposalEndOffset, String distanceTo) {
        R2LProposalManager manager = new R2LProposalManager(rfProject, containingScope, fileAdapter, document, proposalEndOffset, true);
        R2LResultContainer r2lResultContainer = ((R2LManager)manager).getProposals();
        if (r2lResultContainer == null) {
            return null;
        }
        IRfNamedElement[] candidates = r2lResultContainer.candidates;
        if (candidates == null || candidates.length == 0 || candidates[0] instanceof R2LNoProposalElement) {
            return null;
        }
        ArrayList<IRfNamedElement> listOfCandidates = new ArrayList<IRfNamedElement>();
        HashSet<String> candidateNames = new HashSet<String>();
        IRfNamedElement[] iRfNamedElementArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            IRfNamedElement candidate = iRfNamedElementArray[n2];
            String candidateName = candidate.getName();
            if (!candidateName.equals(distanceTo) && !candidateNames.contains(candidateName)) {
                listOfCandidates.add(candidate);
                candidateNames.add(candidateName);
            }
            ++n2;
        }
        candidates = listOfCandidates.toArray(new IRfNamedElement[listOfCandidates.size()]);
        Arrays.sort(candidates, new MinWordDistanceComparator(distanceTo));
        return candidates;
    }

    private static boolean containsProposal(List<Class<?>> proposalsToCheck, List<ICompletionProposal> existingProposals) {
        for (ICompletionProposal existingProposal : existingProposals) {
            if (!proposalsToCheck.contains(existingProposal.getClass())) continue;
            return true;
        }
        return false;
    }

    public static final int getForwardOffsetFor(IDocument document, String text, int offset, int maxOffsetLimit, boolean grabEndOfLine) {
        String content;
        int ch;
        DVTCharacterScanner scanner;
        block29: {
            char pch;
            int index;
            block28: {
                maxOffsetLimit = Math.min(document.getLength(), maxOffsetLimit);
                text = text.toUpperCase();
                scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), true);
                index = 0;
                pch = ' ';
                ch = 0;
                content = ((IDocumentExtension3)document).getContentType("__pss_partitioning", scanner.getOffset(), false);
                if ("__dftl_partition_content_type".equals(content) || "__pss_expansion".equals(content)) break block28;
                return -1;
            }
            do {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return maxOffsetLimit;
                }
                content = ((IDocumentExtension3)document).getContentType("__pss_partitioning", scanner.getOffset(), false);
                if (ch == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                if (!"__dftl_partition_content_type".equals(content) && !"__pss_expansion".equals(content)) continue;
                index = Character.toUpperCase((char)ch) == text.charAt(index) && (!Character.isJavaIdentifierPart(ch) || Character.isWhitespace(pch) || Character.isJavaIdentifierPart(pch)) ? ++index : 0;
                if (index == text.length()) {
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    scanner.unread();
                    if (ch == -1 || !Character.isWhitespace((char)ch) || !Character.isJavaIdentifierPart((char)ch)) {
                        if (grabEndOfLine && ch != -1) break;
                        return scanner.getOffset();
                    }
                    index = 0;
                }
                pch = (char)ch;
            } while (scanner.getOffset() < maxOffsetLimit);
            if (index != 0 && grabEndOfLine) break block29;
            return 0;
        }
        try {
            boolean removedMlComment = false;
            while (true) {
                if ("__dftl_partition_content_type".equals(content)) {
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    content = ((IDocumentExtension3)document).getContentType("__pss_partitioning", scanner.getOffset(), false);
                    if (ch == -1) {
                        scanner.unread();
                        return scanner.getOffset();
                    }
                    if ((char)ch == '\r' || (char)ch == '\n') {
                        scanner.unread();
                    } else {
                        if (Character.isWhitespace((char)ch)) continue;
                        scanner.unread();
                        return scanner.getOffset();
                    }
                }
                removedMlComment = false;
                while ("__pss_ml_comment".equals(content)) {
                    removedMlComment = true;
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    content = ((IDocumentExtension3)document).getContentType("__pss_partitioning", scanner.getOffset(), false);
                    if (ch != -1) continue;
                    scanner.unread();
                    return scanner.getOffset();
                }
                if (!removedMlComment) break;
            }
            while ("__pss_sl_comment".equals(content)) {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return maxOffsetLimit;
                }
                content = ((IDocumentExtension3)document).getContentType("__pss_partitioning", scanner.getOffset(), false);
                if (ch == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                if ((char)ch != '\r' && (char)ch != '\n') continue;
                scanner.unread();
                break;
            }
            if ("__dftl_partition_content_type".equals(content) || "__pss_expansion".equals(content) || "__pss_sl_comment".equals(content)) {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return maxOffsetLimit;
                }
                content = ((IDocumentExtension3)document).getContentType("__pss_partitioning", scanner.getOffset(), false);
                if (ch == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                if ((char)ch == '\r') {
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    if ((char)ch == '\n') {
                        return scanner.getOffset();
                    }
                    scanner.unread();
                    return scanner.getOffset();
                }
                if ((char)ch == '\n') {
                    return scanner.getOffset();
                }
                scanner.unread();
                return scanner.getOffset();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public static final int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces, boolean grabEndOfLine) {
        try {
            grabWhiteSpaces |= grabEndOfLine;
            text = text.toUpperCase();
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), false);
            String content = null;
            int index = 0;
            char pch = ' ';
            do {
                int ch;
                if ((ch = scanner.read()) == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                index = Character.toUpperCase((char)ch) == text.charAt(text.length() - index - 1) && (index != 0 || index == 0 && Character.isJavaIdentifierPart(ch) && !Character.isJavaIdentifierPart(pch) || index == 0 && !Character.isJavaIdentifierPart(ch)) ? ++index : 0;
                if (index == text.length()) {
                    ch = scanner.read();
                    if (!(Character.isJavaIdentifierStart(text.charAt(0)) && Character.isJavaIdentifierStart((char)ch) || ch != -1 && Character.isWhitespace((char)ch) && Character.isJavaIdentifierPart((char)ch))) {
                        while (grabWhiteSpaces && Character.isWhitespace((char)ch) && (grabEndOfLine || (char)ch != '\r' && (char)ch != '\n')) {
                            ch = scanner.read();
                        }
                        scanner.unread();
                        return scanner.getOffset();
                    }
                    index = 0;
                }
                if (!(content = ((IDocumentExtension3)document).getContentType("__pss_partitioning", scanner.getOffset(), false)).equals("__dftl_partition_content_type") && !content.equals("__pss_expansion")) continue;
                pch = (char)ch;
            } while (scanner.getOffset() > minOffsetLimit);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public static final int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces) {
        return PSSQuickFixUtil.getBackwardOffsetFor(document, text, minOffsetLimit, offset, grabWhiteSpaces, false);
    }

    public static final boolean updateVarTypeFromHids(Set<IHid> hids, String[] typeName) {
        return PSSQuickFixUtil.updateVarTypeFromHids(hids, typeName, true, false);
    }

    public static final boolean updateVarTypeFromHids(Set<IHid> hids, String[] typeName, boolean allowRange, boolean translateType) {
        return false;
    }

    public static final String getDefaultTypeName() {
        return "STD_LOGIC";
    }

    public static String getSegmentsString(RfNamedElement type, IProgressMonitor progressMonitor, String libraryName) {
        DVTStringBuilder qname = new DVTStringBuilder();
        for (RfNamedElement enclosingScope = type.getEnclosingScope(); enclosingScope != null && !(enclosingScope instanceof RfLibrary); enclosingScope = enclosingScope.getEnclosingScope()) {
            if (!(enclosingScope instanceof RfPackage)) continue;
            qname.prepend('.').prepend(enclosingScope.getName());
            if (!progressMonitor.isCanceled()) continue;
            return null;
        }
        qname.prepend('.');
        qname.prepend(libraryName);
        return qname.toString();
    }

    public static String getLibNameFromElement(RfNamedElement element) {
        LibraryPackageScope libPkg = element.getLibPkgScope();
        if (libPkg == null) {
            return null;
        }
        String libraryName = libPkg.getLibraryName();
        if (libraryName == null || libraryName.isEmpty()) {
            return null;
        }
        return libraryName;
    }

    public static String guessElementType(IRfNamedElement container, String elementName) {
        TypeOperatorVisitor visitor = new TypeOperatorVisitor(elementName);
        container.visitHidObject(null, (IHidVisitor)visitor);
        return visitor.getTypeName();
    }

    public static String guessVariableDirection(RfNamedElement container, String elementName) {
        List<IHidOperator> operators = container.getHidOperators(ASSIGN_EXPRESSIONS, false);
        if (operators == null) {
            return "IN";
        }
        String direction = null;
        for (IHidOperator operator : operators) {
            Set lhHids = operator.getLHHids(FLATTENING_OPTIONS);
            Set rhHids = operator.getRHHids(FLATTENING_OPTIONS);
            for (IHid lhHid : lhHids) {
                if (!lhHid.getName().equals(elementName)) continue;
                operator.getOperatorType();
                if (!"INOUT".equals(direction)) continue;
                return direction;
            }
            for (IHid rhHid : rhHids) {
                if (!rhHid.getName().equals(elementName)) continue;
                String string = direction = "OUT".equals(direction) ? "INOUT" : "IN";
                if (!"INOUT".equals(direction)) continue;
                return direction;
            }
        }
        if (direction == null) {
            return "IN";
        }
        return direction;
    }

    public static IRfDefElement computeDeclarationAnchor(RfNamedElement enclosingScope, IResource resource, int offset) {
        return null;
    }

    public static class MembersDeclarationOrder
    implements Comparator<RfNamedElement> {
        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            RfDefElement declaration1 = o1.getDeclaration();
            RfDefElement declaration2 = o2.getDeclaration();
            if (declaration1 == null || declaration2 == null) {
                return 0;
            }
            return declaration1.getStartOffset() - declaration2.getStartOffset();
        }
    }

    public static class VariableDeclarationOrder
    implements Comparator<RfNamedElement> {
        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            RfDefElement declaration1 = o1.getDeclaration();
            RfDefElement declaration2 = o2.getDeclaration();
            if (declaration1 == null || declaration2 == null) {
                return 0;
            }
            return declaration2.getStartOffset() - declaration1.getStartOffset();
        }
    }
}

