/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class PSSExpansionRule
implements IRule {
    private IToken fDefaultTokenString;

    public PSSExpansionRule(IToken tokenPreproc) {
        Assert.isNotNull((Object)tokenPreproc);
        this.fDefaultTokenString = tokenPreproc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IToken evaluate(ICharacterScanner scanner) {
        try {
            int c3;
            int c2;
            int c = scanner.read();
            if ((char)c == '\"') {
                c2 = scanner.read();
                c3 = scanner.read();
                if ((char)c2 != '\"' || (char)c3 != '\"') {
                    scanner.unread();
                    scanner.unread();
                    return Token.UNDEFINED;
                }
            } else if ((char)c == '}') {
                c2 = scanner.read();
                if ((char)c2 != '}') {
                    scanner.unread();
                    scanner.unread();
                    return Token.UNDEFINED;
                }
            } else {
                scanner.unread();
                return Token.UNDEFINED;
            }
            while ((c = scanner.read()) != -1) {
                if ((char)c == '\"') {
                    c2 = scanner.read();
                    c3 = scanner.read();
                    if ((char)c2 == '\"' && (char)c3 == '\"') return this.fDefaultTokenString;
                    scanner.unread();
                    scanner.unread();
                } else if ((char)c == '{') {
                    c2 = scanner.read();
                    if ((char)c2 == '{') return this.fDefaultTokenString;
                    scanner.unread();
                }
                if (c != -1) continue;
            }
            scanner.unread();
            return this.fDefaultTokenString;
        }
        catch (Exception exception) {
            return Token.UNDEFINED;
        }
    }
}

