/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.rules;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.editor.highlight.IHighlightListener;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightPosition;
import ro.amiq.pssdt.ui.editor.PSSStyle;
import ro.amiq.pssdt.ui.preferences.PrefConst;

public class PSSKeyWordRule
implements IRule,
IHighlightListener {
    private static final Comparator<Position> POSITION_COMPARATOR = new Comparator<Position>(){

        @Override
        public int compare(Position o1, Position o2) {
            return o1.getOffset() - o2.getOffset();
        }
    };
    private IToken fDefaultKeywordToken;
    private IToken fDefaultTemplateToken;
    private IToken fDefaultWordToken;
    private IToken fDefaultTypeToken;
    private IToken fDefaultMethodToken;
    private IToken fDefaultFieldToken;
    private IToken fDefaultPortToken;
    private IToken fDefaultOutPortToken;
    private IToken fDefaultConstantToken;
    private IToken fDefaultLabelToken;
    private IToken fDefaultArgumentToken;
    private IToken fDefaultActionHandleToken;
    private IToken fDefaultActionToken;
    private IToken fDefaultComponentToken;
    private IToken fDefaultPoolOfFlowToken;
    private IToken fDefaultShareToken;
    private IToken fDefaultLockToken;
    private IToken fDefaultVariableToken;
    private IToken fDefaultSymbolToken;
    private IToken fDefaultComponentInstanceToken;
    private IToken fDefaultEnumItemToken;
    private IToken fDefaultStaticConstToken;
    private IToken fDefaultPoolOfResourceToken;
    private Position[] fSHPositions;
    private IDocument fDocument;
    private PSSStyle fStyle;
    private HashSet<String> fWords = new HashSet();
    private HashSet<String> fTypes = new HashSet();
    private StringBuilder fBuffer = new StringBuilder();
    private static final Matcher fx_ID_xTemplatePattern = Pattern.compile("x_[a-zA-Z$][a-zA-Z0-9$_]*?_x").matcher("");

    public PSSKeyWordRule(String[] tokens, String[] types, PSSStyle style, int nofLines) {
        IToken keywordToken = style.getToken("highlight.keyword");
        Assert.isNotNull((Object)keywordToken);
        Assert.isNotNull((Object)tokens);
        this.fDefaultKeywordToken = keywordToken;
        this.fDefaultTypeToken = style.getToken("highlight.types");
        this.fDefaultTemplateToken = style.getToken("highlight.template_id");
        this.fDefaultWordToken = style.getToken("highlight.default");
        this.fDefaultMethodToken = style.getToken("highlight.semantic_method");
        this.fDefaultFieldToken = style.getToken("highlight.semantic_field");
        this.fDefaultPortToken = style.getToken("highlight.semantic_port");
        this.fDefaultOutPortToken = style.getToken("highlight.semantic_out_port");
        this.fDefaultActionHandleToken = style.getToken("highlight.semantic_action_handle");
        this.fDefaultComponentToken = style.getToken("highlight.semantic_component");
        this.fDefaultActionToken = style.getToken("highlight.semantic_action");
        this.fDefaultPoolOfFlowToken = style.getToken("highlight.semantic_pool_of_flow");
        this.fDefaultShareToken = style.getToken("highlight.semantic_share");
        this.fDefaultLockToken = style.getToken("highlight.semantic_lock");
        this.fDefaultVariableToken = style.getToken("highlight.semantic_variable");
        this.fDefaultSymbolToken = style.getToken("highlight.semantic_symbol");
        this.fDefaultComponentInstanceToken = style.getToken("highlight.semantic_instances");
        this.fDefaultEnumItemToken = style.getToken("highlight.semantic_enum_item");
        this.fDefaultStaticConstToken = style.getToken("highlight.semantic_static_const");
        this.fDefaultPoolOfResourceToken = style.getToken("highlight.semantic_pool_of_resource");
        this.fDefaultConstantToken = style.getToken("highlight.semantic_constant");
        this.fDefaultLabelToken = style.getToken("highlight.label");
        this.fDefaultArgumentToken = style.getToken("highlight.semantic_argument");
        this.fSHPositions = null;
        this.fDocument = null;
        this.fStyle = style;
        int i = 0;
        while (i < tokens.length) {
            this.fWords.add(tokens[i]);
            ++i;
        }
        i = 0;
        while (i < types.length) {
            this.fTypes.add(types[i]);
            ++i;
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        try {
            TestHelper.fLastTokenTime = System.currentTimeMillis();
            int x_ID_xIdentifierMatches = 0;
            boolean isXTemplateIdentifierEnabled = this.fStyle.isXTemplateIdentifierHighlightEnabled();
            int ch = scanner.read();
            if (ch == -1) {
                return Token.UNDEFINED;
            }
            this.fDocument = ((DVTBaseScanner)scanner).getDocument();
            if (Character.isJavaIdentifierStart(ch)) {
                SemanticHighlightPosition highlightPosition;
                Matcher matcher;
                this.fBuffer.delete(0, this.fBuffer.length());
                int p = 0;
                do {
                    this.fBuffer.append((char)ch);
                    if (isXTemplateIdentifierEnabled) {
                        if ((char)ch == '_' && (char)p == 'x') {
                            x_ID_xIdentifierMatches += 2;
                        }
                        if ((char)ch == 'x' && (char)p == '_') {
                            x_ID_xIdentifierMatches += 2;
                        }
                    }
                    p = ch;
                } while ((ch = scanner.read()) != -1 && Character.isJavaIdentifierPart(ch));
                scanner.unread();
                String text = this.fBuffer.toString();
                if (x_ID_xIdentifierMatches >= 4 && (matcher = fx_ID_xTemplatePattern.reset(text)).find()) {
                    if (matcher.start() == 0) {
                        ((DVTBaseScanner)scanner).unreadLength(text.length() - matcher.end());
                        return this.fDefaultTemplateToken;
                    }
                    ((DVTBaseScanner)scanner).unreadLength(text.length() - matcher.start());
                    return this.fDefaultWordToken;
                }
                if (this.fWords.contains(text)) {
                    return this.fDefaultKeywordToken;
                }
                int offset = ((DVTBaseScanner)scanner).getOffset() - 1;
                int openOffset = offset - text.length() + 1;
                boolean isSemanticHighlightEnabled = this.fStyle.isSemanticHighlightEnabled();
                if (isSemanticHighlightEnabled && (highlightPosition = (SemanticHighlightPosition)this.getPosition(openOffset)) != null) {
                    HighlightKind highlighKind = highlightPosition.getHighlightKind();
                    if (highlighKind == HighlightKind.METHOD) {
                        return this.fDefaultMethodToken;
                    }
                    if (highlighKind == HighlightKind.PORT) {
                        return this.fDefaultPortToken;
                    }
                    if (highlighKind == HighlightKind.OUT_PORT) {
                        return this.fDefaultOutPortToken;
                    }
                    if (highlighKind == HighlightKind.ACTION_HANDLE) {
                        return this.fDefaultActionHandleToken;
                    }
                    if (highlighKind == HighlightKind.ACTION) {
                        return this.fDefaultActionToken;
                    }
                    if (highlighKind == HighlightKind.COMPONENT) {
                        return this.fDefaultComponentToken;
                    }
                    if (highlighKind == HighlightKind.TYPE) {
                        return this.fDefaultTypeToken;
                    }
                    if (highlighKind == HighlightKind.FIELD) {
                        return this.fDefaultFieldToken;
                    }
                    if (highlighKind == HighlightKind.POOL_OF_FLOW) {
                        return this.fDefaultPoolOfFlowToken;
                    }
                    if (highlighKind == HighlightKind.POOL_OF_RESOURCE) {
                        return this.fDefaultPoolOfResourceToken;
                    }
                    if (highlighKind == HighlightKind.SHARE) {
                        return this.fDefaultShareToken;
                    }
                    if (highlighKind == HighlightKind.LOCK) {
                        return this.fDefaultLockToken;
                    }
                    if (highlighKind == HighlightKind.CONSTANT) {
                        return this.fDefaultConstantToken;
                    }
                    if (highlighKind == HighlightKind.LABEL) {
                        return this.fDefaultLabelToken;
                    }
                    if (highlighKind == HighlightKind.ARGUMENT) {
                        return this.fDefaultArgumentToken;
                    }
                    if (highlighKind == HighlightKind.KEYWORD) {
                        return this.fDefaultKeywordToken;
                    }
                    if (highlighKind == HighlightKind.VARIABLE) {
                        return this.fDefaultVariableToken;
                    }
                    if (highlighKind == HighlightKind.SYMBOL) {
                        return this.fDefaultSymbolToken;
                    }
                    if (highlighKind == HighlightKind.PSS_COMPONENT_INSTANCE) {
                        return this.fDefaultComponentInstanceToken;
                    }
                    if (highlighKind == HighlightKind.DEFAULT) {
                        return this.fDefaultWordToken;
                    }
                    if (highlighKind == HighlightKind.PSS_ENUM_ITEMS) {
                        return this.fDefaultEnumItemToken;
                    }
                    if (highlighKind == HighlightKind.STATIC_CONST) {
                        return this.fDefaultStaticConstToken;
                    }
                    return Token.UNDEFINED;
                }
                if (this.fTypes.contains(text)) {
                    return this.fDefaultTypeToken;
                }
                return this.fDefaultWordToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
        catch (Exception exception) {
            return Token.UNDEFINED;
        }
    }

    public void updateSHPositions(IDocument document, IRfFileDef file) {
        try {
            if (this.fDocument == null || !this.fDocument.equals(document)) {
                return;
            }
            if (!this.fDocument.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
                return;
            }
            this.fSHPositions = this.fDocument.getPositions("SEMANTIC_HIGHLIGHT");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateKeywords() {
        String[] keywords = PrefConst.getPSSKeywords();
        this.fWords.clear();
        int i = 0;
        while (i < keywords.length) {
            this.fWords.add(keywords[i]);
            ++i;
        }
    }

    private Position getPosition(int offset) {
        if (this.fSHPositions == null) {
            return null;
        }
        int index = Arrays.binarySearch(this.fSHPositions, new DVTPosition(offset), POSITION_COMPARATOR);
        if (index >= 0) {
            return this.fSHPositions[index];
        }
        return null;
    }
}

