/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.editor.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.pssdt.ui.editor.PSSCodeScanner;

public class PSSNumericRule
implements IRule {
    private IToken fDefaultToken;
    private int fLength;

    public PSSNumericRule(IToken token) {
        Assert.isNotNull((Object)token);
        this.fDefaultToken = token;
    }

    /*
     * Enabled aggressive block sorting
     */
    public IToken evaluate(ICharacterScanner scanner) {
        char c = (char)scanner.read();
        int length = 1;
        boolean hasTick = false;
        while (Character.isDigit(c)) {
            ++length;
            c = (char)scanner.read();
        }
        if (c == '\'') {
            hasTick = true;
            ++length;
            c = (char)scanner.read();
            if (c == '0' || c == '1' || c == 'z' || c == 'Z' || c == 'x' || c == 'X') {
                ++length;
                c = (char)scanner.read();
                if (!Character.isLetterOrDigit(c)) {
                    scanner.unread();
                    return this.fDefaultToken;
                }
                ((PSSCodeScanner)scanner).unreadLength(length);
                return Token.UNDEFINED;
            }
            if (c == 's' || c == 'S') {
                ++length;
                c = (char)scanner.read();
                if (c != 'd' && c != 'D' && c != 'h' && c != 'H' && c != 'o' && c != 'O' && c != 'b' && c != 'B') {
                    ((PSSCodeScanner)scanner).unreadLength(length);
                    return Token.UNDEFINED;
                }
                do {
                    ++length;
                } while (Character.isWhitespace(c = (char)scanner.read()));
            } else if (c == 'd' || c == 'D' || c == 'h' || c == 'H' || c == 'o' || c == 'O' || c == 'b' || c == 'B') {
                do {
                    ++length;
                } while (Character.isWhitespace(c = (char)scanner.read()));
            }
        }
        while (Character.isDigit(c) || length > 1 && (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c == '?' || c == '_' || c == 'z' || c == 'Z' || c == 'x' || c == 'X')) {
            ++length;
            c = (char)scanner.read();
        }
        if ((length <= 1 || hasTick) && length <= 2) {
            ((DVTBaseScanner)scanner).unreadLength(length);
            return Token.UNDEFINED;
        }
        scanner.unread();
        return this.fDefaultToken;
    }
}

