/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.namechecker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.PSSProblemCategories;
import ro.amiq.dvt.model.problems.PSSProblemKinds;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.namechecker.Collision;
import ro.amiq.dvt.ui.namechecker.Convention;
import ro.amiq.dvt.ui.namechecker.ConventionStoreUtil;
import ro.amiq.dvt.ui.namechecker.Identifier;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.MethodKind;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfCovergroup;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfEnumItem;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.ui.preferences.PrefConst;

public enum NameCheckerWarningsManager {
    INSTANCE;

    private static final String POSITIVE = "positive";
    private static final String ANY = "ANY";
    private List<Collision> fConventionNames = new ArrayList<Collision>();
    private List<Convention> fConventions;
    private List<Collision> fReservedNames = new ArrayList<Collision>();
    private Set<String> fKeywords;

    public static NameCheckerWarningsManager getInstance() {
        return INSTANCE;
    }

    private NameCheckerWarningsManager() {
        DVTProblemsUiUpdaterRegistry.register((DVTProblemsUiUpdater)new DVTProblemsUiUpdater(PSSProblemCategories.PSS_NAME_CHECKING));
    }

    private String extractMessage(Collision c) {
        int kind = c.getKind();
        String result = DVTStringUtil.appendString((Object[])new Object[]{"The '", c.getName(), "' ", c.getElement().toLowerCase().replace('_', ' '), " name"});
        if (kind == 0) {
            return DVTStringUtil.appendString((Object[])new Object[]{"PSS1.0a KEYWORD: ", result, " is reserved by the standard as keyword."});
        }
        return DVTStringUtil.appendString((Object[])new Object[]{c.getNamingConvention().toUpperCase(), ": ", result, " does not satisfy the naming convention."});
    }

    private void recursiveParseChildren(Set<RfDefElement> visited, RfDefElement element, RfFileDef file, List<Convention> conventions) {
        Collection<RfDefElement> children;
        String type;
        if (element == null) {
            return;
        }
        if (visited.contains(element)) {
            return;
        }
        visited.add(element);
        RfNamedElement namedElement = element.getNamedElement();
        if (namedElement != null && !namedElement.isAnonymous() && (type = this.getType(namedElement)) != null) {
            String name = element.getName();
            int nofConventions = conventions.size();
            int j = 0;
            while (j < nofConventions) {
                Matcher m;
                Convention rule = conventions.get(j);
                if (rule.getLanguage().equals("PSS") && !rule.isOverriden() && rule.getEnabled() && (rule.getKind().equals(type) || rule.getKind().equals(ANY)) && (!(m = rule.getPattern().matcher(name)).matches() && rule.getMatch().equalsIgnoreCase(POSITIVE) || m.matches() && !rule.getMatch().equalsIgnoreCase(POSITIVE))) {
                    Collision newID = new Collision(1, name, new Identifier(name, type, file.getName(), element.getStartLine(), element.getStartOffset()), rule);
                    this.fConventionNames.add(newID);
                }
                ++j;
            }
        }
        if ((children = element.getChildren()) == null || children.isEmpty()) {
            return;
        }
        for (RfDefElement child : children) {
            this.recursiveParseChildren(visited, child, file, conventions);
        }
    }

    public void build(int buildKind, RfFileDef file, IProject project) {
        DVTProblem problem;
        if (file == null || project == null) {
            return;
        }
        if (BuildConfigManager.isNamingConventionChecksDisabled((IProject)project)) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F707373")) {
            return;
        }
        if (this.fKeywords == null) {
            this.fKeywords = new HashSet<String>(Arrays.asList(PrefConst.getNamecheckKeywords()));
        }
        if (this.fConventions == null) {
            this.fConventions = new ArrayList<Convention>();
            try {
                ConventionStoreUtil.load(this.fConventions, (IProject)project);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        this.recursiveParseChildren(new HashSet<RfDefElement>(), file, file, this.fConventions);
        ParserPath parserPath = file.getParserPath();
        DVTProblemManager.getInstance().removeProblemsWithCategoryAndPath(project, PSSProblemCategories.PSS_NAME_CHECKING, parserPath.path);
        for (Collision c : this.fConventionNames) {
            problem = new DVTProblem(project, PSSProblemKinds.PSS_NAMING_CONVENTION, parserPath.path, buildKind == 1, c.getLineNumber(), new String[]{this.extractMessage(c)});
            problem.setAttribute("charStart", (Object)c.getStartOffset());
            problem.setAttribute("charEnd", (Object)c.getEndOffset());
            DVTProblemManager.getInstance().reportProblem(problem);
        }
        for (Collision c : this.fReservedNames) {
            problem = new DVTProblem(project, PSSProblemKinds.PSS_RESERVED_ID, parserPath.path, false, c.getLineNumber(), new String[]{this.extractMessage(c)});
            problem.setAttribute("charStart", (Object)c.getStartOffset());
            problem.setAttribute("charEnd", (Object)c.getEndOffset());
            DVTProblemManager.getInstance().reportProblem(problem);
        }
        IResource resource = file.getFileAdapter();
        if (resource instanceof IFile && buildKind == 0) {
            DVTProblemsUiUpdaterRegistry.get((String)PSSProblemCategories.PSS_NAME_CHECKING.getId()).update((IFile)resource, false);
        }
        this.fConventionNames.clear();
        this.fReservedNames.clear();
    }

    private String getType(IRfNamedElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof RfMethod) {
            MethodKind methodKind = ((RfMethod)element).getMethodKind();
            if (methodKind == MethodKind.SYMBOL) {
                return "SYMBOL";
            }
            return "FUNCTION";
        }
        if (element instanceof RfStruct) {
            StructKind structKind = ((RfStruct)element).getStructKind();
            if (structKind == StructKind.RESOURCE) {
                return "RESOURCE";
            }
            if (structKind == StructKind.BUFFER) {
                return "BUFFER";
            }
            if (structKind == StructKind.STATE) {
                return "STATE";
            }
            if (structKind == StructKind.STREAM) {
                return "STREAM";
            }
            if (structKind == StructKind.ACTION || structKind == StructKind.ACTION_ABSTRACT) {
                return "ACTION";
            }
            if (structKind == StructKind.COMPONENT) {
                return "COMPONENT";
            }
            if (structKind == StructKind.STRUCT) {
                return "STRUCT";
            }
        }
        if (element instanceof RfField) {
            RfField field = (RfField)element;
            FieldModifier fieldModifier = field.getFieldModifier();
            if (fieldModifier == FieldModifier.CONST || fieldModifier == FieldModifier.STATIC_CONST) {
                return "CONSTANT";
            }
            if (fieldModifier == FieldModifier.ACTION) {
                return "ACTION";
            }
            if (fieldModifier == FieldModifier.INPUT) {
                return "ACTION_INPUT";
            }
            if (fieldModifier == FieldModifier.OUTPUT) {
                return "ACTION_OUTPUT";
            }
            if (fieldModifier == FieldModifier.SYMBOL_PARAM || fieldModifier == FieldModifier.METHOD_PARAM) {
                return "FUNCTION_ARGUMENT";
            }
            if (fieldModifier == FieldModifier.COVERCROSS) {
                return "COVERCROSS";
            }
            if (fieldModifier == FieldModifier.COVERPOINT) {
                return "COVERPOINT";
            }
            if (fieldModifier == FieldModifier.LOCK) {
                return "LOCK";
            }
            if (fieldModifier == FieldModifier.SHARE) {
                return "SHARE";
            }
            if (fieldModifier == FieldModifier.INDEX || fieldModifier == FieldModifier.ITERATOR) {
                return "VARIABLE";
            }
            if (fieldModifier == FieldModifier.POOL) {
                StructKind structKind;
                RfNamedElement associatedBaseType = field.getAssociatedBaseType();
                while (associatedBaseType instanceof RfTypeAlias) {
                    associatedBaseType = ((RfTypeAlias)associatedBaseType).getAssociatedBaseType();
                }
                if (associatedBaseType instanceof RfStruct && (structKind = ((RfStruct)associatedBaseType).getStructKind()) == StructKind.RESOURCE) {
                    return "POOL_OF_RESOURCE";
                }
                return "POOL_OF_FLOW";
            }
            return "FIELD";
        }
        if (element instanceof RfEnumItem) {
            return "ENUM_ITEM";
        }
        if (element instanceof RfPackage) {
            return "PACKAGE";
        }
        if (element instanceof RfCovergroup) {
            return "COVERGROUP";
        }
        if (element instanceof RfTypeAlias) {
            return "TYPEDEF";
        }
        if (element instanceof RfBlock && ((RfBlock)element).isConstraint()) {
            return "CONSTRAINT";
        }
        if (element instanceof RfEnumType) {
            return "ENUM_TYPE";
        }
        return null;
    }

    public void clean() {
        this.fKeywords = null;
        this.fConventions = null;
    }
}

