/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.persistenttask;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.persistenttask.DVTPersistentTaskManager;
import ro.amiq.pssdt.model.IPSSReparseListener;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.ui.persistenttask.TaskInfoWrapper;

public class PersistentTaskManager
extends DVTPersistentTaskManager
implements IPSSReparseListener {
    public static final String PERSISTENT_TASK_MARKER_ID = "ro.amiq.pssdt.PersistentTaskMarker";
    private static final Object fSyncInstance = new Object();
    private static volatile PersistentTaskManager fInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistentTaskManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new PersistentTaskManager();
            }
        }
        return fInstance;
    }

    public void startup() {
        PSSModelManager.getInstance().addReparseListener(this);
    }

    public void shutdown() {
        PSSModelManager.getInstance().removeReparseListener(this);
    }

    public void reparsed(final int buildKind, int type, final IResource resource, List errors, List warnings, final List tasks) {
        IProject project = resource.getProject();
        if (project == null) {
            return;
        }
        if (!resource.isAccessible() || !(resource instanceof IFile)) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F707373")) {
            return;
        }
        this.runAsync(new Runnable(){

            @Override
            public void run() {
                PersistentTaskManager.this.updateMarkers(buildKind, resource, tasks);
            }
        });
    }

    public void updateMarkers(int buildKind, IResource resource, List<TaskInfoWrapper> tasks) {
        block13: {
            try {
                if (!resource.isAccessible() || !(resource instanceof IFile)) {
                    return;
                }
                if (buildKind == 1) {
                    try {
                        resource.deleteMarkers(PERSISTENT_TASK_MARKER_ID, false, 0);
                        if (tasks != null) {
                            for (TaskInfoWrapper taskInfo : tasks) {
                                taskInfo.makeMarker((IFile)resource);
                            }
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    break block13;
                }
                if (buildKind == 2) {
                    resource.deleteMarkers(PERSISTENT_TASK_MARKER_ID, false, 0);
                    break block13;
                }
                try {
                    resource.deleteMarkers(PERSISTENT_TASK_MARKER_ID, false, 0);
                    if (tasks != null) {
                        for (TaskInfoWrapper taskInfoWrapper : tasks) {
                            taskInfoWrapper.makeMarker((IFile)resource);
                        }
                    }
                }
                catch (CoreException ex) {
                    DVTLogger.INSTANCE.logError((Throwable)ex);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }
}

