/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.editor.spelling.SpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.TaskTagDictionary;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellDictionary;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.ui.preferences.PrefConst;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = PSSPlugin.getDefault().getPreferenceStore();
        this.initializeMarkOccurences(store);
        this.initializeSyntaxPreferences(store);
        this.initializeOutlinePreferences(store);
        this.initializeContentAssistPreferences(store);
        this.initializeTypingPreferences(store);
        this.initializeAutoindentPreferences(store);
        this.initializeLanguageElements();
        this.initializeEditorPreferences(store);
    }

    private void initializeMarkOccurences(IPreferenceStore store) {
        store.setDefault("markOccurrences", true);
    }

    void initializeSyntaxPreferences(IPreferenceStore store) {
        store.setDefault("highlight.semantic.value", true);
        store.setDefault("highlight.x_template_id.value", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.default.color", (RGB)PrefConst.DEFAULT_COLOR);
        store.setDefault("highlight.default.bold", false);
        store.setDefault("highlight.default.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment.color", (RGB)PrefConst.COMMENT_COLOR);
        store.setDefault("highlight.comment.bold", false);
        store.setDefault("highlight.comment.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_task.color", (RGB)PrefConst.COMMENT_TASK_COLOR);
        store.setDefault("highlight.comment_task.bold", true);
        store.setDefault("highlight.comment_task.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_pragma.color", (RGB)PrefConst.COMMENT_PRAGMA_COLOR);
        store.setDefault("highlight.comment_pragma.bold", true);
        store.setDefault("highlight.comment_pragma.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.javadoc_tags.color", (RGB)PrefConst.JAVADOC_TAGS_COLOR);
        store.setDefault("highlight.javadoc_tags.bold", true);
        store.setDefault("highlight.javadoc_tags.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.keyword.color", (RGB)PrefConst.KEYWORD_COLOR);
        store.setDefault("highlight.keyword.bold", true);
        store.setDefault("highlight.keyword.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.template_id.color", (RGB)PrefConst.PREFIX_COLOR);
        store.setDefault("highlight.template_id.bold", false);
        store.setDefault("highlight.template_id.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.types.color", (RGB)PrefConst.TYPES_COLOR);
        store.setDefault("highlight.types.bold", true);
        store.setDefault("highlight.types.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.number.color", (RGB)PrefConst.NUMBER_COLOR);
        store.setDefault("highlight.number.bold", false);
        store.setDefault("highlight.number.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.string.color", (RGB)PrefConst.STRING_COLOR);
        store.setDefault("highlight.string.bold", false);
        store.setDefault("highlight.string.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.escaped_id.color", (RGB)PrefConst.ESCAPED_ID_COLOR);
        store.setDefault("highlight.escaped_id.bold", false);
        store.setDefault("highlight.escaped_id.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_hyperlink.color", (RGB)PrefConst.COMMENT_HYPERLINK_COLOR);
        store.setDefault("highlight.comment_hyperlink.bold", false);
        store.setDefault("highlight.comment_hyperlink.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_method.color", (RGB)PrefConst.SEMANTIC_METHOD_COLOR);
        store.setDefault("highlight.semantic_method.bold", false);
        store.setDefault("highlight.semantic_method.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_field.color", (RGB)PrefConst.SEMANTIC_FIELD_COLOR);
        store.setDefault("highlight.semantic_field.bold", false);
        store.setDefault("highlight.semantic_field.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_instances.color", (RGB)PrefConst.SEMANTIC_INSTANCE_COLOR);
        store.setDefault("highlight.semantic_instances.bold", false);
        store.setDefault("highlight.semantic_instances.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_port.color", (RGB)PrefConst.SEMANTIC_PORT_COLOR);
        store.setDefault("highlight.semantic_port.bold", false);
        store.setDefault("highlight.semantic_port.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_out_port.color", (RGB)PrefConst.SEMANTIC_OUT_PORT_COLOR);
        store.setDefault("highlight.semantic_out_port.bold", false);
        store.setDefault("highlight.semantic_out_port.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_action_handle.color", (RGB)PrefConst.SEMANTIC_ACTION_HANDLE_COLOR);
        store.setDefault("highlight.semantic_action_handle.bold", false);
        store.setDefault("highlight.semantic_action_handle.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_action.color", (RGB)PrefConst.SEMANTIC_ACTION_COLOR);
        store.setDefault("highlight.semantic_action.bold", true);
        store.setDefault("highlight.semantic_action.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_pool_of_flow.color", (RGB)PrefConst.SEMANTIC_POOL_OF_FLOW_COLOR);
        store.setDefault("highlight.semantic_pool_of_flow.bold", true);
        store.setDefault("highlight.semantic_pool_of_flow.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_pool_of_resource.color", (RGB)PrefConst.SEMANTIC_POOL_OF_RESOURCE_COLOR);
        store.setDefault("highlight.semantic_pool_of_resource.bold", true);
        store.setDefault("highlight.semantic_pool_of_resource.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_share.color", (RGB)PrefConst.SEMANTIC_SHARE_COLOR);
        store.setDefault("highlight.semantic_share.bold", false);
        store.setDefault("highlight.semantic_share.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_lock.color", (RGB)PrefConst.SEMANTIC_LOCK_COLOR);
        store.setDefault("highlight.semantic_lock.bold", false);
        store.setDefault("highlight.semantic_lock.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_variable.color", (RGB)PrefConst.SEMANTIC_VARIABLE_COLOR);
        store.setDefault("highlight.semantic_variable.bold", false);
        store.setDefault("highlight.semantic_variable.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_symbol.color", (RGB)PrefConst.SEMANTIC_SYMBOL_COLOR);
        store.setDefault("highlight.semantic_symbol.bold", false);
        store.setDefault("highlight.semantic_symbol.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_component.color", (RGB)PrefConst.SEMANTIC_COMPONENT_COLOR);
        store.setDefault("highlight.semantic_component.bold", true);
        store.setDefault("highlight.semantic_component.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_enum_item.color", (RGB)PrefConst.SEMANTIC_ENUM_ITEM_COLOR);
        store.setDefault("highlight.semantic_enum_item.bold", true);
        store.setDefault("highlight.semantic_enum_item.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_static_const.color", (RGB)PrefConst.SEMANTIC_STATIC_CONST_COLOR);
        store.setDefault("highlight.semantic_static_const.bold", true);
        store.setDefault("highlight.semantic_static_const.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_constant.color", (RGB)PrefConst.SEMANTIC_CONSTANT_COLOR);
        store.setDefault("highlight.semantic_constant.bold", true);
        store.setDefault("highlight.semantic_constant.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_argument.color", (RGB)PrefConst.SEMANTIC_ARGUMENT_COLOR);
        store.setDefault("highlight.semantic_argument.bold", false);
        store.setDefault("highlight.semantic_argument.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.label.color", (RGB)PrefConst.LABEL_COLOR);
        store.setDefault("highlight.label.bold", true);
        store.setDefault("highlight.label.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.preproc.color", (RGB)PrefConst.PREPROC_COLOR);
        store.setDefault("highlight.preproc.bold", true);
        store.setDefault("highlight.preproc.italic", false);
    }

    void initializeLanguageElements() {
        IPreferenceStore store = PSSPlugin.getDefault().getPreferenceStore();
        store.setDefault("pss.language.keywords", "abstract;action;activity;as;assert;before;bind;bins;body;buffer;class;compile;component;const;constraint;covergroup;coverpoint;cross;declaration;default;disable;dist;do;dynamic;else;enum;exec;export;extend;false;file;forall;foreach;function;has;header;if;iff;ignore_bins;illegal_bins;import;in;init;init_up;init_down;inout;input;instance;lock;match;memory;null;option;output;override;package;parallel;pool;post_solve;post_activity;pre_solve;private;protected;public;rand;randomize;ref;repeat;replicate;resource;return;run_end;run_start;schedule;select;sequence;share;soft;solve;state;static;stream;struct;super;symbol;target;true;type;type_option;typedef;unique;while;with;break;continue;list;array;map;set;pure;join_branch;join_select;join_first;join_none;");
        store.setDefault("pss.language.types", "bit;bool;chandle;int;float32;float64;string;void;");
    }

    void initializeOutlinePreferences(IPreferenceStore store) {
        store.setDefault("outline.prefs_changed", false);
        store.setDefault("outline.show_packages", true);
        store.setDefault("outline.show_components", true);
        store.setDefault("outline.show_structs", true);
        store.setDefault("outline.show_actions", true);
        store.setDefault("outline.show_covergroups", true);
        store.setDefault("outline.show_types", true);
        store.setDefault("outline.show_activities", true);
        store.setDefault("outline.show_functions", true);
        store.setDefault("outline.show_exec_blocks", true);
        store.setDefault("outline.show_constraints", true);
        store.setDefault("outline.show_blocks", true);
        store.setDefault("outline.show_fields", true);
        DVTPredefinedGUIFilters.putOutlinePredefinedGUIFilter((LanguageKind)LanguageKind.PSS, (IPreferenceStore)store);
    }

    void initializeContentAssistPreferences(IPreferenceStore store) {
        store.setDefault("ca.ignore_case", true);
        store.setDefault("ca.camel_case", true);
        store.setDefault("ca.prefix_match", true);
        store.setDefault("ca.chars_trigger", ".,= ,::");
        store.setDefault("ca.auto_insert_single", false);
        store.setDefault("contentAssist.autoRange.preservePortOrderAndComments", true);
        store.setDefault("contentAssist.module_autoinstance_prefix", "u_");
        store.setDefault("contentAssist.generateSignals", true);
    }

    void initializeTypingPreferences(IPreferenceStore store) {
        store.setDefault("typing.quote_case", true);
        store.setDefault("typing.paran_case", true);
        store.setDefault("typing.brack_case", true);
        store.setDefault("typing.curly_case", true);
        store.setDefault("typing.comments_case", true);
        store.setDefault("typing.enclose.brack_case", true);
        store.setDefault("typing.enclose.curly_case", true);
        store.setDefault("typing.enclose.paran_case", true);
        store.setDefault("typing.enclose.quote_case", true);
        store.setDefault("typing.transform_dot_dot_to_assign", false);
        store.setDefault("typing.transform_comma_comma_to_assign", false);
        store.setDefault("typing.transform_semicolon_to_assign", false);
        store.setDefault("typing.transform_whitespace", false);
    }

    void initializeAutoindentPreferences(IPreferenceStore store) {
        store.setDefault("autoindent.disabled", false);
    }

    void initializeEditorPreferences(IPreferenceStore store) {
        SpellCheckEngine.getInstance().registerDictionary((ISpellDictionary)new TaskTagDictionary(store));
        store.setDefault("editor.disable_tool_tips", false);
        store.setDefault("disable.compareviewer", 100000);
        PreferenceConverter.setDefault((IPreferenceStore)EditorsUI.getPreferenceStore(), (String)"matchingBracketsPSSColor", (RGB)PrefConst.MATCHING_BRACKETS_HIGHLIGHT_COLOR_VAL);
        EditorsUI.getPreferenceStore().setDefault("matchingBracketsPSSEnable", true);
        store.setDefault("editor.codeFolding", true);
        store.setDefault("editor.manualCodeFolding", true);
        store.setDefault("editor.numberOfLines", 10000);
        store.setDefault("inactiveCodeHighlightEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"inactiveCodeHighlightColor", (RGB)PrefConst.INACTIVE_CODE_HIGHLIGHT_COLOR_VAL);
        store.setDefault("format.capitalization.keywords", 1);
        store.setDefault("format.capitalization.data_types", 1);
        store.setDefault("format.capitalization.attributes", 1);
        store.setDefault("format.whitespace.trim_end_of_line", true);
        store.setDefault("format.whitespace.trim_whitespace_line", true);
        store.setDefault("format.whitespace.compact", false);
        store.setDefault("format.whitespace.compact_consecutive_empty_lines", false);
        store.setDefault("format.whitespace.maximum_nof_consecutive_empty_lines", 1);
        store.setDefault("format.whitespace.add_after", "");
        store.setDefault("format.whitespace.add_before", "");
        store.setDefault("format.indent.begin", 1);
        store.setDefault("format.indent.else", 1);
        store.setDefault("format.indent.params", 1);
        store.setDefault("format.indent.preproc", 1);
        store.setDefault("format.indent.preserve_sl_comment_column_zero", true);
        store.setDefault("format.indent.multiline_comments", true);
        store.setDefault("format.indent.no_indent_keywords", "");
        store.setDefault("format.indent.ignore_lines", "");
        store.setDefault("format.line_wrap", false);
        store.setDefault("format.line_wrap.threshold", 80);
        store.setDefault("format.line_wrap.sl_comments", false);
        store.setDefault("format.line_wrap.ml_comments", false);
        store.setDefault("format.vertical_align", false);
        store.setDefault("format.vertical_align.sl_comments", false);
        store.setDefault("format.vertical_align.paren", false);
        store.setDefault("format.vertical_align.curly", false);
        store.setDefault("format.vertical_align.vregex", "");
        store.setDefault("format.indent.no_indent_keywords", "");
        store.setDefault("format.pre_external", false);
        store.setDefault("format.pre_external.command", "pre_format_code %f");
        store.setDefault("format.post_external", false);
        store.setDefault("format.post_external.command", "post_format_code %f");
        store.setDefault("format.external", false);
        store.setDefault("format.external.command", "format_code %f");
        store.setDefault("format.preview.show_invisible_characters", false);
        store.setDefault("format.preview.line_wrap_threshold", 50);
        store.setDefault("format.format_on_paste", "Disabled");
    }
}

