/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.refactor.rename;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.ui.refactor.PSSTextFileChange;
import ro.amiq.pssdt.ui.refactor.rename.PSSRenameRefactorInfo;
import ro.amiq.pssdt.ui.search.ReferenceSearchPageInput;
import ro.amiq.pssdt.ui.search.SearchQueryProvider;
import ro.amiq.pssdt.ui.search.text.FileMatch;
import ro.amiq.pssdt.ui.search.text.FileSearchResult;

public class PSSRenameDelegate
extends DVTRenameDelegate {
    public PSSRenameDelegate(DVTRenameRefactorInfo info, boolean useScopeInfo) {
        super(info, useScopeInfo);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        Object[] allElements;
        RefactoringStatus result = new RefactoringStatus();
        IProject project = this.getRefactorInfo().getProject();
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        String[] fileExtensions = null;
        try {
            fileExtensions = BaseReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
        }
        catch (CoreException coreException) {
            result.addError("Could not search for references to " + this.getRefactorInfo().getOldSignature());
            return result;
        }
        FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
        ReferenceSearchPageInput input = new ReferenceSearchPageInput(((PSSRenameRefactorInfo)this.getRefactorInfo()).getNamedElement(), true, false, true, searchScope);
        ISearchQuery query = new SearchQueryProvider(1, 4, true, true).createQuery((TextSearchQueryProvider.TextSearchInput)input);
        if (query == null) {
            result.addError("Could not search for references to " + this.getRefactorInfo().getOldSignature());
            return result;
        }
        query.run(pm);
        HashMap<IResource, Match[]> matches = new HashMap<IResource, Match[]>();
        FileSearchResult searchResult = (FileSearchResult)query.getSearchResult();
        Object[] objectArray = allElements = searchResult.getElements();
        int n = allElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                matches.put((IResource)element, searchResult.getMatches(element));
            }
            ++n2;
        }
        this.getRefactorInfo().setMatches(matches);
        return result;
    }

    protected DVTTextFileChange getTextFileChange(IFile file) {
        return new PSSTextFileChange(file.getName(), file);
    }

    public void createChangesFor(IFile file, Match[] matches, CompositeChange rootChange, DVTTextFileChange textFileChange, boolean inComments) {
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            if (match instanceof FileMatch) {
                FileMatch fileMatch = (FileMatch)match;
                String matchString = RfReferencesUtils.getFileMatchString((BaseFileMatch)fileMatch);
                ReplaceEdit replaceEdit = new ReplaceEdit(fileMatch.getOffset(), fileMatch.getLength(), this.getRefactorInfo().getNewName());
                textFileChange.addEdit((TextEdit)replaceEdit);
                this.addToChangeGroup(textFileChange, fileMatch, matchString, inComments, (TextEdit)replaceEdit, SEMANTIC_CHANGES);
            }
            ++n2;
        }
    }

    public IStatus checkNewNameInternal(DVTRenameRefactorInfo refactorInfo) {
        return Status.OK_STATUS;
    }
}

