/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.search;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.NewSearchUI;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentCharSequence;
import ro.amiq.dvt.ui.search.SearchMessages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.ui.search.RfSearchQueryElement;

public class ReferenceSearchVisitor {
    public static final int BUFFER_SIZE = 524288;
    public static final Pattern WHILDCARD = Pattern.compile("(?<!\\\\)[*?]");
    private final TextSearchRequestor fCollector;
    private Matcher fMatcher;
    private Map<IFile, IDocument> fDocumentsInEditors;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private RfProject fRfProject;
    private final MultiStatus fStatus;
    private final ReusableMatchAccess fMatchAccess;
    private boolean fRemoveComments;
    private IRfNamedElement fRfElement;
    private boolean fIncludeDeclarations;
    private int fPossibleMatchesCount;
    private String[] fSearchStructs;
    private boolean fRegexp;
    private String fSearchString;
    private String fSearchType;
    private boolean fIsWildcardSearch;

    public ReferenceSearchVisitor(IRfNamedElement fRfElement2, TextSearchRequestor collector, Pattern searchPattern, String searchType, boolean removeComments, boolean includeDeclarations, boolean regexp, String searchString) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fRegexp = regexp;
        this.fSearchString = searchString;
        this.fSearchType = searchType;
        String prepend = "";
        if (searchPattern.pattern().length() != 0) {
            Pattern newPattern = Pattern.compile(String.valueOf(prepend) + searchPattern.pattern(), searchPattern.flags() | 2);
            this.fMatcher = newPattern.matcher("");
        } else {
            this.fMatcher = null;
        }
        this.fRemoveComments = removeComments;
        this.fMatchAccess = new ReusableMatchAccess();
        this.fRfElement = fRfElement2;
        this.fIncludeDeclarations = includeDeclarations;
        this.fIsWildcardSearch = WHILDCARD.matcher(searchString).find();
    }

    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        this.fCurrentFile = null;
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedFiles;

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IFile file = ReferenceSearchVisitor.this.fCurrentFile;
                    if (file != null) {
                        String fileName = file.getName();
                        Object[] args = new Object[]{fileName, ReferenceSearchVisitor.this.fNumberOfScannedFiles, ReferenceSearchVisitor.this.fNumberOfFilesToScan};
                        ReferenceSearchVisitor.this.fProgressMonitor.subTask(MessageFormat.format(SearchMessages.TextSearchVisitor_scanning, args));
                        int steps = ReferenceSearchVisitor.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                        ReferenceSearchVisitor.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedFiles += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.fSearchStructs = null;
        String[] tempMatchPatterns = DVTStringUtil.split((Pattern)DVTStringUtil.BACKSLASH_DOT, (String)this.fMatcher.pattern().pattern());
        if (tempMatchPatterns.length == 1) {
            if ((tempMatchPatterns = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)tempMatchPatterns[0])).length == 2) {
                this.fMatcher = Pattern.compile(tempMatchPatterns[1], 2).matcher("");
            }
        } else if (tempMatchPatterns.length > 1) {
            int index = tempMatchPatterns[0].indexOf("::");
            if (tempMatchPatterns.length > 0 && index > 0) {
                tempMatchPatterns[0] = tempMatchPatterns[0].substring(index + 2);
            }
            this.fSearchStructs = new String[tempMatchPatterns.length - 1];
            int i = 0;
            while (i < tempMatchPatterns.length - 1) {
                this.fSearchStructs[i] = tempMatchPatterns[i];
                ++i;
            }
            this.fMatcher = Pattern.compile(tempMatchPatterns[tempMatchPatterns.length - 1], 2).matcher("");
        }
        try {
            MultiStatus multiStatus;
            String taskName = this.fMatcher == null ? SearchMessages.TextSearchVisitor_filesearch_task_label : MessageFormat.format(SearchMessages.TextSearchVisitor_hidssearch_task_label, this.fSearchType.toLowerCase(), this.fMatcher.pattern().pattern());
            this.fProgressMonitor.beginTask(taskName, this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.fCollector.beginReporting();
                this.processFiles(files);
                multiStatus = this.fStatus;
            }
            catch (Throwable throwable) {
                monitorUpdateJob.cancel();
                throw throwable;
            }
            monitorUpdateJob.cancel();
            return multiStatus;
        }
        finally {
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
        }
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    private void processFiles(IFile[] files) {
        this.fDocumentsInEditors = DVTFileUtils.getInstance().evalNonFileBufferDocuments();
        int i = 0;
        while (i < files.length) {
            IProject project;
            this.fCurrentFile = files[i];
            if (this.fCurrentFile != null && (project = this.fCurrentFile.getProject()) != null) {
                RfFileDef file;
                this.fRfProject = RfManager.getInstance().getRfProject(project);
                if (this.fRfProject != null && this.fCurrentFile != null && this.fCurrentFile.getLocation() != null && ((file = this.fRfProject.getFile((IResource)this.fCurrentFile)) != null || (file = this.fRfProject.getMixedLangProjectParent().getFile((IRfSingleLangProject)this.fRfProject, this.fCurrentFile)) != null)) {
                    boolean res;
                    boolean hasHist;
                    String[] searchStrings = new String[]{this.fSearchString};
                    if ((this.fIsWildcardSearch || (hasHist = RfMixedLangManager.getInstance().hasHits(this.fCurrentFile, searchStrings, this.fMatcher, this.fRegexp))) && !(res = this.processFile(this.fCurrentFile))) break;
                }
            }
            ++i;
        }
        this.fDocumentsInEditors = null;
    }

    /*
     * Exception decompiling
     */
    private boolean processFile(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasBinaryContent(CharSequence seq, IFile file) throws CoreException {
        IContentType contentType;
        IContentDescription desc = file.getContentDescription();
        if (desc != null && (contentType = desc.getContentType()) != null && contentType.isKindOf(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"))) {
            return false;
        }
        try {
            int limit = 524288;
            int i = 0;
            while (true) {
                if (i >= limit) {
                    return false;
                }
                if (seq.charAt(i) == '\u0000') {
                    return true;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return false;
    }

    private void locateMatches(IFile file, DocumentCharSequence searchInput) throws CoreException {
        try {
            int k = 0;
            this.fMatcher.reset((CharSequence)searchInput);
            while (this.fMatcher.find()) {
                int start = this.fMatcher.start();
                int end = this.fMatcher.end();
                IDocument openDocument = this.getOpenDocument(file);
                if (openDocument == null) continue;
                int startOffsetLine = openDocument.getLineOfOffset(start);
                int endOffsetLine = openDocument.getLineOfOffset(end);
                IRegion startLineInfo = openDocument.getLineInformation(startOffsetLine);
                int lineStart = openDocument.getLineOffset(startOffsetLine);
                this.fMatchAccess.initialize(file, start, end - start, (CharSequence)searchInput, false);
                RfMixedLangManager.getInstance().installPartitionerForFile(file, searchInput.getDocument());
                boolean validContentType = RfMixedLangManager.getInstance().validContentType(file.getProject(), searchInput.getDocument(), end - 1);
                if (!validContentType) continue;
                IRfNamedElementAndScope elementAndScope = RfMixedLangManager.getInstance().getRfElement(file, searchInput.getDocument(), end);
                IRfNamedElement element = null;
                if (elementAndScope == null || (element = elementAndScope.getIRfNamedElement()) == null) {
                    if (this.arePotentialMatchesIgnored()) continue;
                    this.fMatchAccess.setPossibleMatch(true);
                    ++this.fPossibleMatchesCount;
                    int counter = this.countStartWS(openDocument, startLineInfo);
                    if (counter >= 0 && element != null) {
                        this.fMatchAccess.setSearchedElement(element.getName(), start - lineStart - counter);
                    }
                    if (this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess)) continue;
                    return;
                }
                Collection declarations = element.getDeclarations();
                if (this.fRfElement instanceof RfSearchQueryElement) {
                    int counter;
                    boolean isHit;
                    RfSearchQueryElement fQueryElement = (RfSearchQueryElement)this.fRfElement;
                    boolean bl = isHit = fQueryElement.isField() && element instanceof RfField || fQueryElement.isPool() && element instanceof RfField && ((RfField)element).isPool() || fQueryElement.isType() && (element instanceof RfStruct || element instanceof RfEnumType) || fQueryElement.isFunction() && element instanceof RfMethod;
                    if (!isHit) continue;
                    if (!this.fIncludeDeclarations) {
                        boolean isDeclaration = false;
                        currentMatchStartLine = startOffsetLine + 1;
                        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
                        if (element instanceof RfNamedElement && declarations != null) {
                            for (IRfDefElement typeLayer : declarations) {
                                if (typeLayer.getDefFile() == null || !typeLayer.getDefFile().getParserPath().equals((Object)parserPath) || typeLayer.getStartLine() != currentMatchStartLine && openDocument.getLineOfOffset(typeLayer.getEndOffset()) != endOffsetLine) continue;
                                isDeclaration = true;
                                break;
                            }
                        }
                        if (isDeclaration) continue;
                    }
                    if ((counter = this.countStartWS(openDocument, startLineInfo)) >= 0) {
                        this.fMatchAccess.setSearchedElement(element.getName(), start - lineStart - counter);
                    }
                    if (!this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess)) {
                        return;
                    }
                } else if (this.fRfElement.checkEquals((Object)element)) {
                    int counter;
                    boolean sameTypeOfElement = this.fRfElement.getClass().equals(element.getClass());
                    if (!this.fIncludeDeclarations && sameTypeOfElement) {
                        boolean isDeclaration = false;
                        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
                        currentMatchStartLine = startOffsetLine + 1;
                        if (element instanceof RfNamedElement && declarations != null) {
                            for (IRfDefElement typeLayer : declarations) {
                                if (this.fRfElement instanceof RfNamedElement && element != this.fRfElement) break;
                                if (typeLayer.getDefFile() == null || !typeLayer.getDefFile().getParserPath().equals((Object)parserPath) || typeLayer.getStartLine() != currentMatchStartLine && openDocument.getLineOfOffset(typeLayer.getEndOffset()) != endOffsetLine) continue;
                                isDeclaration = true;
                                break;
                            }
                        }
                        if (isDeclaration) continue;
                    }
                    if ((counter = this.countStartWS(openDocument, startLineInfo)) >= 0) {
                        this.fMatchAccess.setSearchedElement(element.getName(), start - lineStart - counter);
                    }
                    if (!this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess)) {
                        return;
                    }
                }
                try {
                    if (k++ != 20) continue;
                    if (this.fProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
                    }
                    k = 0;
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    break;
                }
            }
        }
        finally {
            this.fMatchAccess.initialize(null, 0, 0, "", false);
        }
    }

    private int countStartWS(IDocument openDocument, IRegion startLineInfo) {
        try {
            String lineText = openDocument.get(startLineInfo.getOffset(), startLineInfo.getLength());
            int counter = 0;
            while (Character.isWhitespace(lineText.charAt(counter))) {
                ++counter;
            }
            return counter;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    private boolean arePotentialMatchesIgnored() {
        return NewSearchUI.arePotentialMatchesIgnored();
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file) {
        LocationKind locationKind;
        TextFileBufferInfo textFileBufferInfo;
        IPath path;
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = this.fDocumentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(path = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = textFileBufferInfo.getLocationKind())) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    public int getPossibleMachesCount() {
        return this.fPossibleMatchesCount;
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private int fOffset;
        private int fLength;
        private IFile fFile;
        private CharSequence fContent;
        private boolean fPossibleMatch;
        private String fSearchedElement;
        private int fSearchedElementOffset;

        public void initialize(IFile file, int offset, int length, CharSequence content, boolean value) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
            this.fPossibleMatch = value;
            this.fSearchedElement = null;
            this.fSearchedElementOffset = -1;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public int getMatchOffset() {
            return this.fOffset;
        }

        public int getMatchLength() {
            return this.fLength;
        }

        public boolean isPossibleMatch() {
            return this.fPossibleMatch;
        }

        public void setPossibleMatch(boolean possibleMatch) {
            this.fPossibleMatch = possibleMatch;
        }

        public int getFileContentLength() {
            return this.fContent.length();
        }

        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }

        public void setSearchedElement(String searchedElement, int offset) {
            this.fSearchedElement = searchedElement;
            this.fSearchedElementOffset = offset;
        }

        public String getSearchedElement() {
            return this.fSearchedElement;
        }

        public int getSearchedElementOffset() {
            return this.fSearchedElementOffset;
        }
    }
}

