/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.search;

import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.search.BaseSearchQueryProvider;
import ro.amiq.dvt.ui.search.SearchManager;
import ro.amiq.dvt.ui.search.TextSearchPageInput;
import ro.amiq.pssdt.ui.search.DeclarationsSearchQuery;
import ro.amiq.pssdt.ui.search.ReferenceSearchPageInput;
import ro.amiq.pssdt.ui.search.ReferenceSearchQuery;
import ro.amiq.pssdt.ui.search.text.FileSearchQuery;

public class SearchQueryProvider
extends BaseSearchQueryProvider {
    private int fLimitTo;
    private int fSearchFor;
    private boolean fIncludeDeclarations;
    private boolean fOnlyCompiled;

    public SearchQueryProvider(int limitTo, int searchFor, boolean includeDeclarations, boolean isOnlyCompiled) {
        this.fLimitTo = limitTo;
        this.fSearchFor = searchFor;
        this.fIncludeDeclarations = includeDeclarations;
        this.fOnlyCompiled = isOnlyCompiled;
        SearchManager.getInstance().getPositionTracker();
    }

    public ISearchQuery createQuery(TextSearchQueryProvider.TextSearchInput input) {
        boolean wholeWord;
        FileTextSearchScope scope = input.getScope();
        String text = input.getSearchText();
        boolean regEx = input.isRegExSearch();
        boolean caseSensitive = input.isCaseSensitiveSearch();
        boolean bl = wholeWord = regEx ? false : ((TextSearchPageInput)input).isWholeWordSearch();
        if (input instanceof ReferenceSearchPageInput) {
            IRfNamedElement element = ((ReferenceSearchPageInput)input).getRfElement();
            String searchLabel = element.getFullNameLabel();
            return new ReferenceSearchQuery(this.getProject(element, input), this.getSearchType(element), element, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fSearchFor);
        }
        String searchLabel = text;
        if (this.fSearchFor == 2) {
            searchLabel = String.valueOf(searchLabel) + "()";
        }
        if (this.fLimitTo == 0) {
            return new DeclarationsSearchQuery(this.getSearchType(), text, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fOnlyCompiled, this.fSearchFor);
        }
        return new FileSearchQuery(this.getSearchType(), text, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fOnlyCompiled, this.fSearchFor);
    }

    protected String getSearchType() {
        switch (this.fSearchFor) {
            case 0: {
                return "Type";
            }
            case 1: {
                return "Field";
            }
            case 2: {
                return "Function";
            }
            case 3: {
                return "Pool";
            }
        }
        return "Text";
    }
}

