/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.ui.search.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.text.BaseTextSearchResultCollector;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.pssdt.ui.search.ReferenceSearchVisitor;
import ro.amiq.pssdt.ui.search.text.FileMatch;

public final class TextSearchResultCollector
extends BaseTextSearchResultCollector {
    public TextSearchResultCollector(AbstractTextSearchResult result, boolean isFileSearchOnly, boolean searchInBinaries) {
        super(result, isFileSearchOnly, searchInBinaries);
    }

    public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
        int matchOffset = matchRequestor.getMatchOffset();
        LineElement lineElement = this.getLineElement(matchOffset, matchRequestor);
        if (lineElement != null) {
            FileMatch fileMatch;
            if (matchRequestor instanceof ReferenceSearchVisitor.ReusableMatchAccess) {
                fileMatch = new FileMatch(matchRequestor.getFile(), matchRequestor.getMatchOffset(), matchRequestor.getMatchLength(), ((ReferenceSearchVisitor.ReusableMatchAccess)matchRequestor).isPossibleMatch(), lineElement);
                String searchElement = ((ReferenceSearchVisitor.ReusableMatchAccess)matchRequestor).getSearchedElement();
                int searchElementOffset = ((ReferenceSearchVisitor.ReusableMatchAccess)matchRequestor).getSearchedElementOffset();
                lineElement.setSearchedElement(searchElement, searchElementOffset, fileMatch.isPossibleMatch());
            } else {
                fileMatch = new FileMatch(matchRequestor.getFile(), matchRequestor.getMatchOffset(), matchRequestor.getMatchLength(), false, lineElement);
            }
            lineElement.setExtraInfo(this.getScopeInfo(lineElement, matchRequestor));
            if (this.fCachedMatches != null && !this.fCachedMatches.contains((Object)fileMatch)) {
                this.fCachedMatches.add(fileMatch);
            }
        }
        return true;
    }

    protected BaseFileMatch makeMatch(IFile file) {
        return new FileMatch(file, 0, 0, false);
    }

    private String getScopeInfo(LineElement lineElement, TextSearchMatchAccess matchRequestor) {
        if (lineElement == null || matchRequestor == null) {
            return null;
        }
        IFile file = matchRequestor.getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (parserPath == null) {
            return null;
        }
        return RfSearchUtils.getScopeInfo((IProject)project, (ParserPath)parserPath, (int)lineElement.getLine(), (int)lineElement.getOffset(), (boolean)lineElement.isPossibleMatch());
    }
}

