/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.comment.formatter.CommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.RfTemplateStruct;

public class PSSLinkResolver
extends CommentLinkResolver {
    public LanguageKind getLanguageKind() {
        return LanguageKind.PSS;
    }

    public Collection<IRfNamedElement> getInitialCandidates(IRfNamedElement element, ITextEditor textEditor) {
        IRfScopeElement scope = element.getEnclosingScope();
        if (scope == null) {
            return null;
        }
        return PSSLinkResolver.getInitialCandidatesInScope(scope);
    }

    public IRfNamedElement solveHyperlinkForAllCandidates(IRfNamedElement element, Collection<IRfNamedElement> candidates, String[] parsedLink, long timeoutTime) {
        try {
            for (IRfNamedElement candidate : candidates) {
                IRfNamedElement foundElement = this.recursiveFindElement(candidate, parsedLink, 0, timeoutTime);
                if (foundElement == null) continue;
                return foundElement;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public static Collection<IRfNamedElement> getInitialCandidatesInScope(IRfScopeElement scope) {
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        while (scope != null) {
            if (scope instanceof RfNamedElement) {
                result.add((RfNamedElement)scope);
            }
            scope = scope.getEnclosingScope();
        }
        return result;
    }

    public IRfNamedElement recursiveFindElement(IRfNamedElement scope, String[] parsedElementPath, int pathIndex, long timeoutTime) throws Exception {
        if (System.currentTimeMillis() > timeoutTime) {
            throw new Exception("Tooltip timeout in resolving link " + String.join((CharSequence)".", parsedElementPath));
        }
        if (!(scope instanceof RfNamedElement) || parsedElementPath == null) {
            return null;
        }
        if (scope.getRfProject() == null) {
            return null;
        }
        RfNamedElement currentScope = (RfNamedElement)scope;
        if (pathIndex >= parsedElementPath.length) {
            return scope;
        }
        List<RfNamedElement> members = PSSLinkResolver.getCandidatesInScope(currentScope, currentScope.getRfProject());
        if (members == null || members.isEmpty()) {
            return null;
        }
        String name = PSSLinkResolver.extractName(parsedElementPath[pathIndex]);
        String[] args = PSSLinkResolver.extractArgs(parsedElementPath[pathIndex]);
        IRfNamedElement result = null;
        for (RfNamedElement member : members) {
            if (!parsedElementPath[pathIndex].equals(member.getName()) && !PSSLinkResolver.isElementWithGenericParams(member, parsedElementPath[pathIndex], args, name) || (result = this.recursiveFindElement(member, parsedElementPath, pathIndex + 1, timeoutTime)) == null) continue;
            return result;
        }
        return null;
    }

    public static boolean isElementWithGenericParams(RfNamedElement member, String originalElementPathName, String[] args, String name) {
        if (!(member instanceof RfTemplateStruct) || !((RfTemplateStruct)member).hasLocalMembers()) {
            return false;
        }
        if (originalElementPathName.equals(((RfTemplateStruct)member).getSignatureWithoutType())) {
            return true;
        }
        if (name == null || !name.equals(member.getName())) {
            return false;
        }
        List<RfTemplateParam> allArgsByName = ((RfTemplateStruct)member).getParameters();
        if (allArgsByName == null || args == null || args.length != allArgsByName.size()) {
            return false;
        }
        int argsIndex = 0;
        for (RfTemplateParam argument : allArgsByName) {
            String argumentKindName;
            String string = argumentKindName = argument instanceof RfTemplateParam.RfTemplateTypeParam ? ((RfTemplateParam.RfTemplateTypeParam)argument).getStructKind().name() : "";
            if (!(args[argsIndex].equals(argument.getName()) || args[argsIndex].equalsIgnoreCase(argument.getAssociatedTypeName()) || args[argsIndex].equalsIgnoreCase(argumentKindName))) {
                return false;
            }
            ++argsIndex;
        }
        return true;
    }

    public static String extractName(String nameWithParams) {
        if (nameWithParams == null || nameWithParams.isEmpty() || !nameWithParams.contains("(")) {
            return null;
        }
        int indexEnd = nameWithParams.indexOf("(");
        String name = nameWithParams.substring(0, indexEnd);
        if (name == null) {
            return null;
        }
        return name.trim();
    }

    public static String[] extractArgs(String name) {
        if (name == null || name.isEmpty() || !name.contains("(")) {
            return null;
        }
        int indexStart = name.indexOf("(") + "(".length();
        if (indexStart < 0 || indexStart > name.length()) {
            return null;
        }
        int indexEnd = name.indexOf(")");
        if (indexEnd < 0 || indexEnd > name.length() || indexStart > indexEnd) {
            return null;
        }
        String declaredTypes = name.substring(indexStart, indexEnd);
        String[] types = DVTStringUtil.split((Pattern)CommentConstants.ARGS_PATTERN, (String)declaredTypes);
        return types;
    }

    public static List<RfNamedElement> getCandidatesInScope(RfNamedElement element, RfProject rfProject) {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        if (element == null) {
            return result;
        }
        if (rfProject != null) {
            Collection<RfNamedElement> children = element.getLocalMembers();
            if (children != null && !children.isEmpty()) {
                for (RfNamedElement child : children) {
                    if (child instanceof RfPackage && ((RfPackage)child).getName().equals("main")) {
                        result.addAll(((RfPackage)child).getLocalMembers());
                        continue;
                    }
                    result.add(child);
                }
            }
            return result;
        }
        Collection<RfNamedElement> localMembers = element.getLocalMembers();
        if (localMembers != null) {
            result.addAll(localMembers);
        }
        return result;
    }

    public IFile getIFileFromElement(IRfNamedElement element) {
        if (element == null || !(element instanceof RfNamedElement)) {
            return null;
        }
        RfDefElement defElem = ((RfNamedElement)element).getDeclaration();
        if (defElem == null) {
            return null;
        }
        RfFileDef defFile = defElem.getDefFile();
        if (defFile == null) {
            return null;
        }
        Object fileObj = defFile.getAdapter(IResource.class);
        if (!(fileObj instanceof IFile)) {
            return null;
        }
        return (IFile)fileObj;
    }

    public IRfNamedElement getNamedElementFromPath(String path, IProject project) {
        RfElementPath elementPath = RfElementPath.fromString((String)path, PSSLinkResolver.class);
        if (elementPath == null) {
            return null;
        }
        return elementPath.toNamedElement(project);
    }

    public List<IRfNamedElement> getPackageCandidates(String packageName, IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        return PSSLinkResolver.getPackageCandidatesFromProject(packageName, rfProject);
    }

    public static List<IRfNamedElement> getPackageCandidatesFromProject(String packageName, RfProject rfProject) {
        if (rfProject == null) {
            return null;
        }
        List<RfNamedElement> packages = rfProject.getAllPackages();
        if (packages == null) {
            return null;
        }
        Iterator it = packages.iterator();
        ArrayList<IRfNamedElement> packageCandidates = new ArrayList<IRfNamedElement>();
        while (it.hasNext()) {
            RfNamedElement currPackage = (RfNamedElement)it.next();
            if (!packageName.equalsIgnoreCase(currPackage.getName())) continue;
            packageCandidates.add(currPackage);
        }
        return packageCandidates;
    }

    public IFile getFile(IRfNamedElement element, IProject project) {
        return this.getIFileFromElement(element);
    }
}

