/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.model.IPSSModel;
import ro.amiq.pssdt.model.IPSSProject;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.model.indexer.IdentifierIndexer;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.semantic.RfSemanticError;
import ro.amiq.pssdt.model.reflection.semantic.SemanticErrorsManager;
import ro.amiq.pssdt.model.reflection.views.PSSQuickViewersUtil;
import ro.amiq.pssdt.parser.PSSFileInstance;
import ro.amiq.pssdt.parser.PSSFileInstancesMap;
import ro.amiq.pssdt.ui.editor.PSSEditor;
import ro.amiq.pssdt.ui.editor.highlight.PSSSemanticHighlighter;

public class Utils {
    public static String getFileExtension(File file) {
        return ro.amiq.dvt.utils.Utils.getFileExtension((File)file);
    }

    public static String getFileExtension(String fileName) {
        return ro.amiq.dvt.utils.Utils.getFileExtension((String)fileName);
    }

    public static String getFileNameNoExtension(File file) {
        return ro.amiq.dvt.utils.Utils.getFileNameNoExtension((File)file);
    }

    public static String getFileNameNoExtension(String fileName) {
        return ro.amiq.dvt.utils.Utils.getFileNameNoExtension((String)fileName);
    }

    public static String getFileName(File file) {
        return ro.amiq.dvt.utils.Utils.getFileName((File)file);
    }

    public static String getFileName(String pathString) {
        return ro.amiq.dvt.utils.Utils.getFileName((String)pathString);
    }

    public static Object createPosition(int offset, int length) {
        return new DVTPosition(offset, length);
    }

    public static boolean positionDeleted(Object position) {
        return ((Position)position).isDeleted;
    }

    public static int positionLength(Object position) {
        return ((Position)position).length;
    }

    public static int positionOffset(Object position) {
        return ((Position)position).offset;
    }

    public static int documentNumberOfLines(Object document) {
        return ((IDocument)document).getNumberOfLines();
    }

    public static int documentLineOffset(Object document, int line) throws Exception {
        return ((IDocument)document).getLineOffset(line);
    }

    public static void addDocumentPosition(Object document, String category, Object position) throws Exception {
        if (!((IDocument)document).containsPositionCategory(category)) {
            return;
        }
        ((IDocument)document).addPosition(category, (Position)position);
    }

    public static int convertPositionToLine(Object document, int offset) {
        try {
            if (document != null && ((IDocument)document).getLength() > offset) {
                return ((IDocument)document).getLineOfOffset(offset) + 1;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public static IResource getFileAdapter(RfProject rfProject, String fullPath) {
        return DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(rfProject.getProject(), fullPath);
    }

    public static String getCrossPlatformPath(String inputPath) {
        return DVTUtilsCommon.INSTANCE.getCrossPlatformPath(inputPath);
    }

    public static void cleanSemanticMarkers(IProject project) {
        SemanticErrorsManager.getInstance().clean(project);
    }

    public static void triggerSemanticMarkers(RfProject rfProject, Map<String, Collection<RfSemanticError>> semanticErrors, boolean toConsole) {
        SemanticErrorsManager.getInstance().reparsed(rfProject.getProject(), semanticErrors, toConsole);
    }

    public static void connectActiveOpenEditor(final RfProject rfProject) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (rfProject.getFileEditors() == null) {
                        return;
                    }
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    if (workbench == null) {
                        return;
                    }
                    IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow == null) {
                        return;
                    }
                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                    if (activePage == null) {
                        return;
                    }
                    IEditorPart editor = activePage.getActiveEditor();
                    if (editor == null) {
                        return;
                    }
                    if (editor instanceof PSSEditor) {
                        IFile file = (IFile)editor.getAdapter(IResource.class);
                        if (file == null) {
                            return;
                        }
                        ParserPath parserPath = rfProject.resource2parser((IResource)file);
                        if (parserPath == null) {
                            return;
                        }
                        if (!rfProject.isCompiled(parserPath)) {
                            PSSQuickViewersUtil.getInstance().scheduleReparseIfNonTop((ITextEditor)((DVTEditor)editor));
                            return;
                        }
                        rfProject.connectFileToDocument(parserPath, (DVTEditor)editor, false);
                        rfProject.notifyParsingEndUsingParserPath(new HashSet<ParserPath>(Arrays.asList(parserPath)));
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    public static IIdentifierIndexerExtension getIndexer(IProject project) {
        return IdentifierIndexerManager.getInstance().getProjectIndexer(IdentifierIndexer.class, project);
    }

    public static void runOnDisplayThread(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    public static int getEndOffset(Object position) {
        if (position != null) {
            return ((Position)position).getOffset() + ((Position)position).getLength();
        }
        return 0;
    }

    public static int getStartOffset(Object position) {
        if (position != null) {
            return ((Position)position).getOffset();
        }
        return 0;
    }

    public static int convertLineToOffset(Object document, int line) {
        block3: {
            try {
                if (document != null) break block3;
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return ((IDocument)document).getLineOffset(line - 1);
    }

    public static void refreshMarkers(RfProject rfProject) {
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])new Object[]{rfProject});
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.DifferentColorsDecorator", (Object[])new Object[]{rfProject});
    }

    public static RfProject getRfProject(IProject project) {
        return RfManager.getInstance().getRfProject(project);
    }

    public static int maxIssuesKindNumber(IProject project) {
        int maxIssuesKindNumber = BuildConfigManager.getMaxNofSyntacticProblemsPerFile((IProject)project);
        return maxIssuesKindNumber;
    }

    public static IPSSProject getPSSProject(IProject project) {
        IPSSModel pssModel = PSSModelManager.getInstance().getPSSModel();
        IPSSProject pssProject = pssModel.getPSSProject(project);
        return pssProject;
    }

    public static int documentLength(IDocument document) {
        return document.getLength();
    }

    public static IPath getStateLocation() {
        return PSSPlugin.getDefault().getStateLocation();
    }

    public static void startHighlight(IRfFileDef fileDef, DVTEditor editor) {
        if (fileDef == null || editor == null) {
            return;
        }
        DVTHlUtils.startHighlight((IRfFileDef)fileDef, (DVTEditor)editor, (DVTSemanticHighlighter)new PSSSemanticHighlighter(editor.getDocument()), (AbstractUIPlugin)PSSPlugin.getDefault(), (String)"highlight.semantic");
        ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
    }

    public static void connectPragmaCodePositions(IDocument document, RfFileDef fileDef, Set<DVTSemanticFoldingPosition> foldingPositions) {
        try {
            if (document == null || fileDef == null || foldingPositions == null) {
                return;
            }
            if (document.containsPositionCategory("CUSTOM_PRAGMA")) {
                try {
                    document.removePositionCategory("CUSTOM_PRAGMA");
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            document.addPositionCategory("CUSTOM_PRAGMA");
            if (BuildConfigManager.getCustomPragmas((IProject)fileDef.getRfProject().getProject()).isEmpty()) {
                return;
            }
            List<CustomPragmaUsage> customPragmas = Utils.getCustomPragmas(fileDef.getRfProject(), fileDef.getParserPath());
            if (customPragmas == null) {
                ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"CUSTOM_PRAGMA");
                return;
            }
            ro.amiq.dvt.ui.Utils.addCustomPragmasPositions(customPragmas, foldingPositions, (IDocument)document);
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"CUSTOM_PRAGMA");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static List<CustomPragmaUsage> getCustomPragmas(RfProject rfProject, ParserPath parserPath) {
        if (rfProject == null || parserPath == null) {
            return null;
        }
        PSSFileInstancesMap fileInstancesMap = rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return null;
        }
        List<PSSFileInstance> instances = fileInstancesMap.getFileInstances(parserPath);
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        ArrayList<CustomPragmaUsage> result = new ArrayList<CustomPragmaUsage>();
        for (PSSFileInstance instance : instances) {
            result.addAll(instance.getCustomPragmas());
        }
        return result;
    }

    public static void setCustomPragmas(RfProject rfProject, ParserPath parserPath, List<CustomPragmaUsage> pragmas) {
        if (rfProject == null || parserPath == null) {
            return;
        }
        PSSFileInstancesMap fileInstancesMap = rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return;
        }
        List<PSSFileInstance> instances = fileInstancesMap.getFileInstances(parserPath);
        if (instances == null || instances.isEmpty()) {
            return;
        }
        for (PSSFileInstance instance : instances) {
            instance.cleanCustomPragmas();
        }
        instances.get(0).setCustomPragmas(pragmas);
    }

    public static int getCodeFoldingNofLines() {
        return PSSPlugin.getDefault().getPreferenceStore().getInt("editor.numberOfLines");
    }

    public static void startUpdateScopeBreadcrumb(final DVTEditor editor) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow == null) {
                        return;
                    }
                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                    if (activePage == null) {
                        return;
                    }
                    Utils.internalSetReadOnlyBreadcrumbs(editor, false);
                    if (!activePage.isPartVisible((IWorkbenchPart)editor)) {
                        return;
                    }
                    ScopeBreadcrumbConfiguration configuration = new ScopeBreadcrumbConfiguration(editor.getCursorScopeForBreadcrumb(true), editor.getCursor(), (IFile)editor.getAdapter(IResource.class), true);
                    editor.updateBreadcrumb(ScopeBreadcrumbViewer.class, (AbstractBreadcrumbConfiguration)configuration);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError(e.getMessage());
                }
            }
        });
    }

    public static void setReadOnlyBreadcrumbs() {
        Job updateBCJob = new Job("Setting read-only Breadcrumbs..."){

            protected IStatus run(IProgressMonitor monitor) {
                for (IEditorReference edReference : ro.amiq.dvt.ui.Utils.getCurrentlyOpenEditorReferences()) {
                    IEditorPart editor = edReference.getEditor(false);
                    if (!(editor instanceof DVTEditor)) continue;
                    Utils.internalSetReadOnlyBreadcrumbs((DVTEditor)editor, true);
                }
                return Status.OK_STATUS;
            }
        };
        updateBCJob.setSystem(true);
        updateBCJob.schedule();
    }

    private static void internalSetReadOnlyBreadcrumbs(DVTEditor editor, boolean isReadOnly) {
        IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        boolean forceReadOnly = false;
        if (activePage.isPartVisible((IWorkbenchPart)editor)) {
            forceReadOnly = true;
        }
        List breadcrumbViewers = editor.getBreadcrumbViewers();
        for (AbstractBreadcrumbViewer breadcrumb : breadcrumbViewers) {
            if (!(breadcrumb instanceof ThickBreadcrumbViewer)) continue;
            ((ThickBreadcrumbViewer)breadcrumb).setModelReady(!isReadOnly);
            if (!forceReadOnly) continue;
            ((ThickBreadcrumbViewer)breadcrumb).changeReadOnlyState();
        }
    }
}

