/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.slndt.core;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import ro.amiq.dvt.DVTActivator;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.actions.IMacroTraceListener;
import ro.amiq.dvt.ui.actions.MacroTraceActionManager;
import ro.amiq.edt.base.builders.EMacroTraceConsoleViewer;
import ro.amiq.edt.base.core.EDTBaseActivator;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.etools.eparser.EParser;
import ro.amiq.slndt.core.SLNDTPluginCommon;
import ro.amiq.slndt.externaltools.EExternalToolsDelegate;
import ro.amiq.slndt.model.SLNModelManager;
import ro.amiq.slndt.model.reflection.RfManager;
import ro.amiq.slndt.ui.encrypted.EncryptedLabelManager;
import ro.amiq.slndt.ui.namechecker.NameCheckerWarningsManager;
import ro.amiq.slndt.ui.persistenttask.PersistentTaskManager;
import ro.amiq.slndt.ui.syntaxerrors.SyntaxErrorsManager;

public class SLNDTPlugin
extends SLNDTPluginCommon {
    private static SLNDTPlugin fPlugin;
    private IPreferenceStore fCombinedPreferenceStore;

    public SLNDTPlugin() {
        fPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DVTLogger.INSTANCE.logDebug(">> Started SLNDT Plugin (version: " + (String)this.getBundle().getHeaders().get("Bundle-Version") + ").");
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 2 && event.getBundle().getSymbolicName().equals("ro.amiq.slndt")) {
                    DVTLogger.INSTANCE.logDebug(">> Started SLNDT initialization.");
                    new DVTActivator();
                    new EDTBaseActivator();
                    SyntaxErrorsManager.getInstance().startup();
                    EncryptedLabelManager.getInstance().startup();
                    MacroTraceActionManager.getInstance().addMacroTraceListener("ro.amiq.slndt", (IMacroTraceListener)new EMacroTraceConsoleViewer((AbstractRfManager)RfManager.getInstance()));
                    ExternalToolsModelManager.getInstance().addExternalToolsDelegate((IExternalToolsDelegate)EExternalToolsDelegate.getInstance());
                    DVTLogger.INSTANCE.logDebug("Using " + EParser.getVersion());
                    try {
                        while (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                            Thread.sleep(50L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DVTLogger.INSTANCE.logDebug(">> Started SLNDT UI initialization.");
                            SLNDTPlugin.getDefault().getPreferenceStore().setDefault("ro.amiq.slndt.VRST_HOME", "");
                            DVTMixedLangModelManager.getInstance().registerModelManager((DVTModelManager)SLNModelManager.getInstance());
                            PersistentTaskManager.getInstance().startup();
                            NameCheckerWarningsManager.getInstance();
                            ObjectionManager.getInstance().clear(Objection.SLNDT_INITIALIZED);
                            DVTLogger.INSTANCE.logDebug("<< Ended SLNDT UI initialization.");
                        }
                    });
                    DVTLogger.INSTANCE.logDebug("<< Ended SLNDT initialization.");
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        try {
            SyntaxErrorsManager.getInstance().shutdown();
            EncryptedLabelManager.getInstance().shutdown();
            PersistentTaskManager.getInstance().shutdown();
            MacroTraceActionManager.getInstance().removeMacroTraceListener("ro.amiq.slndt");
            DVTPlugin.getDefault().collect().i("F736C6E");
            DVTLogger.INSTANCE.logDebug("<< Ended SLNDT Plugin.");
        }
        finally {
            fPlugin = null;
            super.stop(context);
        }
    }

    public static SLNDTPlugin getDefault() {
        return fPlugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ro.amiq.slndt", (String)path);
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public void savePreferences() {
        try {
            InstanceScope instance = new InstanceScope();
            instance.getNode("ro.amiq.slndt").flush();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

