/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.slndt.externaltools;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.slndt.model.SLNModelManager;

public class EExternalToolsDelegate
implements IExternalToolsDelegate {
    private static volatile EExternalToolsDelegate fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private EExternalToolsDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EExternalToolsDelegate getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new EExternalToolsDelegate();
            }
        }
        return fInstance;
    }

    public IFile getResource(IProject project, String knownPath) {
        IFile candidate;
        String customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        Path path = new Path(customPath);
        if (path.isAbsolute()) {
            File classicFile = new File(knownPath);
            IFile candidate2 = EDTFileUtils.getInstance().getProjectFile(project, classicFile.getAbsolutePath());
            if (candidate2 == null) {
                return null;
            }
            return candidate2;
        }
        IEProject eProject = SLNModelManager.getInstance().getEModel().getEProject(project);
        if (eProject == null) {
            return null;
        }
        CompilationUnitProperties compilationUnitProperties = eProject.getCompilationUnitProperties(false);
        if (!compilationUnitProperties.hasFilesToCompile()) {
            return null;
        }
        String rawSpecmanPath = compilationUnitProperties.getDvtSpecmanPath();
        if (rawSpecmanPath != null && rawSpecmanPath.length() != 0) {
            String[] specmanPath = DVTStringUtil.split((String)IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR, (String)rawSpecmanPath);
            String fullFileName = knownPath;
            File classicFile = null;
            String fileSeparator = System.getProperty("file.separator");
            int i = 0;
            while (i < specmanPath.length) {
                fullFileName = String.valueOf(specmanPath[i]) + fileSeparator + knownPath;
                customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(fullFileName);
                classicFile = new File(customPath);
                if (classicFile.exists()) break;
                classicFile = null;
                ++i;
            }
            if (classicFile != null) {
                IFile candidate3 = EDTFileUtils.getInstance().getProjectFile(project, classicFile.getAbsolutePath());
                if (candidate3 == null) {
                    return null;
                }
                return candidate3;
            }
        }
        if ((candidate = EDTFileUtils.getInstance().findProjectFile(project, knownPath)) == null) {
            return null;
        }
        return candidate;
    }

    public String getBuilderKind() {
        return "ro.amiq.dvt.slndtKind";
    }

    public void openEditor(IProject project, String workingDirectory, String filePath, int line) {
        if (!Path.fromOSString((String)filePath).isAbsolute()) {
            filePath = Path.fromOSString((String)workingDirectory).append(filePath).toOSString();
        }
        filePath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(filePath);
        EDTFileUtils.getInstance().openFile((AbstractEModelManager)SLNModelManager.getInstance(), project, filePath, line, null);
    }

    public boolean hasRelevantContentType(String fileName) {
        if (fileName == null) {
            return false;
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.slndt.SLNSource", false);
        return DVTFileUtils.getInstance().validExtension(fileExtensions, fileName);
    }
}

