/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.slndt.test;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.ProductSafe;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.views.CompileOrderViewLabelProvider;
import ro.amiq.edt.base.model.reflection.views.ELayersViewLabelProvider;
import ro.amiq.edt.base.model.reflection.views.THViewLabelProvider;
import ro.amiq.edt.base.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.edt.base.test.AbstractTestHelper;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.slndt.core.SLNDTPlugin;
import ro.amiq.slndt.core.SLNPluginConfig;
import ro.amiq.slndt.model.SLNModelManager;
import ro.amiq.slndt.model.reflection.RfManager;

@ForTestingOrDebuggingOnly
public class TestHelper
extends AbstractTestHelper {
    private static final TestHelper INSTANCE = new TestHelper();
    public static CompileOrderViewLabelProvider wrp6;
    public static TypesViewLabelProvider wrp2;
    public static THViewLabelProvider wrp4;
    public static ELayersViewLabelProvider wrp5;

    private TestHelper() {
        this.fPreferenceStore = SLNDTPlugin.getDefault().getPreferenceStore();
    }

    @ProductSafe
    public static TestHelper getInstance() {
        return INSTANCE;
    }

    static CompileOrderViewLabelProvider getLoadOrderViewProvider() {
        if (wrp6 == null) {
            wrp6 = new CompileOrderViewLabelProvider((IEPluginConfig)SLNPluginConfig.getInstance());
        }
        return wrp6;
    }

    public static String getLoadOrderName(Object wrapper) {
        return TestHelper.getLoadOrderViewProvider().getText(wrapper);
    }

    public static String openEditorForStructName(String projectName, String structName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        List candidates = rfProject.getStructsWithPrefix(1, structName);
        if (candidates == null || candidates.isEmpty()) {
            return "";
        }
        RfNamedElement element = (RfNamedElement)candidates.get(0);
        RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction((IEPluginConfig)SLNPluginConfig.getInstance(), (RfNamedElement)element, (IProject)project, null);
        if (actionHyperlink == null) {
            return "";
        }
        actionHyperlink.open();
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getTitle();
    }

    public static void executeRefactoringRename(DVTEditor editor) {
        TestHelper.executeRefactoringRename((IEPluginConfig)SLNPluginConfig.getInstance(), (DVTEditor)editor);
    }

    public static Object doRenameRefactorE(DVTRenameRefactorInfo info) {
        return TestHelper.doRenameRefactorE((IEPluginConfig)SLNPluginConfig.getInstance(), (DVTRenameRefactorInfo)info);
    }

    static TypesViewLabelProvider getUIRfTypesTreeViewProvider() {
        if (wrp2 == null) {
            wrp2 = new TypesViewLabelProvider((IEPluginConfig)SLNPluginConfig.getInstance());
        }
        return wrp2;
    }

    public String getTypesText(Object wrapper) {
        return TestHelper.getUIRfTypesTreeViewProvider().getText(wrapper);
    }

    public Image getTypesImage(Object wrapper) {
        return TestHelper.getUIRfTypesTreeViewProvider().getImage(wrapper);
    }

    static THViewLabelProvider getRfTypeHierarchyViewProvider() {
        if (wrp4 == null) {
            wrp4 = new THViewLabelProvider((IEPluginConfig)SLNPluginConfig.getInstance());
        }
        return wrp4;
    }

    public static String getTypeHierarchyText(Object wrapper) {
        return TestHelper.getRfTypeHierarchyViewProvider().getText(wrapper);
    }

    public static Image getTypeHierarchyImage(Object wrapper) {
        return TestHelper.getRfTypeHierarchyViewProvider().getImage(wrapper);
    }

    static ELayersViewLabelProvider getLayersTableViewProvider() {
        if (wrp5 == null) {
            wrp5 = new ELayersViewLabelProvider((IEPluginConfig)SLNPluginConfig.getInstance());
        }
        return wrp5;
    }

    public static String getLayersName(Object wrapper) {
        return TestHelper.getLayersTableViewProvider().getColumnText(wrapper, 0);
    }

    public static String getLayersStruct(Object wrapper) {
        return TestHelper.getLayersTableViewProvider().getColumnText(wrapper, 1);
    }

    public static String getLayersPack(Object wrapper) {
        return TestHelper.getLayersTableViewProvider().getColumnText(wrapper, 3);
    }

    public static String getLayersFileName(Object wrapper) {
        return TestHelper.getLayersTableViewProvider().getColumnText(wrapper, 4);
    }

    public static int getLayersLine(Object wrapper) {
        return Integer.parseInt(TestHelper.getLayersTableViewProvider().getColumnText(wrapper, 5));
    }

    public static IDVTProject getEProject(IProject iProject) {
        return SLNModelManager.getInstance().getEModel().getEProject(iProject);
    }

    public static IPreferenceStore getPreferenceStore() {
        return TestHelper.getInstance().fPreferenceStore;
    }

    public static long getLastFullBuildDuration(IProject project) {
        return RfManager.getInstance().getRfProject(project).getLastFullBuildDuration();
    }

    public static void cleanProject(IProject project) {
        RfManager.getInstance().getRfProject(project).clean();
    }

    public IEPluginConfig getPluginConfig() {
        return SLNPluginConfig.getInstance();
    }
}

