/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.slndt.ui;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.preferences.OverlayPreferenceStore;
import ro.amiq.dvt.ui.preferences.theme.IThemePreviewContributor;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.ESourceViewerConfiguration;
import ro.amiq.edt.base.ui.preferences.ESourcePreviewerUpdater;
import ro.amiq.slndt.core.SLNDTPlugin;
import ro.amiq.slndt.core.SLNPluginConfig;
import ro.amiq.slndt.ui.editor.SLNDocumentSetupParticipant;

public class SLNThemePreviewContributor
implements IThemePreviewContributor {
    private DVTPreviewSourceViewer fPreviewViewer;
    private IPreferenceStore fPluginStore = SLNDTPlugin.getDefault().getPreferenceStore();
    private OverlayPreferenceStore fOverlayStore = new OverlayPreferenceStore(SLNDTPlugin.getDefault().getCombinedPreferenceStore(), this.createOverlayStoreKeys());
    private Control previewControl;

    public SLNThemePreviewContributor() {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    public Control createLanguagePreviewer(Composite parent) {
        ESourceViewerConfiguration configuration = new ESourceViewerConfiguration((IEPluginConfig)SLNPluginConfig.getInstance(), null);
        this.fPreviewViewer = new DVTPreviewSourceViewer(parent, 2560);
        this.fPreviewViewer.setPreferenceStore(SLNDTPlugin.getDefault().getCombinedPreferenceStore());
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingsPreviewCode.e");
        Document document = new Document(content);
        SLNDocumentSetupParticipant docSetup = new SLNDocumentSetupParticipant();
        docSetup.setup((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        ESourcePreviewerUpdater.registerPreviewer((IEPluginConfig)SLNPluginConfig.getInstance(), (SourceViewer)this.fPreviewViewer, (ESourceViewerConfiguration)configuration, (IPreferenceStore)this.fOverlayStore);
        this.addAllSemanticPositions((IDocument)document);
        this.previewControl = this.fPreviewViewer.getControl();
        return this.previewControl;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.x_template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.default.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.openclose.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.openclose.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.openclose.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_task.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_pragma.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_hyperlink.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.javadoc_tags.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.keyword.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.keyphrase.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyphrase.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyphrase.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.preproc.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.preproc.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.preproc.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.group.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.group.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.group.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_constant.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constant.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constant.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.unit.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.unit.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.unit.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.number.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.string.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.hdl_path.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.hdl_path.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.hdl_path.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.method.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.method.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.method.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.port.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.port.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.port.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.event.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.event.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.event.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.replace.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.replace.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.replace.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.template_id.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.exp_literal.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.exp_literal.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.exp_literal.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.exp_replace.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.exp_replace.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.exp_replace.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_argument.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_field.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_field.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_field.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_types.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_types.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_types.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_variable.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_variable.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_variable.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_out_port.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_out_port.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_out_port.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.label.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.label.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.label.italic"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuilder buffer = new StringBuilder(512);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return buffer.toString();
    }

    private void addAllSemanticPositions(IDocument document) {
        try {
            if (!document.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            } else {
                document.removePositionCategory("SEMANTIC_HIGHLIGHT");
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            }
            HashMap positions = new HashMap();
            DVTHlUtils.addPosition((IDocument)document, (int)11, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)34, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)53, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)120, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)133, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)141, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)149, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)178, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)394, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)414, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)431, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)447, (HighlightKind)HighlightKind.EVENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)460, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)469, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)481, (HighlightKind)HighlightKind.PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)515, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)539, (HighlightKind)HighlightKind.OUT_PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)569, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)695, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)704, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)724, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)781, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)790, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)817, (HighlightKind)HighlightKind.OUT_PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)842, (HighlightKind)HighlightKind.PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)867, (HighlightKind)HighlightKind.VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)907, (HighlightKind)HighlightKind.LABEL, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)918, (HighlightKind)HighlightKind.EVENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)949, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPositionsToDocument((IDocument)document, positions.values());
            DVTHlUtils.notifyListeners((IDocument)document, null);
            this.fPreviewViewer.invalidateTextPresentation();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getLanguage() {
        return "SLN";
    }

    public OverlayPreferenceStore getOverlayPreferenceStore() {
        return this.fOverlayStore;
    }

    public IPreferenceStore getPluginPreferenceStore() {
        return this.fPluginStore;
    }

    public String getPluginId() {
        return "ro.amiq.slndt";
    }

    public void cancelPreview() {
        SLNPluginConfig.getInstance().getEStyle().updateTokens();
    }

    public Integer getPreviewOrderId() {
        return 4;
    }

    public void updateBackground(Color color) {
        if (this.fPreviewViewer == null) {
            return;
        }
        if (this.fPreviewViewer.getTextWidget() == null) {
            return;
        }
        DVTColorUtil.INSTANCE.setBackground((Control)this.fPreviewViewer.getTextWidget(), color, true);
    }

    public Control getPreviewControl() {
        return this.previewControl;
    }
}

