/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.slndt.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.edt.base.ui.editor.IEStyle;
import ro.amiq.slndt.core.SLNDTPlugin;

public class SLNStyle
implements IEStyle {
    private final HashMap<String, Token> fTokenMap = new HashMap();
    private Boolean fSemanticHighlight;
    private Boolean fTemplateIdentifierHighlight;
    private Boolean fXTemplateIdentifierHighlight;
    private static volatile SLNStyle fInstance;
    private AbstractUIPlugin fPlugin;
    private HighlightPreferenceListener fPreferenceListener = new HighlightPreferenceListener();
    private IPreferenceStore fStore;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SLNStyle getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new SLNStyle(SLNDTPlugin.getDefault());
            }
        }
        return fInstance;
    }

    public SLNStyle(AbstractUIPlugin plugin) {
        this.fPlugin = plugin;
        this.fStore = this.fPlugin.getPreferenceStore();
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    public void dispose() {
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fPreferenceListener = null;
    }

    public boolean isSemanticHighlightEnabled() {
        if (this.fSemanticHighlight != null) {
            return this.fSemanticHighlight;
        }
        this.fSemanticHighlight = this.fStore.getBoolean("highlight.semantic.value");
        return this.fSemanticHighlight;
    }

    public boolean isTemplateIdentifierHighlightEnabled() {
        if (this.fTemplateIdentifierHighlight != null) {
            return this.fTemplateIdentifierHighlight;
        }
        this.fTemplateIdentifierHighlight = this.fStore.getBoolean("highlight.template_id.value");
        return this.fTemplateIdentifierHighlight;
    }

    public boolean isXTemplateIdentifierHighlightEnabled() {
        if (this.fXTemplateIdentifierHighlight != null) {
            return this.fXTemplateIdentifierHighlight;
        }
        this.fXTemplateIdentifierHighlight = this.fStore.getBoolean("highlight.x_template_id.value");
        return this.fXTemplateIdentifierHighlight;
    }

    public void updateTokens() {
        for (Map.Entry<String, Token> pair : this.fTokenMap.entrySet()) {
            String key = pair.getKey();
            pair.getValue().setData((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(PreferenceConverter.getColor((IPreferenceStore)this.fStore, (String)(String.valueOf(key) + ".color"))), null, (this.fStore.getBoolean(String.valueOf(key) + ".bold") ? 1 : 0) | (this.fStore.getBoolean(String.valueOf(key) + ".italic") ? 2 : 0) | (key.contains("highlight.comment_hyperlink") ? 0x40000000 : 0)));
        }
    }

    public IToken getToken(String key) {
        Token res = this.fTokenMap.get(key);
        if (res != null) {
            return res;
        }
        res = new Token((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(PreferenceConverter.getColor((IPreferenceStore)this.fStore, (String)(String.valueOf(key) + ".color"))), null, (this.fStore.getBoolean(String.valueOf(key) + ".bold") ? 1 : 0) | (this.fStore.getBoolean(String.valueOf(key) + ".italic") ? 2 : 0) | (key.contains("highlight.comment_hyperlink") ? 0x40000000 : 0)));
        this.fTokenMap.put(key, res);
        return res;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        if (p.endsWith(".color")) {
            this.adaptColorChange(this.fTokenMap.get(p.substring(0, p.length() - ".color".length())), event);
        } else if (p.endsWith(".bold")) {
            this.adaptToStyleChange(this.fTokenMap.get(p.substring(0, p.length() - ".bold".length())), event, 1);
        } else if (p.endsWith(".italic")) {
            this.adaptToStyleChange(this.fTokenMap.get(p.substring(0, p.length() - ".italic".length())), event, 2);
        } else if (p.endsWith(".semantic.value")) {
            boolean eventValue = false;
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                eventValue = (Boolean)value;
            } else if ("true".equals(value)) {
                eventValue = true;
            }
            this.fSemanticHighlight = eventValue;
        } else if (p.endsWith(".x_template_id.value")) {
            boolean eventValue = false;
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                eventValue = (Boolean)value;
            } else if ("true".equals(value)) {
                eventValue = true;
            }
            this.fXTemplateIdentifierHighlight = eventValue;
        } else if (p.endsWith(".template_id.value")) {
            boolean eventValue = false;
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                eventValue = (Boolean)value;
            } else if ("true".equals(value)) {
                eventValue = true;
            }
            this.fTemplateIdentifierHighlight = eventValue;
        }
    }

    private void adaptColorChange(Token token, PropertyChangeEvent event) {
        Object data;
        if (token == null) {
            return;
        }
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null && (data = token.getData()) instanceof TextAttribute) {
            TextAttribute oldAttr = (TextAttribute)data;
            token.setData((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(rgb), oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        if (token == null) {
            return;
        }
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }

    private class HighlightPreferenceListener
    implements IPropertyChangeListener {
        private HighlightPreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!event.getProperty().startsWith("highlight")) {
                return;
            }
            SLNStyle.this.adaptToPreferenceChange(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()));
        }
    }
}

