/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.slndt.ui.launch.preferences;

import java.io.File;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.edt.base.utils.EDTFileUtils;
import ro.amiq.slndt.core.SLNDTPlugin;

public class SpecmanPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text fVrstHomeText;
    private Button fVrstHomeButton;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(SLNDTPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        composite.setLayout((Layout)compositeLayout);
        Group vrstHomeGroup = new Group(composite, 16);
        GridData vrstHomeGroupGridData = new GridData(768);
        vrstHomeGroup.setLayoutData((Object)vrstHomeGroupGridData);
        vrstHomeGroup.setText("VRST_HOME");
        GridLayout groupLayout = new GridLayout(2, false);
        vrstHomeGroup.setLayout((Layout)groupLayout);
        this.fVrstHomeText = new Text((Composite)vrstHomeGroup, 2048);
        GridData directoryTextGridData = new GridData(768);
        this.fVrstHomeText.setLayoutData((Object)directoryTextGridData);
        this.fVrstHomeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                File env;
                SpecmanPreferencesPage.this.setValid(true);
                SpecmanPreferencesPage.this.setErrorMessage(null);
                String vrstHome = SpecmanPreferencesPage.this.fVrstHomeText.getText();
                if (vrstHome.length() > 0 && !(env = new File(String.valueOf(vrstHome) + "/env.sh")).exists()) {
                    SpecmanPreferencesPage.this.setErrorMessage("env.sh not found in '" + vrstHome + "'.");
                    SpecmanPreferencesPage.this.setValid(false);
                }
            }
        });
        this.fVrstHomeText.setText(this.getPreferenceStore().getString("ro.amiq.slndt.VRST_HOME"));
        this.fVrstHomeButton = new Button((Composite)vrstHomeGroup, 8);
        this.fVrstHomeButton.setText("Browse...");
        GridData directoryButtonGridData = new GridData(32);
        this.fVrstHomeButton.setLayoutData((Object)directoryButtonGridData);
        this.fVrstHomeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File f = new File(SpecmanPreferencesPage.this.fVrstHomeText.getText());
                String filterPath = f.exists() ? SpecmanPreferencesPage.this.fVrstHomeText.getText() : EDTFileUtils.getInstance().getLastDirectory();
                DirectoryDialog directoryDialog = new DirectoryDialog(SpecmanPreferencesPage.this.getShell());
                directoryDialog.setFilterPath(filterPath);
                String selectedDirectory = directoryDialog.open();
                if (selectedDirectory != null) {
                    SpecmanPreferencesPage.this.fVrstHomeText.setText(selectedDirectory);
                    EDTFileUtils.getInstance().setLastDirectory(selectedDirectory);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label vrstHomeInfoLabel = new Label((Composite)vrstHomeGroup, 0);
        vrstHomeInfoLabel.setText("Default (empty) means use the shell system variable.");
        GridData directoryLabelGridData = new GridData(768);
        directoryLabelGridData.horizontalSpan = 2;
        vrstHomeInfoLabel.setLayoutData((Object)directoryLabelGridData);
        return composite;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fVrstHomeText.setText(this.getPreferenceStore().getDefaultString("ro.amiq.slndt.VRST_HOME"));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("ro.amiq.slndt.VRST_HOME", this.fVrstHomeText.getText());
        SLNDTPlugin.getDefault().savePreferences();
        return true;
    }

    public void dispose() {
        if (this.fVrstHomeText != null) {
            this.fVrstHomeText.dispose();
        }
        if (this.fVrstHomeButton != null) {
            this.fVrstHomeButton.dispose();
        }
        super.dispose();
    }
}

