/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.slndt.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.editor.spelling.SpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.TaskTagDictionary;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellDictionary;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.edt.base.ui.preferences.PrefConst;
import ro.amiq.slndt.core.SLNDTPlugin;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = SLNDTPlugin.getDefault().getPreferenceStore();
        this.initializeLimitTextLength(store);
        this.initializeSyntaxPreferences(store);
        this.initializeOutlinePreferences(store);
        this.initializeContentAssistPreferences(store);
        this.initializeTypingPreferences(store);
        this.initializeAutoindentPreferences(store);
        this.initializeEditorPreferences(store);
        this.initializeLanguageElements();
        this.initializeOverrideMethodsPreferences(store);
    }

    private void initializeLimitTextLength(IPreferenceStore store) {
        store.setDefault("outline.short_text", true);
    }

    void initializeSyntaxPreferences(IPreferenceStore store) {
        store.setDefault("highlight.semantic.value", true);
        store.setDefault("highlight.template_id.value", true);
        store.setDefault("highlight.x_template_id.value", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.default.color", (RGB)PrefConst.DEFAULT_COLOR);
        store.setDefault("highlight.default.bold", false);
        store.setDefault("highlight.default.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.openclose.color", (RGB)PrefConst.OPENCLOSE_COLOR);
        store.setDefault("highlight.openclose.bold", true);
        store.setDefault("highlight.openclose.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment.color", (RGB)PrefConst.COMMENT_COLOR);
        store.setDefault("highlight.comment.bold", false);
        store.setDefault("highlight.comment.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_task.color", (RGB)PrefConst.COMMENT_TASK_COLOR);
        store.setDefault("highlight.comment_task.bold", true);
        store.setDefault("highlight.comment_task.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_pragma.color", (RGB)PrefConst.COMMENT_PRAGMA_COLOR);
        store.setDefault("highlight.comment_pragma.bold", true);
        store.setDefault("highlight.comment_pragma.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.javadoc_tags.color", (RGB)PrefConst.JAVADOCS_TAGS_COLOR);
        store.setDefault("highlight.javadoc_tags.bold", true);
        store.setDefault("highlight.javadoc_tags.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.keyword.color", (RGB)PrefConst.KEYWORD_COLOR);
        store.setDefault("highlight.keyword.bold", true);
        store.setDefault("highlight.keyword.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.keyphrase.color", (RGB)PrefConst.KEYPHRASE_COLOR);
        store.setDefault("highlight.keyphrase.bold", true);
        store.setDefault("highlight.keyphrase.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.preproc.color", (RGB)PrefConst.PREPROC_COLOR);
        store.setDefault("highlight.preproc.bold", true);
        store.setDefault("highlight.preproc.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.group.color", (RGB)PrefConst.GROUP_COLOR);
        store.setDefault("highlight.group.bold", true);
        store.setDefault("highlight.group.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_constant.color", (RGB)PrefConst.CONSTANT_COLOR);
        store.setDefault("highlight.semantic_constant.bold", true);
        store.setDefault("highlight.semantic_constant.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.unit.color", (RGB)PrefConst.UNIT_COLOR);
        store.setDefault("highlight.unit.bold", true);
        store.setDefault("highlight.unit.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.number.color", (RGB)PrefConst.NUMBER_COLOR);
        store.setDefault("highlight.number.bold", false);
        store.setDefault("highlight.number.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.string.color", (RGB)PrefConst.STRING_COLOR);
        store.setDefault("highlight.string.bold", false);
        store.setDefault("highlight.string.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.hdl_path.color", (RGB)PrefConst.HDL_PATH_COLOR);
        store.setDefault("highlight.hdl_path.bold", false);
        store.setDefault("highlight.hdl_path.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.method.color", (RGB)PrefConst.METHOD_COLOR);
        store.setDefault("highlight.method.bold", false);
        store.setDefault("highlight.method.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.port.color", (RGB)PrefConst.PORT_COLOR);
        store.setDefault("highlight.port.bold", false);
        store.setDefault("highlight.port.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.event.color", (RGB)PrefConst.EVENT_COLOR);
        store.setDefault("highlight.event.bold", false);
        store.setDefault("highlight.event.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.replace.color", (RGB)PrefConst.REPLACE_COLOR);
        store.setDefault("highlight.replace.bold", false);
        store.setDefault("highlight.replace.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.exp_literal.color", (RGB)PrefConst.EXP_LITERAL_COLOR);
        store.setDefault("highlight.exp_literal.bold", false);
        store.setDefault("highlight.exp_literal.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.exp_replace.color", (RGB)PrefConst.EXP_REPLACE_COLOR);
        store.setDefault("highlight.exp_replace.bold", true);
        store.setDefault("highlight.exp_replace.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.template_id.color", (RGB)PrefConst.PREFIX_COLOR);
        store.setDefault("highlight.template_id.bold", false);
        store.setDefault("highlight.template_id.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_hyperlink.color", (RGB)PrefConst.COMMENT_HYPERLINK_COLOR);
        store.setDefault("highlight.comment_hyperlink.bold", false);
        store.setDefault("highlight.comment_hyperlink.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_argument.color", (RGB)PrefConst.SEMANTIC_ARGUMENT_COLOR);
        store.setDefault("highlight.semantic_argument.bold", false);
        store.setDefault("highlight.semantic_argument.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_field.color", (RGB)PrefConst.SEMANTIC_FIELD_COLOR);
        store.setDefault("highlight.semantic_field.bold", false);
        store.setDefault("highlight.semantic_field.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_types.color", (RGB)PrefConst.SEMANTIC_TYPE_COLOR);
        store.setDefault("highlight.semantic_types.bold", true);
        store.setDefault("highlight.semantic_types.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_variable.color", (RGB)PrefConst.SEMANTIC_VARIABLE_COLOR);
        store.setDefault("highlight.semantic_variable.bold", false);
        store.setDefault("highlight.semantic_variable.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_out_port.color", (RGB)PrefConst.SEMANTIC_OUT_PORT_COLOR);
        store.setDefault("highlight.semantic_out_port.bold", false);
        store.setDefault("highlight.semantic_out_port.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.label.color", (RGB)PrefConst.SEMANTIC_LABEL_COLOR);
        store.setDefault("highlight.label.bold", true);
        store.setDefault("highlight.label.italic", false);
    }

    void initializeLanguageElements() {
        IPreferenceStore store = SLNDTPlugin.getDefault().getPreferenceStore();
        store.setDefault("e.language.keywords.actions", "table;external;empty;undefined;statements;try_ie;first;report;compute;return;var;try;gen;keeping;print;check;that;assert;exclusive_start;start;stop;abort;if;then;else;case;default;while;repeat;until;for;from;to;step;do;do_and_grab;in;in_set;matching;break;continue;force;release;emit;wait;sync;sln_emit;sln;code;");
        store.setDefault("e.language.keywords.struct_member", "table;statements;soft_const;when;is;keep;prev;soft;select;before;cover;using;item;transition;cross;ranges;range;attribute;event;on;expect;assume;compound;exec;bind;method;conditional;constraint;child;disable;initial;write_once;action;");
        store.setDefault("e.language.keywords.statements", "annotation;table;uvm_ml_type_match;template;package;import;method_type;define;as;type;struct;unit;interface;like;extend;implementing;routine;sequence;repeatable;export;conditions;token;component;action;function;");
        store.setDefault("e.language.keywords.expressions", "in_table;new;with;now;not;or;and;others;pass;edges;;");
        store.setDefault("e.language.keywords.temporal_expressions", "cycle;consume;exec;eventually;detach;delay;fail;change;rise;fall;true;;");
        store.setDefault("e.language.keywords.access_modifiers", "private;protected;final;static;const;input;output;inout;lock;share;resource;");
        store.setDefault("e.language.keywords.types", ";;");
        store.setDefault("e.language.keywords.simulator_members", ";;");
        store.setDefault("sln.language.keywords.scenario_construction_directives", "before;same_time;in;constraint;table");
        store.setDefault("e.language.keyphrases.statements", "table count;table from;table count from;vhdl object;as computed;verilog import;cvl method;cvl callback;cvl call;is C routine;C export;export C;is import C;is import foreign C;verilog time;vhdl time;add port attribute;abstract action;abstract component;macro action;non_macro action;");
        store.setDefault("e.language.keyphrases.struct_member", "table count;table from;table count from;is empty;is undefined;is inline;is inline only;is also;is first;is only;using also;keep soft;keep gen;keep for each;is dynamic C routine;is foreign C routine;is foreign dynamic C routine;with any;is imported;starting from;constraint any;constraint soft;constraint default;token default value;abstract action;macro action;non_macro action;");
        store.setDefault("e.language.keyphrases.actions", "table count;table from;table count from;check that;assert that;down to;for each;in reverse;using index;for each line;in file;for each file;all of;first of;state machine;;");
        store.setDefault("e.language.keyphrases.expressions", "is a;is not a;is an;is not an;is not empty;not in;;");
        store.setDefault("e.language.keyphrases.temporal_expressions", ";;");
        store.setDefault("e.language.keyphrases.access_modifiers", ";;");
        store.setDefault("e.language.keyphrases.types", "is instance;list of;in interface_port of;out interface_port of;export interface_port of;interface_port of;interface_imp of;interface_export of;simple_port of;in simple_port of;out simple_port of;inout simple_port of;event_port;in event_port;out event_port;inout event_port;in method_port of;out method_port of;in buffer_port of;out buffer_port of;;");
        store.setDefault("e.language.keyphrases.simulator_members", "verilog simulator;verilog code;verilog function;verilog task;verilog variable;vhdl simulator;vhdl code;vhdl function;vhdl procedure;vhdl driver;;");
        store.setDefault("sln.language.keyphrases.scenario_construction_directives", "constraint soft;table count;table from;table count from;");
        store.setDefault("e.language.scalar_types", "bool;bit;byte;nibble;int;uint;time;string;file;mvl;real;set;;");
        store.setDefault("e.language.constants", "TRUE;FALSE;NULL;UNDEF;MAX_INT;MIN_INT;MAX_UINT;MIN_LONGINT;MAX_LONGINT;MAX_LONGUINT;Strength_NONE;Strength_HiZ;Strength_SmallCharge;Strength_MediumCharge;Strength_LargeCharge;Strength_WeakDrive;Strength_PullDrive;Strength_StrongDrive;Strength_SupplyDrive;");
        store.setDefault("e.language.units", "hr;min;sec;ms;us;ns;ps;fs");
        store.setDefault("e.language.preproc", "#define;#ifdef;#ifndef;#undef;#else;;");
    }

    void initializeOutlinePreferences(IPreferenceStore store) {
        store.setDefault("outline.prefs_changed", false);
        store.setDefault("outline.show_methods", true);
        store.setDefault("outline.show_fields", true);
        store.setDefault("outline.show_events", true);
        store.setDefault("outline.show_onevent", true);
        store.setDefault("outline.show_macros", true);
        store.setDefault("outline.show_coverdefs", true);
        store.setDefault("outline.show_expects", true);
        store.setDefault("outline.show_types", true);
        store.setDefault("outline.show_structs", true);
        store.setDefault("outline.show_methodtypes", true);
        store.setDefault("outline.show_actions", true);
        store.setDefault("outline.show_components", true);
        store.setDefault("outline.show_tokens", true);
        DVTPredefinedGUIFilters.putOutlinePredefinedGUIFilter((LanguageKind)LanguageKind.SLN, (IPreferenceStore)store);
    }

    void initializeContentAssistPreferences(IPreferenceStore store) {
        store.setDefault("ca.ignore_case", true);
        store.setDefault("ca.camel_case", true);
        store.setDefault("ca.prefix_match", true);
        store.setDefault("ca.chars_trigger", ".,@,%,= ,: ,on ,emit ,keep ,cover ,extend ,like ,when, import ");
        store.setDefault("ca.insert_optional_arguments", true);
        store.setDefault("ca.auto_insert_single", false);
    }

    void initializeTypingPreferences(IPreferenceStore store) {
        store.setDefault("typing.quote_case", true);
        store.setDefault("typing.paran_case", true);
        store.setDefault("typing.brack_case", true);
        store.setDefault("typing.curly_case", true);
        store.setDefault("typing.enclose.brack_case", true);
        store.setDefault("typing.enclose.curly_case", true);
        store.setDefault("typing.enclose.paran_case", true);
        store.setDefault("typing.enclose.quote_case", true);
        store.setDefault("typing.transform_semicolon_to_assign", true);
    }

    void initializeAutoindentPreferences(IPreferenceStore store) {
        store.setDefault("autoindent.disabled", false);
    }

    void initializeEditorPreferences(IPreferenceStore store) {
        store.setDefault("editor.jump_to_defined_method_layer", true);
        store.setDefault("disable.compareviewer", 100000);
        store.setDefault("editor.disable_tool_tips", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"inactiveCodeHighlightColor", (RGB)PrefConst.INACTIVE_CODE_HIGHLIGHT_COLOR_VAL);
        store.setDefault("inactiveCodeHighlightEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)EditorsUI.getPreferenceStore(), (String)"matchingBracketsEColor", (RGB)PrefConst.MATCHING_BRACKETS_HIGHLIGHT_COLOR_VAL);
        EditorsUI.getPreferenceStore().setDefault("matchingBracketsEEnable", true);
        SpellCheckEngine.getInstance().registerDictionary((ISpellDictionary)new TaskTagDictionary(store));
        store.setDefault("editor.codeFolding", true);
        store.setDefault("editor.numberOfLines", 10000);
        store.setDefault("editor.manualCodeFolding", true);
        store.setDefault("format.capitalization.keywords", 1);
        store.setDefault("format.capitalization.data_types", 1);
        store.setDefault("format.capitalization.attributes", 1);
        store.setDefault("format.whitespace.trim_end_of_line", true);
        store.setDefault("format.whitespace.trim_whitespace_line", true);
        store.setDefault("format.whitespace.compact", false);
        store.setDefault("format.whitespace.compact_consecutive_empty_lines", false);
        store.setDefault("format.whitespace.maximum_nof_consecutive_empty_lines", 1);
        store.setDefault("format.whitespace.add_after", "");
        store.setDefault("format.whitespace.add_before", "");
        store.setDefault("format.indent.begin", 1);
        store.setDefault("format.indent.else", 1);
        store.setDefault("format.indent.params", 1);
        store.setDefault("format.indent.preproc", 1);
        store.setDefault("format.indent.preserve_sl_comment_column_zero", true);
        store.setDefault("format.indent.multiline_comments", true);
        store.setDefault("format.indent.no_indent_keywords", "");
        store.setDefault("format.indent.ignore_lines", "");
        store.setDefault("format.line_wrap", false);
        store.setDefault("format.line_wrap.threshold", 80);
        store.setDefault("format.line_wrap.sl_comments", false);
        store.setDefault("format.line_wrap.ml_comments", false);
        store.setDefault("format.vertical_align", false);
        store.setDefault("format.vertical_align.tokens", "=,==");
        store.setDefault("format.vertical_align.sl_comments", false);
        store.setDefault("format.vertical_align.paren", false);
        store.setDefault("format.vertical_align.curly", false);
        store.setDefault("format.vertical_align.vregex", "");
        store.setDefault("format.pre_external", false);
        store.setDefault("format.pre_external.command", "pre_format_code %f");
        store.setDefault("format.post_external", false);
        store.setDefault("format.post_external.command", "post_format_code %f");
        store.setDefault("format.external", false);
        store.setDefault("format.external.command", "format_code %f");
        store.setDefault("format.preview.show_invisible_characters", false);
        store.setDefault("format.preview.line_wrap_threshold", 50);
        store.setDefault("format.format_on_paste", "Disabled");
    }

    void initializeOverrideMethodsPreferences(IPreferenceStore store) {
        store.setDefault("override.methods.onlyEmptyOrUndefined", false);
    }
}

