/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.slndt.ui.syntaxerrors;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.IDVTReparseListener;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.model.IEReparseListener;
import ro.amiq.edt.base.model.problems.Bridge;
import ro.amiq.etools.eparser.EToolsException;
import ro.amiq.slndt.model.SLNModelManager;

public class SyntaxErrorsManager
implements IEReparseListener {
    public static final String SYNTAX_ERROR_MARKER_ID = "ro.amiq.slndt.SyntaxProblemMarker";
    private static volatile SyntaxErrorsManager fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private SyntaxErrorsManager() {
        DVTProblemsUiUpdaterRegistry.register((DVTProblemsUiUpdater)new DVTProblemsUiUpdater(EProblemCategories.SLN_SYNTAX));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyntaxErrorsManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new SyntaxErrorsManager();
            }
        }
        return fInstance;
    }

    public void startup() {
        SLNModelManager.getInstance().addReparseListener((IDVTReparseListener)this);
    }

    public void shutdown() {
        SLNModelManager.getInstance().removeReparseListener((IDVTReparseListener)this);
    }

    public void reparsed(int buildKind, int type, IResource resource, List errors, List warnings, List tasks) {
        boolean isNonTopFile;
        IProject project = resource.getProject();
        if (project == null) {
            return;
        }
        if (!resource.isAccessible() || !(resource instanceof IFile)) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F736C6E")) {
            return;
        }
        DVTProblemManager.getInstance().removeProblemsWithCategoryAndPath(project, EProblemCategories.SLN_SYNTAX, Utils.canonicPath((IPath)resource.getLocation()));
        boolean bl = isNonTopFile = PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE) == null && PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_ACTIVE_TEST_FILE) == null && PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_TEST_FILE) == null;
        if (errors != null && !errors.isEmpty()) {
            for (Object error : errors) {
                EToolsException eSyntaxError = (EToolsException)error;
                if (eSyntaxError.getLine() == -1234567890) continue;
                if (isNonTopFile) {
                    eSyntaxError.errorCode = "_" + eSyntaxError.errorCode;
                }
                DVTProblemManager.getInstance().reportProblem(Bridge.from((IProject)project, (EToolsException)eSyntaxError, (String)Utils.canonicPath((IPath)resource.getLocation()), (buildKind == 1 ? 1 : 0) != 0, (boolean)true));
            }
        }
        if (warnings != null && !warnings.isEmpty()) {
            for (Object warning : warnings) {
                EToolsException eSyntaxWarning = (EToolsException)warning;
                if (eSyntaxWarning.getLine() == -1234567890) continue;
                if (isNonTopFile) {
                    eSyntaxWarning.errorCode = "_" + eSyntaxWarning.errorCode;
                }
                DVTProblemManager.getInstance().reportProblem(Bridge.from((IProject)project, (EToolsException)eSyntaxWarning, (String)Utils.canonicPath((IPath)resource.getLocation()), (buildKind == 1 ? 1 : 0) != 0, (boolean)true));
            }
        }
        DVTProblemsUiUpdaterRegistry.get((String)EProblemCategories.SLN_SYNTAX.getId()).update((IFile)resource, buildKind == 1);
    }

    public void updateProblemsUI(IProject project, List<EToolsException> unreportedErrors) {
        for (EToolsException error : unreportedErrors) {
            DVTProblemManager.getInstance().reportProblem(Bridge.from((IProject)project, (EToolsException)error, (String)error.getFilename(), (boolean)true, (boolean)true));
        }
        DVTProblemsUiUpdaterRegistry.get((String)EProblemCategories.SLN_SYNTAX.getId()).updateOutsideErrors(project);
    }
}

