/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.ide;

import com.swtxml.definition.INamespaceDefinition;
import com.swtxml.extensions.ExtensionsNamespaceResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocumentNamespaceBrowser {
    private Map<String, INamespaceDefinition> definitionByURI = new HashMap<String, INamespaceDefinition>();
    private Map<INamespaceDefinition, String> prefixByDefinition = new HashMap<INamespaceDefinition, String>();

    public DocumentNamespaceBrowser(Document doc) {
        ExtensionsNamespaceResolver resolver = new ExtensionsNamespaceResolver();
        NamedNodeMap attributes = doc.getDocumentElement().getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attr = attributes.item(i);
            String nodeName = attr.getNodeName();
            if (nodeName.startsWith("xmlns")) {
                String prefix = nodeName;
                prefix = prefix.startsWith("xmlns:") ? prefix.substring(6) : prefix.substring(5);
                String uri = attr.getNodeValue();
                INamespaceDefinition namespaceDefinition = resolver.resolveNamespace(uri);
                if (namespaceDefinition != null) {
                    this.definitionByURI.put(uri, namespaceDefinition);
                    this.prefixByDefinition.put(namespaceDefinition, prefix);
                }
            }
            ++i;
        }
    }

    public INamespaceDefinition getByURI(String namespaceURI) {
        return this.definitionByURI.get(namespaceURI);
    }

    public Collection<INamespaceDefinition> getAllDefinitions() {
        return this.definitionByURI.values();
    }

    public String getPrefix(INamespaceDefinition namespace) {
        String prefix = this.prefixByDefinition.get(namespace);
        if (prefix == null) {
            return null;
        }
        return prefix.length() > 0 ? String.valueOf(prefix) + ":" : "";
    }
}

