/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.ide;

import com.swtxml.resources.IDocumentResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import org.eclipse.jface.text.IDocument;
import org.xml.sax.InputSource;

public class PreviewResource
implements IDocumentResource {
    private File file;
    private IDocument document;
    private final File rootOfProject;

    public PreviewResource(File rootOfProject, File file, IDocument document) {
        this.rootOfProject = rootOfProject;
        this.file = file;
        this.document = document;
    }

    public String getDocumentName() {
        return this.file == null ? "unknown" : this.file.getName();
    }

    public InputSource getInputSource() {
        return new InputSource(new StringReader(this.document.get()));
    }

    public InputStream resolve(String path) {
        File f = null;
        if (this.rootOfProject != null && path.startsWith("bundle:")) {
            f = new File(this.rootOfProject, path.substring("bundle:".length()));
        } else if (this.file != null) {
            f = new File(this.file.getParent(), path);
        }
        if (f != null && f.exists()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }
}

