/*
 * Decompiled with CFR 0.152.
 */
package com.swtxml.ide;

import com.swtxml.ide.Activator;
import com.swtxml.ide.ErrorComposite;
import com.swtxml.ide.PreviewResource;
import com.swtxml.ide.ResizableComposite;
import com.swtxml.ide.SwtXmlModelHandler;
import com.swtxml.resources.IDocumentResource;
import com.swtxml.swt.SwtXmlParser;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PreviewViewPart
extends ViewPart {
    public static final String VIEW_ID = PreviewViewPart.class.getName();
    private IEditorPart swtXmlEditorPart;
    private IEditorPart propertiesFileEditorPart;
    private final IPropertyListener updatePreviewOnSavePropertiesFile = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 257 && source == PreviewViewPart.this.propertiesFileEditorPart && !PreviewViewPart.this.propertiesFileEditorPart.isDirty()) {
                PreviewViewPart.this.updatePreview(true);
            }
        }
    };
    private final IPropertyListener updatePreviewOnSaveSwtXml = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 257 && source == PreviewViewPart.this.swtXmlEditorPart && !PreviewViewPart.this.swtXmlEditorPart.isDirty()) {
                PreviewViewPart.this.updatePreview(false);
            }
        }
    };
    private final IPartListener trackRelevantEditorsPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            PreviewViewPart.this.tryConnectTo(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            this.partDeactivated(part);
            if (part == PreviewViewPart.this.swtXmlEditorPart) {
                PreviewViewPart.this.clearSWTXMLConnection();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == PreviewViewPart.this.propertiesFileEditorPart) {
                PreviewViewPart.this.clearPropertiesFileConnection();
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private long lastPreviewModificationStamp;
    private Composite container;
    private Action resizeAction;

    public void createPartControl(Composite parent) {
        this.resizeAction = new Action("Resize", 2){

            public void run() {
                PreviewViewPart.this.updatePreview(true);
            }
        };
        this.resizeAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"com.swtxml.ide", (String)"/icons/resize.png"));
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(parent);
        ToolBar toolbar = new ToolBar(parent, 0x800200);
        toolbar.setBackground(toolbar.getDisplay().getSystemColor(15));
        ToolBarManager toolbarManager = new ToolBarManager(toolbar);
        toolbarManager.add((IAction)this.resizeAction);
        GridDataFactory.fillDefaults().grab(false, true).align(1, 4).applyTo((Control)toolbar);
        toolbarManager.update(true);
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new FillLayout());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.container);
        this.getSite().getPage().addPartListener(this.trackRelevantEditorsPartListener);
        this.tryConnectTo((IWorkbenchPart)this.getSite().getPage().getActiveEditor());
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.trackRelevantEditorsPartListener);
        this.clearSWTXMLConnection();
        this.clearPropertiesFileConnection();
        super.dispose();
    }

    private void tryConnectTo(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IStructuredModel model = (IStructuredModel)part.getAdapter(IStructuredModel.class);
            if (part != this.swtXmlEditorPart && model != null && SwtXmlModelHandler.associatedContentTypeID.equals(model.getContentTypeIdentifier())) {
                this.connectTo(part);
            } else if (((IEditorPart)part).getEditorInput() instanceof FileEditorInput && ((FileEditorInput)((IEditorPart)part).getEditorInput()).getFile().toString().endsWith(".properties")) {
                this.propertiesFileEditorPart = (IEditorPart)part;
                this.propertiesFileEditorPart.addPropertyListener(this.updatePreviewOnSavePropertiesFile);
            }
        }
    }

    private void connectTo(IWorkbenchPart part) {
        this.clearSWTXMLConnection();
        this.clearPropertiesFileConnection();
        this.swtXmlEditorPart = (IEditorPart)part;
        part.addPropertyListener(this.updatePreviewOnSaveSwtXml);
        this.updatePreview(false);
    }

    private void clearPropertiesFileConnection() {
        if (this.propertiesFileEditorPart != null) {
            this.propertiesFileEditorPart.removePropertyListener(this.updatePreviewOnSavePropertiesFile);
            this.propertiesFileEditorPart = null;
        }
    }

    public void clearSWTXMLConnection() {
        if (this.swtXmlEditorPart != null) {
            this.swtXmlEditorPart.removePropertyListener(this.updatePreviewOnSaveSwtXml);
            this.setContent(null);
            this.swtXmlEditorPart = null;
        }
    }

    private void updatePreview(boolean force) {
        if (this.swtXmlEditorPart == null) {
            this.setContent(null);
            return;
        }
        IDocument doc = (IDocument)this.swtXmlEditorPart.getAdapter(IDocument.class);
        IDocumentExtension4 document = (IDocumentExtension4)doc;
        if (force || document.getModificationStamp() != this.lastPreviewModificationStamp) {
            try {
                try {
                    Composite swtXmlComposite;
                    ResizableComposite newComposite;
                    ResizableComposite resizableComposite = null;
                    if (this.resizeAction.isChecked()) {
                        newComposite = resizableComposite = new ResizableComposite(this.container);
                        swtXmlComposite = resizableComposite.getResizeableComposite();
                    } else {
                        swtXmlComposite = new Composite(this.container, 0);
                        newComposite = swtXmlComposite;
                    }
                    IEditorInput editorInput = this.swtXmlEditorPart.getEditorInput();
                    ILocationProvider locationProvider = (ILocationProvider)editorInput.getAdapter(ILocationProvider.class);
                    File file = locationProvider == null ? null : locationProvider.getPath((Object)editorInput).toFile();
                    SwtXmlParser parser = new SwtXmlParser(swtXmlComposite, (IDocumentResource)new PreviewResource(this.getProjectRootDir(editorInput), file, doc), null);
                    parser.parse();
                    this.setContent(newComposite);
                    if (resizableComposite != null) {
                        resizableComposite.resetSize();
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "com.swtxml.ide", e.getMessage(), (Throwable)e));
                    this.setContent((Composite)new ErrorComposite(this.container, 0, e));
                    this.lastPreviewModificationStamp = document.getModificationStamp();
                    this.container.layout();
                }
            }
            finally {
                this.lastPreviewModificationStamp = document.getModificationStamp();
                this.container.layout();
            }
        }
    }

    private File getProjectRootDir(IEditorInput editorInput) {
        if (!(editorInput instanceof FileEditorInput)) {
            return null;
        }
        FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
        return fileEditorInput.getFile().getProject().getLocation().toFile();
    }

    private void setContent(Composite content) {
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c != content) {
                c.dispose();
            }
            ++n2;
        }
    }

    public void setFocus() {
        if (this.container != null) {
            this.container.setFocus();
        }
    }
}

